<?php
/**
 * Main application class
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

//
//Include all function files
require_once( IPVISC_LIB . '/config.php' );
require_once( IPVISC_LIB . '/setting.php' );
require_once( IPVISC_LIB . '/db.php' );
require_once( IPVISC_LIB . '/font.php' );
require_once( IPVISC_LIB . '/faicon.php' );
require_once( IPVISC_LIB . '/form.php' );
require_once( IPVISC_LIB . '/model.php' );
require_once( IPVISC_LIB . '/modelStyle.php' );
require_once( IPVISC_LIB . '/modelStat.php' );
require_once( IPVISC_APP . '/controller.php' );
require_once( IPVISC_APP . '/viewer.php' );

if ( ! class_exists( 'IPVisc_App' ))
{
  class IPVisc_App
  {
    //{{ run

    /**
     * Run all functions
     *
     * @return void
     */
    public static function run()
    {
      $hook = sanitize_title( IPVISC_TITLE );

      //Install Plugin
      register_activation_hook( __FILE__, array( __CLASS__, 'install' ) );

      //Hook for plugin loaded
      add_action( 'plugins_loaded', array( __CLASS__, 'updateDb' ) );

      //
      //Admin init
      add_action( 'admin_init', array( __CLASS__, 'adminInit' ) );

      //
      //Register admin menu
      add_action( 'admin_menu', array( __CLASS__, 'addAdminMenu' ) );

      //
      //Shortcode setup
      //

      // Add generator shortcode button
      add_action( 'init', array( __CLASS__, 'addShortcodeEditorButton' ), 100 );
      // Add pop up content
      add_filter( 'the_editor', array( __CLASS__, 'shortcodeEditorFilter' ) );
      add_action( 'admin_footer', array( __CLASS__, 'addShortcodeForm' ) );
      //Add Shortcode
      add_shortcode( 'video_scroll', array( __CLASS__, 'shortcode' ) );

      //
      //Add css
      add_action( 'admin_print_styles-toplevel_page_' . IPVISC_PAGENAME, array( __CLASS__, 'adminStyle' ), 1100 );
      add_action( 'admin_print_styles-'.$hook.'_page_' . IPVISC_PAGENAME . '-addnew', array( __CLASS__, 'adminStyle' ), 1100 );
      add_action( 'admin_print_styles-'.$hook.'_page_' . IPVISC_PAGENAME . '-style', array( __CLASS__, 'adminStyle' ), 1100 );
      add_action( 'admin_print_styles', array( __CLASS__, 'adminGlobalStyle' ), 1000 );

      //
      //Add javascript
      add_action( 'admin_print_scripts-toplevel_page_' . IPVISC_PAGENAME, array( __CLASS__, 'adminScript' ), 1100 );
      add_action( 'admin_print_scripts-'.$hook.'_page_' . IPVISC_PAGENAME . '-addnew', array( __CLASS__, 'adminScript' ), 1100 );
      add_action( 'admin_print_scripts-'.$hook.'_page_' . IPVISC_PAGENAME . '-style', array( __CLASS__, 'adminScript' ), 1100 );
      add_action( 'admin_print_scripts', array( __CLASS__, 'adminGlobalScript' ), 1000 );

      //Front style & script
      add_action('wp_head', array( __CLASS__, 'publicStyle' ) );

      if ( ! is_admin() ) {
        add_action('wp_enqueue_scripts', array( __CLASS__, 'publicScript' ), 10 );
      }
    }
    /**
     * Install plugin
     *
     * @return void
     */
    public static function install()
    {
      //Install DB
      $db = new IPVisc_Db();
      $db->install();
    }

    /**
     * Update Db
     *
     * @return void
     */
    public static function updateDb()
    {
      $db = new IPVisc_Db();
      $db->update();
    }

    //}}
    //{{ addAdminMenu

    /**
     * Add admin menu
     *
     * @return void
     */
    public static function addAdminMenu()
    {
      add_menu_page(
        IPVISC_TITLE,
        IPVISC_TITLE,
        'edit_posts',
        IPVISC_PAGENAME,
        array( __CLASS__, 'dashboard' ),
        'dashicons-playlist-video'
      );
      add_submenu_page(
        IPVISC_PAGENAME,
        __( 'All Videos', IPVISC_SLUG ),
        __( 'All Videos', IPVISC_SLUG ),
        'edit_posts',
        IPVISC_PAGENAME,
        array( __CLASS__, 'dashboard' )
      );
      add_submenu_page(
        IPVISC_PAGENAME,
        __( 'Add Video', IPVISC_SLUG ),
        __( 'Add Video', IPVISC_SLUG ),
        'edit_posts',
        IPVISC_PAGENAME . '-addnew',
        array( __CLASS__, 'addnew' )
      );
      add_submenu_page(
        IPVISC_PAGENAME,
        __( 'Widget Style', IPVISC_SLUG ),
        __( 'Widget Style', IPVISC_SLUG ),
        'edit_posts',
        IPVISC_PAGENAME . '-style',
        array( __CLASS__, 'style' )
      );
    }

    //}}
    //{{ adminInit

    /**
     * Admin init
     *
     * @return void
     */
    public static function adminInit()
    {
      /**
       * Ajax handler
       **/
      $controller = new IPVisc_Controller();
      $controller->ajax();
    }

    //}}
    //{{ dashboard

    /**
     * Render admin dashboard page
     *
     * @return void
     */
    public static function dashboard()
    {
      $viewer = new IPVisc_Viewer();
      if ( ! empty( $_GET['action'] ) && $_GET['action'] == 'edit' ) {
        $viewer->edit();
      } else {
        $viewer->dashboard();
      }
    }

    //}}
    //{{ addnew

    /**
     * Render add new page
     *
     * @return void
     */
    public static function addnew()
    {
      $viewer = new IPVisc_Viewer();
      $viewer->addnew();
    }

    //}}
    //{{ style

    /**
     * Render style page
     *
     * @return void
     */
    public static function style()
    {
      $viewer = new IPVisc_Viewer();
      if ( ! empty( $_GET['action'] ) && $_GET['action'] == 'edit' ) {
        $viewer->editStyle();
      } elseif ( ! empty( $_GET['action'] ) && $_GET['action'] == 'add' ) {
        $viewer->addStyle();
      } else {
        $viewer->style();
      }
    }

    //}}
    //{{ addShortcodeEditorButton

    /**
     * Add shortcode button in content editor
     *
     * @return void
     */
    public static function addShortcodeEditorButton()
    {
      if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') ) {
        return;
      }
      if ( get_user_option('rich_editing') == 'true') {
        add_filter( 'mce_external_plugins', array( __CLASS__, 'addTinymcePlugin' ));
        add_filter( 'mce_buttons', array( __CLASS__, 'registerTinymceButton' ));
      }
    }

    //}}
    //{{ addTinymcePlugin

    /**
     * Add tinyMce plugin
     *
     * @return void
     */
    public static function addTinymcePlugin( $plugin_array )
    {
      $plugin_array['ipvisc_shortcode'] = IPVISC_BASE_URL . '/assets/js/editor-plugin.js';
      return $plugin_array;
    }

    //}}
    //{{ registerTinymceButton

    /**
     * Add tinyMce button
     *
     * @return void
     */
    public static function registerTinymceButton( $buttons )
    {
      array_push($buttons, "|", "ipvisc_shortcode");
      return $buttons;
    }

    //}}
    //{{ shortcodeEditorFilter

    /**
     * The editor filter
     *
     * @param  string $content
     * @return string
     */
    public static function shortcodeEditorFilter( $content )
    {
      global $ipvisc_useEditor;
      $ipvisc_useEditor = true;
      return $content;
    }

    //}}
    //{{ addShortcodeForm

    /**
     * Add shortcode form
     *
     * @return void
     */
    public static function addShortcodeForm()
    {
      global $ipvisc_useEditor;

      wp_enqueue_script('wp-color-picker');
      wp_enqueue_style('wp-color-picker');

      if ( $ipvisc_useEditor ) {
        $viewer = new IPVisc_Viewer();
        $viewer->shortcodeBackend();
      }
    }

    //}}
    //{{ shortcode

    /**
     * Get shortcode
     *
     * @param  array  $atts
     * @param  string $content
     * @return void
     */
    public static function shortcode( $atts, $content = '')
    {
      $viewer = new IPVisc_Viewer();
      return $viewer->shortcode( $atts, $content );
    }

    //}}
    //{{ adminStyle

    /**
     * Add Css file
     *
     * @return void
     */
    public static function adminStyle()
    {
      wp_deregister_style( 'ipvisc-admin-style' );
      wp_register_style('ipvisc-admin-style', IPVISC_BASE_URL . 'assets/css/admin.min.css', false, null);
      wp_enqueue_style('ipvisc-admin-style');

      wp_deregister_style( 'ipvisc-datetime-style' );
      wp_register_style('ipvisc-datetime-style', IPVISC_BASE_URL . 'assets/css/jquery.datetimepicker.css', false, null);
      wp_enqueue_style('ipvisc-datetime-style');
    }

    //}}
    //{{ adminGlobalStyle

    /**
     * Add Css file to all pages
     *
     * @return void
     */
    public static function adminGlobalStyle()
    {
      wp_deregister_style( 'ipvisc-admin-global-style' );
      wp_register_style('ipvisc-admin-global-style', IPVISC_BASE_URL . 'assets/css/admin-global.min.css', false, null);
      wp_enqueue_style('ipvisc-admin-global-style');
    }

    //}}
    //{{ adminScript

    /**
     * Add javascript file
     *
     * @return void
     */
    public static function adminScript()
    {
    ?>
      <script type="text/javascript">
        var ipvisc_img_url = '<?php echo IPVISC_BASE_URL . 'assets/img/'; ?>',
          ui_base_image  = '<?php echo IPVISC_BASE_URL . 'assets/img/'; ?>',
          ui_message     =
          {
            delete_confirm_title: '<?php _e( 'Delete Confirmation', IPVISC_SLUG ); ?>',
            delete_confirm_info: '<?php _e( 'Are you sure doing this action?', IPVISC_SLUG ); ?>'
          }
      </script>
      <?php
      wp_deregister_script('ipvisc-admin-script');
      wp_enqueue_script(
        'ipvisc-admin-script',
        IPVISC_BASE_URL . 'assets/js/admin.js',
        array( 'jquery' ),
        1,
        true
      );
    }

    //}}
    //{{ adminGlobalScript

    /**
     * Add javascript file to all pages
     *
     * @return void
     */
    public static function adminGlobalScript()
    {
      wp_deregister_script('ipvisc-admin-global-script');
      wp_enqueue_script(
        'ipvisc-admin-global-script',
        IPVISC_BASE_URL . 'assets/js/admin-global.min.js',
        array( 'jquery' ),
        1,
        true
      );
    }

    //}}
    //{{ publicStyle

    /**
     * Print public style
     *
     * @return void
     */
    public static function publicStyle()
    {
    ?>
      <script type="text/javascript">
        var ipvisc_ajaxurl = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
        var ipvisc_img_url = '<?php echo IPVISC_BASE_URL . 'assets/img/'; ?>';
      </script>
      <link media="all" type="text/css" href="<?php echo IPVISC_BASE_URL; ?>assets/css/public.min.css" rel="stylesheet">
    <?php
    }

    //}}
    //{{ publicScript

    /**
     * Print public script
     *
     * @return void
     */
    public static function publicScript()
    {
      wp_enqueue_script('jquery');

      wp_deregister_script('jquery-ui');
      wp_register_script('jquery-ui', "http" . ($_SERVER['SERVER_PORT'] == 443 ? "s" : "") . "://ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/jquery-ui.min.js", false, null);
      wp_enqueue_script('jquery-ui');

      wp_deregister_script('ipvisc-public-script');
      wp_enqueue_script(
        'ipvisc-public-script',
        IPVISC_BASE_URL . 'assets/js/public.min.js',
        array( 'jquery' ),
        1,
        true
      );
    }

    //}}
  }
}
