<?php
if ( ! class_exists( 'IPVisc_Controller' ))
{
    /**
     * Controller class
     *
     * @package wp-video-attention
     * @author InstaProduct
     * @link http://insta-product.com/
     */

    class IPVisc_Controller
    {
        //{{ ajax

        /**
         * Ajax handler
         *
         * @return void
         */
        public function ajax()
        {
            $data = array_merge( $_GET, $_POST );
            if ( empty( $data['doajax'] ) || empty( $data['ipvisc'] ) || empty( $data['action'] ) ) {
                return true;
            }
            $action = sanitize_title( $data['action'] );
            $file   = IPVISC_CTRL . 'ajax_' . $action . '.php';
            if ( file_exists( $file ))
            {
                require_once( $file );
                $class = 'IPVisc_Ajax_' . ucfirst( $action );
                if ( class_exists( $class ) ) {
                    $ctrl = new $class();
                    if ( method_exists( $ctrl, 'exec' )) {
                        $ctrl->exec();
                    }
                }
            }
            return true;
        }
    }
}
