<?php
/**
 * Controller to handling deleting style process
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPVisc_Ajax_Delete_style' ))
{
    class IPVisc_Ajax_Delete_style
    {
        /**
         * Execution save options process
         *
         * @return void
         */
        public function exec()
        {
            $item = false;
            if ( ! empty( $_REQUEST['id'] )) {
                $id   = absint( $_REQUEST['id'] );
                $item = get_post( $id );
            }
            if ( ! $item ) {
                echo json_encode( array(
                    'status'   => 0,
                    'message'  => __( 'Error system', IPVISC_SLUG )
                ) );
                die();
            }
            $result = wp_delete_post( $item->ID, true );
            if ( $result ) {
                echo json_encode( array(
                    'status'   => 1,
                    'message'  => __( 'Style successfully deleted', IPVISC_SLUG ),
                    'redirect' => admin_url() . 'admin.php?page=' . IPVISC_PAGENAME . '-style&delete=1'
                ) );
            } else {
                echo json_encode( array(
                    'status'  => 0,
                    'message' => __( 'Failed to remove the style', IPVISC_SLUG )
                ) );
            }
            die();
        }
    }
}
