<?php
/**
 * Controller to handling saving statistic data
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPVisc_Ajax_Savestat' ))
{
  class IPVisc_Ajax_Savestat
  {
    /**
     * Execution save options process
     *
     * @return void
     */
    public function exec()
    {
      $error = true;
      if ( ! empty( $_POST['video_id'] ) && ! empty( $_POST['type'] ))
      {
        $videoId = absint( $_POST['video_id'] );
        if ( $video = get_post( $videoId ))
        {
          $type  = apply_filters( 'pre_term_name', $_POST['type'] );
          $model = new IPVisc_Model_Stat();
          $model->saveStat( $video, $type );

          $error = false;
        }
      }
      if ( $error ) {
        $status = 0;
        $msg    = __( 'Failed to save statistic data.', IPVISC_SLUG );
      } else {
        $status = 1;
        $msg    = __( 'Successfully to save statistic data.', IPVISC_SLUG );
      }
      echo json_encode( array(
        'status'    => $status,
        'message'   => $msg
      ) );
      die();
    }
  }
}
