<?php
/**
 * Controller to handling updating video process
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPVisc_Ajax_Update' ))
{
    class IPVisc_Ajax_Update
    {
        /**
         * Execution save options process
         *
         * @return void
         */
        public function exec()
        {
            $redirect = false;
            $is_add   = false;
            $error    = true;
            if ( ! empty( $_POST['isadd'] )) {
                $is_add = true;
            }
            if ( ! empty( $_POST['video_id'] )) {
                $videoId = absint( $_POST['video_id'] );
                if ( $video = get_post( $videoId ) ) {
                    $this->_updateVideo( $video );
                } else {
                    $videoId = 0;
                }
            } else {
                $videoId = $this->_addVideo();
            }
            if ( $videoId )
            {
                $error = false;
                $model = new IPVisc_Model();
                $model->saveSetting( $videoId );
            }
            if ( $error ) {
                $status   = 0;
                $videoId  = 0;
                if ( $is_add ) {
                    $message = __( 'Failed create video.', IPVISC_SLUG );
                } else {
                    $message = __( 'Failed save video.', IPVISC_SLUG );
                }
            } else {
                $status = 1;
                if ( $is_add ) {
                    $message  = __( 'Successfully created video.', IPVISC_SLUG );
                    $redirect = admin_url() . 'admin.php?page=' . IPVISC_PAGENAME . '&action=edit&id=' . $videoId . '&create=1';
                } else {
                    $message = __( 'Successfully saved video.', IPVISC_SLUG );
                }
            }
            $result = array(
                'status'    => $status,
                'message'   => $message,
                'videoid'   => $videoId
            );
            if ( $redirect ) {
                $result['redirect'] = $redirect;
            }
            echo json_encode( $result );
            die();
        }

        /**
         * Add new video
         *
         * @return int
         */
        protected function _addVideo()
        {
            global $user_ID;

            if ( empty( $_POST['title'] )) {
                $title = 'Unknown';
            } else {
                $title = apply_filters( 'single_post_title', $_POST['title'] );
            }
            if ( $_POST['status'] == 'true' ) {
                $status = 'publish';
            } else {
                $status = 'draft';
            }
            $dataPost = array(
                'post_status'  => $status,
                'post_type'    => 'ipvisc-item',
                'post_author'  => $user_ID,
                'post_title'   => $title,
                'post_content' => ''
            );
            $result = wp_insert_post( $dataPost );
            return $result;
        }

        /**
         * Update video
         *
         * @param  object $video
         * @return boolean
         */
        protected function _updateVideo( $video )
        {
            $result   = 0;
            $dataPost = array();
            if ( ! empty( $_POST['title'] ) && $_POST['title'] != $video->post_title ) {
                $dataPost['post_title'] = apply_filters( 'single_post_title', $_POST['title'] );
            }
            if ( $_POST['status'] == 'true' ) {
                $status = 'publish';
            } else {
                $status = 'draft';
            }
            if ( $status != $video->post_status ) {
                $dataPost['post_status'] = $status;
            }
            if ( ! empty( $dataPost )) {
                $dataPost['ID'] = $video->ID;
                $result = wp_update_post( $dataPost );
            }
            return $result;
        }
    }
}
