<?php
/**
 * Controller to handling updating style process
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPVisc_Ajax_Update_style' ))
{
    class IPVisc_Ajax_Update_style
    {
        /**
         * Execution save options process
         *
         * @return void
         */
        public function exec()
        {
            $redirect = false;
            $is_add   = false;
            $error    = true;
            if ( ! empty( $_POST['isadd'] )) {
                $is_add = true;
            }
            if ( ! empty( $_POST['style_id'] )) {
                $styleId = absint( $_POST['style_id'] );
                if ( $style = get_post( $styleId ) ) {
                    $this->_updateStyle( $style );
                } else {
                    $styleId = 0;
                }
            } else {
                $styleId = $this->_addStyle();
            }
            if ( $styleId )
            {
                $error = false;
                $model = new IPVisc_Model_Style();
                $model->saveSetting( $styleId );
            }
            if ( $error ) {
                $status   = 0;
                $styleId  = 0;
                if ( $is_add ) {
                    $message = __( 'Failed create style.', IPVISC_SLUG );
                } else {
                    $message = __( 'Failed save style.', IPVISC_SLUG );
                }
            } else {
                $status = 1;
                if ( $is_add ) {
                    $message  = __( 'Successfully created style.', IPVISC_SLUG );
                    $redirect = admin_url() . 'admin.php?page=' . IPVISC_PAGENAME . '-style&action=edit&id=' . $styleId . '&create=1';
                } else {
                    $message = __( 'Successfully saved style.', IPVISC_SLUG );
                }
            }
            $result = array(
                'status'    => $status,
                'message'   => $message,
                'styleid'   => $styleId
            );
            if ( $redirect ) {
                $result['redirect'] = $redirect;
            }
            echo json_encode( $result );
            die();
        }

        /**
         * Add new style
         *
         * @return int
         */
        protected function _addStyle()
        {
            global $user_ID;

            if ( empty( $_POST['title'] )) {
                $title = 'Unknown';
            } else {
                $title = apply_filters( 'single_post_title', $_POST['title'] );
            }

            $dataPost = array(
                'post_status'  => 'publish',
                'post_type'    => 'ipvisc-style',
                'post_author'  => $user_ID,
                'post_title'   => $title,
                'post_content' => ''
            );
            $result = wp_insert_post( $dataPost );
            return $result;
        }

        /**
         * Update style
         *
         * @param  object $style
         * @return boolean
         */
        protected function _updateStyle( $style )
        {
            $result   = 0;
            $dataPost = array();
            if ( ! empty( $_POST['title'] ) && $_POST['title'] != $style->post_title ) {
                $dataPost['post_title'] = apply_filters( 'single_post_title', $_POST['title'] );
            }
            if ( ! empty( $dataPost )) {
                $dataPost['ID'] = $style->ID;
                $result = wp_update_post( $dataPost );
            }
            return $result;
        }
    }
}
