<?php
if ( ! class_exists( 'IPVisc_Faicon' ))
{
    /**
     * Class for handling administrator page
     */
    class IPVisc_Faicon
    {
        /**
         * Get Icon
         *
         * @param  string $name
         * @return void
         */
        public static function get_html_option( $name, $value = '' )
        {
            $icons = self::get_icons();
        ?>
            <div class="ipvisc-faicon-options ipvisc-image-option">
                <ul class="ipvisc-clear">
                    <?php
                    foreach( $icons as $key => $icon )
                    {
                        $key   = trim( $key );
                        $class = '_item';
                        if ( $key == $value ) {
                            $class .= ' _selected"';
                        }
                        echo '<li><a class="'.$class.'" href="#" data-value="'.$key.'" title="'.$icon.'">
                                    <i class="ipvisc-fa ipvisc-fa-'.$key.'"></i>
                                </a></li>';
                    }
                    ?>
                </ul>
                <input class="_value-selected" type="hidden" name="<?php echo $name; ?>" value="<?php echo $value; ?>">
            </div>
        <?php
        }

        /**
         * Get Icon
         *
         * @return void
         */
        public static function get_icons()
        {
            $fa_icons = array(
                'none' => 'none',
                'adjust' => 'Adjust',
                'anchor' => 'Anchor',
                'archive' => 'Archive',
                'area-chart' => 'Area Chart',
                'arrows' => 'Arrows',
                'arrows-h' => 'Arrows H',
                'arrows-v' => 'Arrows V',
                'asterisk' => 'Asterisk',
                'at' => 'At',
                'automobile ' => 'Automobile ',
                'ban' => 'Ban',
                'bar-chart' => 'Bar Chart',
                'bar-chart-o ' => 'Bar Chart O ',
                'barcode' => 'Barcode',
                'bars' => 'Bars',
                'beer' => 'Beer',
                'bell' => 'Bell',
                'bell-o' => 'Bell O',
                'bell-slash' => 'Bell Slash',
                'bell-slash-o' => 'Bell Slash O',
                'bicycle' => 'Bicycle',
                'binoculars' => 'Binoculars',
                'birthday-cake' => 'Birthday Cake',
                'bolt' => 'Bolt',
                'bomb' => 'Bomb',
                'book' => 'Book',
                'bookmark' => 'Bookmark',
                'bookmark-o' => 'Bookmark O',
                'briefcase' => 'Briefcase',
                'bug' => 'Bug',
                'building' => 'Building',
                'building-o' => 'Building O',
                'bullhorn' => 'Bullhorn',
                'bullseye' => 'Bullseye',
                'bus' => 'Bus',
                'cab ' => 'Cab ',
                'calculator' => 'Calculator',
                'calendar' => 'Calendar',
                'calendar-o' => 'Calendar O',
                'camera' => 'Camera',
                'camera-retro' => 'Camera Retro',
                'car' => 'Car',
                'caret-square-o-down' => 'Caret Square O Down',
                'caret-square-o-left' => 'Caret Square O Left',
                'caret-square-o-right' => 'Caret Square O Right',
                'caret-square-o-up' => 'Caret Square O Up',
                'cc' => 'Cc',
                'certificate' => 'Certificate',
                'check' => 'Check',
                'check-circle' => 'Check Circle',
                'check-circle-o' => 'Check Circle O',
                'check-square' => 'Check Square',
                'check-square-o' => 'Check Square O',
                'child' => 'Child',
                'circle' => 'Circle',
                'circle-o' => 'Circle O',
                'circle-o-notch' => 'Circle O Notch',
                'circle-thin' => 'Circle Thin',
                'clock-o' => 'Clock O',
                'close ' => 'Close ',
                'cloud' => 'Cloud',
                'cloud-download' => 'Cloud Download',
                'cloud-upload' => 'Cloud Upload',
                'code' => 'Code',
                'code-fork' => 'Code Fork',
                'coffee' => 'Coffee',
                'cog' => 'Cog',
                'cogs' => 'Cogs',
                'comment' => 'Comment',
                'comment-o' => 'Comment O',
                'comments' => 'Comments',
                'comments-o' => 'Comments O',
                'compass' => 'Compass',
                'copyright' => 'Copyright',
                'credit-card' => 'Credit Card',
                'crop' => 'Crop',
                'crosshairs' => 'Crosshairs',
                'cube' => 'Cube',
                'cubes' => 'Cubes',
                'cutlery' => 'Cutlery',
                'dashboard ' => 'Dashboard ',
                'database' => 'Database',
                'desktop' => 'Desktop',
                'dot-circle-o' => 'Dot Circle O',
                'download' => 'Download',
                'edit ' => 'Edit ',
                'ellipsis-h' => 'Ellipsis H',
                'ellipsis-v' => 'Ellipsis V',
                'envelope' => 'Envelope',
                'envelope-o' => 'Envelope O',
                'eraser' => 'Eraser',
                'exchange' => 'Exchange',
                'exclamation' => 'Exclamation',
                'exclamation-circle' => 'Exclamation Circle',
                'exclamation-triangle' => 'Exclamation Triangle',
                'external-link' => 'External Link',
                'external-link-square' => 'External Link Square',
                'eye' => 'Eye',
                'eye-slash' => 'Eye Slash',
                'eyedropper' => 'Eyedropper',
                'fax' => 'Fax',
                'female' => 'Female',
                'fighter-jet' => 'Fighter Jet',
                'file-archive-o' => 'File Archive O',
                'file-audio-o' => 'File Audio O',
                'file-code-o' => 'File Code O',
                'file-excel-o' => 'File Excel O',
                'file-image-o' => 'File Image O',
                'file-movie-o ' => 'File Movie O ',
                'file-pdf-o' => 'File Pdf O',
                'file-photo-o ' => 'File Photo O ',
                'file-picture-o ' => 'File Picture O ',
                'file-powerpoint-o' => 'File Powerpoint O',
                'file-sound-o ' => 'File Sound O ',
                'file-video-o' => 'File Video O',
                'file-word-o' => 'File Word O',
                'file-zip-o ' => 'File Zip O ',
                'film' => 'Film',
                'filter' => 'Filter',
                'fire' => 'Fire',
                'fire-extinguisher' => 'Fire Extinguisher',
                'flag' => 'Flag',
                'flag-checkered' => 'Flag Checkered',
                'flag-o' => 'Flag O',
                'flash ' => 'Flash ',
                'flask' => 'Flask',
                'folder' => 'Folder',
                'folder-o' => 'Folder O',
                'folder-open' => 'Folder Open',
                'folder-open-o' => 'Folder Open O',
                'frown-o' => 'Frown O',
                'futbol-o' => 'Futbol O',
                'gamepad' => 'Gamepad',
                'gavel' => 'Gavel',
                'gear ' => 'Gear ',
                'gears ' => 'Gears ',
                'gift' => 'Gift',
                'glass' => 'Glass',
                'globe' => 'Globe',
                'group ' => 'Group ',
                'hdd-o' => 'Hdd O',
                'headphones' => 'Headphones',
                'heart' => 'Heart',
                'heart-o' => 'Heart O',
                'history' => 'History',
                'home' => 'Home',
                'image ' => 'Image ',
                'inbox' => 'Inbox',
                'info' => 'Info',
                'info-circle' => 'Info Circle',
                'key' => 'Key',
                'keyboard-o' => 'Keyboard O',
                'language' => 'Language',
                'laptop' => 'Laptop',
                'leaf' => 'Leaf',
                'legal ' => 'Legal ',
                'lemon-o' => 'Lemon O',
                'level-down' => 'Level Down',
                'level-up' => 'Level Up',
                'life-bouy ' => 'Life Bouy ',
                'life-buoy ' => 'Life Buoy ',
                'life-ring' => 'Life Ring',
                'life-saver ' => 'Life Saver ',
                'lightbulb-o' => 'Lightbulb O',
                'line-chart' => 'Line Chart',
                'location-arrow' => 'Location Arrow',
                'lock' => 'Lock',
                'magic' => 'Magic',
                'magnet' => 'Magnet',
                'mail-forward ' => 'Mail Forward ',
                'mail-reply ' => 'Mail Reply ',
                'mail-reply-all ' => 'Mail Reply All ',
                'male' => 'Male',
                'map-marker' => 'Map Marker',
                'meh-o' => 'Meh O',
                'microphone' => 'Microphone',
                'microphone-slash' => 'Microphone Slash',
                'minus' => 'Minus',
                'minus-circle' => 'Minus Circle',
                'minus-square' => 'Minus Square',
                'minus-square-o' => 'Minus Square O',
                'mobile' => 'Mobile',
                'mobile-phone ' => 'Mobile Phone ',
                'money' => 'Money',
                'moon-o' => 'Moon O',
                'mortar-board ' => 'Mortar Board ',
                'music' => 'Music',
                'navicon ' => 'Navicon ',
                'newspaper-o' => 'Newspaper O',
                'paint-brush' => 'Paint Brush',
                'paper-plane' => 'Paper Plane',
                'paper-plane-o' => 'Paper Plane O',
                'paw' => 'Paw',
                'pencil' => 'Pencil',
                'pencil-square' => 'Pencil Square',
                'pencil-square-o' => 'Pencil Square O',
                'phone' => 'Phone',
                'phone-square' => 'Phone Square',
                'photo ' => 'Photo ',
                'picture-o' => 'Picture O',
                'pie-chart' => 'Pie Chart',
                'plane' => 'Plane',
                'plug' => 'Plug',
                'plus' => 'Plus',
                'plus-circle' => 'Plus Circle',
                'plus-square' => 'Plus Square',
                'plus-square-o' => 'Plus Square O',
                'power-off' => 'Power Off',
                'print' => 'Print',
                'puzzle-piece' => 'Puzzle Piece',
                'qrcode' => 'Qrcode',
                'question' => 'Question',
                'question-circle' => 'Question Circle',
                'quote-left' => 'Quote Left',
                'quote-right' => 'Quote Right',
                'random' => 'Random',
                'recycle' => 'Recycle',
                'refresh' => 'Refresh',
                'remove ' => 'Remove ',
                'reorder ' => 'Reorder ',
                'reply' => 'Reply',
                'reply-all' => 'Reply All',
                'retweet' => 'Retweet',
                'road' => 'Road',
                'rocket' => 'Rocket',
                'rss' => 'Rss',
                'rss-square' => 'Rss Square',
                'search' => 'Search',
                'search-minus' => 'Search Minus',
                'search-plus' => 'Search Plus',
                'send ' => 'Send ',
                'send-o ' => 'Send O ',
                'share' => 'Share',
                'share-alt' => 'Share Alt',
                'share-alt-square' => 'Share Alt Square',
                'share-square' => 'Share Square',
                'share-square-o' => 'Share Square O',
                'shield' => 'Shield',
                'shopping-cart' => 'Shopping Cart',
                'sign-in' => 'Sign In',
                'sign-out' => 'Sign Out',
                'signal' => 'Signal',
                'sitemap' => 'Sitemap',
                'sliders' => 'Sliders',
                'smile-o' => 'Smile O',
                'soccer-ball-o ' => 'Soccer Ball O ',
                'sort' => 'Sort',
                'sort-alpha-asc' => 'Sort Alpha Asc',
                'sort-alpha-desc' => 'Sort Alpha Desc',
                'sort-amount-asc' => 'Sort Amount Asc',
                'sort-amount-desc' => 'Sort Amount Desc',
                'sort-asc' => 'Sort Asc',
                'sort-desc' => 'Sort Desc',
                'sort-down ' => 'Sort Down ',
                'sort-numeric-asc' => 'Sort Numeric Asc',
                'sort-numeric-desc' => 'Sort Numeric Desc',
                'sort-up ' => 'Sort Up ',
                'spinner' => 'Spinner',
                'spoon' => 'Spoon',
                'square' => 'Square',
                'square-o' => 'Square O',
                'star' => 'Star',
                'star-half' => 'Star Half',
                'star-half-empty ' => 'Star Half Empty ',
                'star-half-full ' => 'Star Half Full ',
                'star-half-o' => 'Star Half O',
                'star-o' => 'Star O',
                'suitcase' => 'Suitcase',
                'sun-o' => 'Sun O',
                'support ' => 'Support ',
                'tablet' => 'Tablet',
                'tachometer' => 'Tachometer',
                'tag' => 'Tag',
                'tags' => 'Tags',
                'tasks' => 'Tasks',
                'taxi' => 'Taxi',
                'terminal' => 'Terminal',
                'thumb-tack' => 'Thumb Tack',
                'thumbs-down' => 'Thumbs Down',
                'thumbs-o-down' => 'Thumbs O Down',
                'thumbs-o-up' => 'Thumbs O Up',
                'thumbs-up' => 'Thumbs Up',
                'ticket' => 'Ticket',
                'times' => 'Times',
                'times-circle' => 'Times Circle',
                'times-circle-o' => 'Times Circle O',
                'tint' => 'Tint',
                'toggle-down ' => 'Toggle Down ',
                'toggle-left ' => 'Toggle Left ',
                'toggle-off' => 'Toggle Off',
                'toggle-on' => 'Toggle On',
                'toggle-right ' => 'Toggle Right ',
                'toggle-up ' => 'Toggle Up ',
                'trash' => 'Trash',
                'trash-o' => 'Trash O',
                'tree' => 'Tree',
                'trophy' => 'Trophy',
                'truck' => 'Truck',
                'tty' => 'Tty',
                'umbrella' => 'Umbrella',
                'unlock' => 'Unlock',
                'unlock-alt' => 'Unlock Alt',
                'unsorted ' => 'Unsorted ',
                'upload' => 'Upload',
                'user' => 'User',
                'users' => 'Users',
                'video-camera' => 'Video Camera',
                'volume-down' => 'Volume Down',
                'volume-off' => 'Volume Off',
                'volume-up' => 'Volume Up',
                'warning ' => 'Warning ',
                'wheelchair' => 'Wheelchair',
                'wifi' => 'Wifi',
                'wrench' => 'Wrench',
            );
            return $fa_icons;
        }
    }
}
?>
