<?php
if ( ! class_exists( 'IPVisc_Font' )) {

    /**
     * Class for create popup
     */
    class IPVisc_Font
    {
        /**
         * Get option font
         *
         * @return array
         */
        public static function getOptions()
        {
            $options = array(
                'archivo_narrow'    => 'Archivo Narrow',
                'arimo'             => 'Arimo',
                'cuprum'            => 'Cuprum',
                'droid_sans'        => 'Droid Sans',
                'exo'               => 'Exo',
                'inconsolata'       => 'Inconsolata',
                'josefin_sans'      => 'Josefin Sans',
                'lato'              => 'Lato',
                'nunito'            => 'Nunito',
                'open_sans'         => 'Open Sans',
                'philosopher'       => 'Philosopher',
                'raleway'           => 'Raleway',
                'roboto'            => 'Roboto',
                'roboto_condensed'  => 'Roboto Condensed',
                'source_sans_pro'   => 'Source Sans Pro',
                'titillium_web'     => 'Titillium Web',

                'arvo'              => 'Arvo',
                'bitter'            => 'Bitter',
                'crimson_text'      => 'Crimson Text',
                'droid_serif'       => 'Droid Serif',
                'kreon'             => 'Kreon',
                'libre_baskerville' => 'Libre Baskerville',
                'lora'              => 'Lora, serif',
                'merriweather'      => 'Merriweather',
                'old_standard_tt'   => 'Old Standard TT',
                'playfair_display'  => 'Playfair Display',
                'vollkorn'          => 'Vollkorn, serif',

                'comfortaa'         => 'Comfortaa',
                'kaushan_script'    => 'Kaushan Script',
                'limelight'         => 'Limelight',
                'lobster_two'       => 'Lobster Two',
                'marck_script'      => 'Marck Script',
                'norican'           => 'Norican',
                'oleo_script'       => 'Oleo Script',
                'overlock'          => 'Overlock',
                'pacifico'          => 'Pacifico',
                'playball'          => 'Playball',
            );
            return $options;
        }

        /**
         * Get style font
         *
         * @return array
         */
        public static function getStyles()
        {
            $styles = array(
                'archivo_narrow'    => "'Archivo Narrow', sans-serif",
                'arimo'             => 'Arimo, sans-serif',
                'cuprum'            => 'Cuprum, sans-serif',
                'droid_sans'        => "'Droid Sans', sans-serif",
                'exo'               => 'Exo, sans-serif',
                'inconsolata'       => 'Inconsolata, sans-serif',
                'josefin_sans'      => "'Josefin Sans', sans-serif",
                'lato'              => "'Lato', sans-serif",
                'nunito'            => 'Nunito, sans-serif',
                'open_sans'         => "'Open Sans', sans-serif",
                'philosopher'       => 'Philosopher, sans-serif',
                'raleway'           => 'Raleway, sans-serif',
                'roboto'            => 'Roboto, sans-serif',
                'roboto_condensed'  => "'Roboto Condensed', sans-serif",
                'source_sans_pro'   => "'Source Sans Pro', sans-serif",
                'titillium_web'     => "'Titillium Web', sans-serif",

                'arvo'              => 'Arvo, serif',
                'bitter'            => 'Bitter, serif',
                'crimson_text'      => "'Crimson Text', serif",
                'droid_serif'       => "'Droid Serif', serif",
                'kreon'             => 'Kreon, serif',
                'libre_baskerville' => "'Libre Baskerville', serif",
                'lora'              => 'Lora, serif',
                'merriweather'      => 'Merriweather, serif',
                'old_standard_tt'   => "'Old Standard TT', serif",
                'playfair_display'  => "'Playfair Display', serif",
                'vollkorn'          => 'Vollkorn, serif',

                'comfortaa'         => 'Comfortaa, cursive',
                'kaushan_script'    => "'Kaushan Script', cursive",
                'limelight'         => 'Limelight, cursive',
                'lobster_two'       => "'Lobster Two', cursive",
                'marck_script'      => "'Marck Script', cursive",
                'norican'           => 'Norican, cursive',
                'oleo_script'       => "'Oleo Script', cursive",
                'overlock'          => "'Overlock', cursive",
                'pacifico'          => 'Pacifico, cursive',
                'playball'          => 'Playball, cursive',
            );
            return $styles;
        }

        /**
         * Get link font
         *
         * @return array
         */
        public static function getLinks()
        {
            $links = array(
                'archivo_narrow'    => 'Archivo+Narrow:400,400italic,700,700italic',
                'arimo'             => 'Arimo:400,700,400italic,700italic',
                'arvo'              => 'Arvo:400,700,400italic,700italic',
                'bitter'            => 'Bitter:400,700,400italic',
                'comfortaa'         => 'Comfortaa:400,700',
                'crimson_text'      => 'Crimson+Text:400,400italic,700,700italic',
                'cuprum'            => 'Cuprum:400,700,700italic,400italic',
                'droid_sans'        => 'Droid+Sans:400,700',
                'droid_serif'       => 'Droid+Serif:400,700,400italic,700italic',
                'exo'               => 'Exo:400,700,400italic,700italic',
                'inconsolata'       => 'Inconsolata:400,700',
                'josefin_sans'      => 'Josefin+Sans:400,700,400italic,700italic',
                'kaushan_script'    => 'Kaushan+Script',
                'kreon'             => 'Kreon:400,700',
                'lato'              => 'Lato:400,700,400italic,700italic',
                'libre_baskerville' => 'Libre+Baskerville:400,700,400italic',
                'limelight'         => 'Limelight',
                'lobster_two'       => 'Lobster+Two:400,400italic,700,700italic',
                'lora'              => 'Lora:400,700,400italic,700italic',
                'marck_script'      => 'Marck+Script',
                'merriweather'      => 'Merriweather:400,400italic,700,700italic',
                'norican'           => 'Norican',
                'nunito'            => 'Nunito:400,700',
                'old_standard_tt'   => 'Old+Standard+TT:400,400italic,700',
                'oleo_script'       => 'Oleo+Script:400,700',
                'open_sans'         => 'Open+Sans:400italic,700italic,400,700',
                'overlock'          => 'Overlock:400,700,400italic,700italic',
                'pacifico'          => 'Pacifico',
                'philosopher'       => 'Philosopher:400,700,400italic,700italic',
                'playball'          => 'Playball',
                'playfair_display'  => 'Playfair+Display:400,700,400italic,700italic',
                'raleway'           => 'Raleway:400,700',
                'roboto'            => 'Roboto:400,400italic,700,700italic',
                'roboto_condensed'  => 'Roboto+Condensed:400italic,700italic,400,700',
                'source_sans_pro'   => 'Source+Sans+Pro:400,700,400italic,700italic',
                'titillium_web'     => 'Titillium+Web:400,400italic,700,700italic',
                'vollkorn'          => 'Vollkorn:400italic,700italic,400,700',
            );
            return $links;
        }

        /**
         * Get font name
         *
         * @param  int    $id
         * @return string
         */
        public static function getFontName( $id )
        {
            $name = 'Unknown';
            $font = self::getOptions();
            if ( array_key_exists( $id, $font )) {
                $name = $font[$id];
            }
            return $name;
        }

        /**
         * Get font family
         *
         * @param  int    $id
         * @return string
         */
        public static function getFamily( $id )
        {
            $family = 'sans-serif';
            $fonts  = self::getStyles();
            if ( array_key_exists( $id, $fonts )) {
                $family = $fonts[$id];
            }
            return $family;
        }

        /**
         * Get active font
         *
         * @return string
         */
        public static function getActiveFont()
        {
            $args = array(
                'orderby'        => 'post_date',
                'order'          => 'DESC',
                'post_type'      => 'ipvisc-item',
                'post_status'    => array('publish','draft'),
                'posts_per_page' => -1
            );
            $query   = new WP_Query;
            $styles  = $query->query( $args );

            $fonts   = array( 'roboto' );
            $fams    = array();
            if ( ! empty( $styles )) {
                foreach( $styles as $style )
                {
                    $setting = new IPVisc_Setting( $style->ID, '__ipvisc-setting' );
                    $font    = $setting->getSetting( 'font_family', 'roboto' );
                    if ( ! in_array( $font, $fonts )) {
                        $fonts[] = $font;
                    }
                }
            }
            $links = self::getLinks();
            foreach( $fonts as $font )
            {
                if ( array_key_exists( $font, $links ))
                {
                    $fams[] = $links[$font];
                }
            }
            $family  = implode( '|', $fams );
            $fontUrl = 'http://fonts.googleapis.com/css?family=' . $family;
            $style   = '<link id="ipnews-font" href="' . $fontUrl . '" rel="stylesheet" type="text/css">';
            return $style;
        }
    }
}
