<?php
if ( ! class_exists( 'IPVisc_Form' )) {

    /**
     * Class form checker
     */
    class IPVisc_Form
    {
        /**
         * Parse form html
         *
         * @param  string $html
         * @return array
         */
        public static function parse( $html )
        {
            $html = stripslashes( $html );
            //Get form action
            $action = '';
            preg_match_all( '@action=\"([^\"]+)\"@', $html, $matches );
            if ( ! empty( $matches[1] )) {
                $action = array_shift( $matches[1] );
            }
            //Get input
            $fields  = array();
            $hiddens = array();
            preg_match_all( '@\<input([^\>]+)\>@', $html, $matches );
            if ( ! empty( $matches[1] )) {
                foreach( $matches[1] as $input )
                {
                    //$regex = "@(?<==)[\"\']?((?:.(?![\"\']?\\s+(?:\S+)=|[>\"\']))+.)[\"\']?@";
                    //$regex = "@(\S+)=[\"\']?(.)+[\"\']?@";
                    //$regex = "@(\S+)=[\"\']?((?:.(?![\"\']?\s+(?:\S+)=|[>\"\']))+.)[\"\']?@";
                    $regex = "@(\S+)=[\"\']?((?:.(?![\"\']?\s+(?:\S+)))+.)[\"\']?@";
                    preg_match_all( $regex, $input, $inpmatch );
                    /*
                    if ( ! empty( $inpmatch[0] ) && ! empty( $inpmatch[1] ) )
                    {
                        $type = $name = $value = '';
                        foreach( $inpmatch[1] as $idx => $key ) {
                            if ( ! empty( $inpmatch[2][$idx] )) {
                                $val = $inpmatch[2][$idx];
                                if ( $key == 'type' ) {
                                    $type = $val;
                                } elseif ( $key == 'name' ) {
                                    $name = $val;
                                } elseif ( $key == 'value' ) {
                                    $value = trim($val);
                                }
                            }
                        }
                        if ( empty( $value )) {
                            foreach( $inpmatch[0] as $idx => $str )
                            {
                                if ( strpos( $str, 'value=' ) !== false ) {
                                    $value = str_replace( 'value=', '', $str );
                                    $value = trim( $value, '"' );
                                    if ( strpos( $value, 'http' ) !== false ) {
                                        $parts = parse_url( $value );
                                        if ( ! empty( $parts['scheme'] )) {
                                            $url = $parts['scheme'] . '://';
                                        } else {
                                            $url = 'http://';
                                        }
                                        if ( ! empty( $parts['host'] )) {
                                            $url .= $parts['host'];
                                        }
                                        if ( ! empty( $parts['path'] )) {
                                            $url .= $parts['path'];
                                        }
                                        if ( ! empty( $parts['query'] )) {
                                            $url .= '?' . $parts['query'];
                                        }
                                        $value = $url;
                                    }
                                }
                            }
                        }
                        if ( ! empty( $value )) {
                            $value = trim( $value );
                            $value = trim( $value, '/' );
                            $value = trim( $value );
                        }
                        if ( $type == 'email' || $type == 'text' ) {
                            $fields[] = $name;
                        } elseif ( $type == 'hidden' ) {
                            $hiddens[$name] = $value;
                        }
                    }
                    */
                    if ( ! empty( $inpmatch[0] ) )
                    {
                        $type = $name = $value = '';
                        foreach( $inpmatch[0] as $_match )
                        {
                            $_match = trim( $_match, '"' );
                            $_match = trim( $_match, "'" );
                            $parts  = explode( '=', $_match );
                            if ( count( $parts ) > 2 ) {
                                $key = array_shift( $parts );
                                $val = implode( '=', $parts );
                                $parts = array( $key, $val );
                            }
                            $key = $val = '';
                            if ( ! empty( $parts )) {
                                $key = array_shift( $parts );
                            }
                            if ( ! empty( $parts )) {
                                $val = array_shift( $parts );
                                $val = trim( $val );
                                $val = trim( $val, '"' );
                                $val = trim( $val, "'" );
                            }
                            if ( $key == 'type' ) {
                                $type = $val;
                            } elseif ( $key == 'name' ) {
                                $name = $val;
                            } elseif ( $key == 'value' ) {
                                $value = $val;
                            }
                        }
                        if ( $type == 'email' || $type == 'text' ) {
                            $fields[] = $name;
                        } elseif ( $type == 'hidden' ) {
                            $hiddens[$name] = $value;
                        }


                    }
                }
            }
            return array(
                'action'    => $action,
                'fields'    => $fields,
                'hiddens'   => $hiddens
            );
        }
    }
}
