<?php
/**
 * Class model
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPVisc_Model' )) {

  /**
   * Class for manage post setting
   */
  class IPVisc_Model
  {
    /**
     * Save setting widget
     *
     * @param  int $widgetId
     * @return void
     */
    public function saveSetting( $widgetId )
    {
      $widgetId = absint( $widgetId );
      $data     = $this->_getSettingData();
      $setting  = new IPVisc_Setting( $widgetId, '__ipvisc-setting' );
      $result   = $setting->setSettings( $data );
      return $result;
    }

    /**
     * Get setting data
     *
     * @return array
     */
    protected function _getSettingData()
    {
      $setting = array();
      $data    = array_merge( $_POST, $_GET );

      //
      //
      // General
      //
      if ( isset( $data['widget_style'] )) {
        $setting['widget_style'] = absint( $data['widget_style'] );
      }
      if ( isset( $data['restricted'] )) {
        $setting['restricted'] = apply_filters( 'pre_term_name', $data['restricted'] );
      }

      //
      //Style
      //
      if ( isset( $data['background_color'] )) {
        $setting['background_color'] = apply_filters( 'single_post_title', $data['background_color'] );
      }
      if ( isset( $data['border_width'] )) {
        $setting['border_width'] = absint( $data['border_width'] );
      }
      if ( isset( $data['border_color'] )) {
        $setting['border_color'] = apply_filters( 'single_post_title', $data['border_color'] );
      }
      if ( isset( $data['text_color'] )) {
        $setting['text_color'] = apply_filters( 'single_post_title', $data['text_color'] );
      }
      if ( isset( $data['font_family'] )) {
        $setting['font_family'] = apply_filters( 'single_post_title', $data['font_family'] );
      }
      if ( isset( $data['font_size'] )) {
        $setting['font_size'] = apply_filters( 'pre_term_name', $data['font_size'] );
      }
      if ( isset( $data['text_align'] )) {
        $setting['text_align'] = apply_filters( 'pre_term_name', $data['text_align'] );
      }
      if ( isset( $data['padding'] )) {
        $setting['padding'] = absint( $data['padding'] );
      }
      if ( isset( $data['border_radius'] )) {
        $setting['border_radius'] = apply_filters( 'pre_term_name', $data['border_radius'] );
      }
      if ( isset( $data['shadow'] )) {
        $setting['shadow'] = apply_filters( 'pre_term_name', $data['shadow'] );
      }

      //
      //Main Content
      //
      if ( isset( $data['video_type'] )) {
        $setting['video_type'] = apply_filters( 'pre_term_name', $data['video_type'] );
      }
      if ( isset( $data['video_file'] )) {
        $setting['video_file'] = absint( $data['video_file'] );
      }
      if ( isset( $data['video_poster'] )) {
        $setting['video_poster'] = absint( $data['video_poster'] );
      }
      if ( isset( $data['youtube_url'] )) {
        $setting['youtube_url'] = apply_filters( 'pre_link_url', $data['youtube_url'] );
      }
      if ( isset( $data['youtube_start'] )) {
        $setting['youtube_start'] = absint( $data['youtube_start'] );
      }
      if ( isset( $data['video_autoplay'] )) {
        $setting['video_autoplay'] = apply_filters( 'pre_term_name', $data['video_autoplay'] );
      }
      if ( isset( $data['video_width'] )) {
        $setting['video_width'] = absint( $data['video_width'] );
      }
      if ( isset( $data['video_height'] )) {
        $setting['video_height'] = absint( $data['video_height'] );
      }
      if ( isset( $data['content_title'] )) {
        $setting['content_title'] = apply_filters( 'single_post_title', $data['content_title'] );
      }
      if ( isset( $data['content_info'] )) {
        $setting['content_info'] = $data['content_info'];
      }

      //
      //Countdown
      //
      if ( isset( $data['countdown_activate'] )) {
        $setting['countdown_activate'] = apply_filters( 'pre_term_name', $data['countdown_activate'] );
      }
      if ( isset( $data['countdown_target_date'] )) {
        $setting['countdown_target_date'] = apply_filters( 'single_post_title', $data['countdown_target_date'] );
      }
      if ( isset( $data['countdown_target_time'] )) {
        $setting['countdown_target_time'] = apply_filters( 'single_post_title', $data['countdown_target_time'] );
      }
      if ( isset( $data['countdown_format'] )) {
        $setting['countdown_format'] = apply_filters( 'pre_term_name', $data['countdown_format'] );
      }
      if ( isset( $data['countdown_bgcolor'] )) {
        $setting['countdown_bgcolor'] = apply_filters( 'single_post_title', $data['countdown_bgcolor'] );
      }
      if ( isset( $data['countdown_color'] )) {
        $setting['countdown_color'] = apply_filters( 'single_post_title', $data['countdown_color'] );
      }
      if ( isset( $data['countdown_font_family'] )) {
        $setting['countdown_font_family'] = apply_filters( 'single_post_title', $data['countdown_font_family'] );
      }
      if ( isset( $data['countdown_border_width'] )) {
        $setting['countdown_border_width'] = absint( $data['countdown_border_width'] );
      }
      if ( isset( $data['countdown_border_color'] )) {
        $setting['countdown_border_color'] = apply_filters( 'single_post_title', $data['countdown_border_color'] );
      }
      if ( isset( $data['countdown_border_radius'] )) {
        $setting['countdown_border_radius'] = apply_filters( 'pre_term_name', $data['countdown_border_radius'] );
      }


      //
      //Button
      //
      if ( ! empty( $data['button_target'] )) {
        $setting['button_target'] = apply_filters( 'pre_term_name', $data['button_target'] );
      }
      if ( ! empty( $data['button_link'] )) {
        $setting['button_link'] = apply_filters( 'pre_link_url', $data['button_link'] );
      }
      if ( isset( $data['button_text'] )) {
        $setting['button_text'] = apply_filters( 'single_post_title', $data['button_text'] );
      }
      if ( isset( $data['button_icon'] )) {
        $setting['button_icon'] = apply_filters( 'pre_term_name', $data['button_icon'] );
      }
      if ( isset( $data['button_text_align'] )) {
        $setting['button_text_align'] = apply_filters( 'pre_term_name', $data['button_text_align'] );
      }
      if ( isset( $data['button_size'] )) {
        $setting['button_size'] = apply_filters( 'pre_term_name', $data['button_size'] );
      }
      if ( isset( $data['button_new_tab'] )) {
        $setting['button_new_tab'] = apply_filters( 'pre_term_name', $data['button_new_tab'] );
      }

      //
      //
      //Autoresponder
      //
      if ( isset( $data['responder_title'] )) {
          $setting['responder_title'] = apply_filters( 'single_post_title', $data['responder_title'] );
      }
      if ( isset( $data['responder_info'] )) {
          $setting['responder_info'] = apply_filters( 'single_post_title', $data['responder_info'] );
      }
      if ( isset( $data['autoresponder_code'] )) {
          $setting['autoresponder_code'] = $data['autoresponder_code'];
      }
      if ( isset( $data['autoresponder_action'] )) {
          $setting['autoresponder_action'] = apply_filters( 'pre_link_url', $data['autoresponder_action'] );
      }
      if ( isset( $data['autoresponder_email'] )) {
          $setting['autoresponder_email'] = apply_filters( 'single_post_title', $data['autoresponder_email'] );
      }
      if ( isset( $data['autoresponder_email_label'] )) {
          $setting['autoresponder_email_label'] = apply_filters( 'single_post_title', $data['autoresponder_email_label'] );
      }
      if ( isset( $data['autoresponder_name'] )) {
          $setting['autoresponder_name'] = $data['autoresponder_name'];
      }
      if ( isset( $data['autoresponder_name_label'] )) {
          $setting['autoresponder_name_label'] = apply_filters( 'single_post_title', $data['autoresponder_name_label'] );
      }
      if ( isset( $data['autoresponder_name_activate'] )) {
          $setting['autoresponder_name_activate'] = apply_filters( 'pre_term_name', $data['autoresponder_name_activate'] );
      }
      if ( isset( $data['autoresponder_form_label'] )) {
          $setting['autoresponder_form_label'] = apply_filters( 'pre_term_name', $data['autoresponder_form_label'] );
      }
      if ( isset( $data['autoresponder_button_text'] )) {
          $setting['autoresponder_button_text'] = apply_filters( 'single_post_title', $data['autoresponder_button_text'] );
      }
      if ( isset( $data['autoresponder_button_style'] )) {
          $setting['autoresponder_button_style'] = apply_filters( 'pre_term_name', $data['autoresponder_button_style'] );
      }

      //
      //
      // Share
      //
      if ( isset( $data['share_activate'] )) {
          $setting['share_activate'] = apply_filters( 'pre_term_name', $data['share_activate'] );
      }
      if ( isset( $data['share_facebook'] )) {
          $setting['share_facebook'] = apply_filters( 'pre_term_name', $data['share_facebook'] );
      }
      if ( isset( $data['share_twitter'] )) {
          $setting['share_twitter'] = apply_filters( 'pre_term_name', $data['share_twitter'] );
      }
      if ( isset( $data['share_google-plus'] )) {
          $setting['share_google-plus'] = apply_filters( 'pre_term_name', $data['share_google-plus'] );
      }
      if ( isset( $data['share_linkedin'] )) {
          $setting['share_linkedin'] = apply_filters( 'pre_term_name', $data['share_linkedin'] );
      }
      if ( isset( $data['share_tumblr'] )) {
          $setting['share_tumblr'] = apply_filters( 'pre_term_name', $data['share_tumblr'] );
      }
      if ( isset( $data['share_pinterest'] )) {
          $setting['share_pinterest'] = apply_filters( 'pre_term_name', $data['share_pinterest'] );
      }
      if ( isset( $data['share_stumbleupon'] )) {
          $setting['share_stumbleupon'] = apply_filters( 'pre_term_name', $data['share_stumbleupon'] );
      }
      if ( isset( $data['share_digg'] )) {
          $setting['share_digg'] = apply_filters( 'pre_term_name', $data['share_digg'] );
      }
      if ( isset( $data['share_button_style'] )) {
          $setting['share_button_style'] = apply_filters( 'pre_term_name', $data['share_button_style'] );
      }

      return $setting;
    }
  }
}
?>
