<?php
/**
 * Class model stat
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPVisc_Model_Stat' )) {

    /**
     * Class for manage post setting
     */
    class IPVisc_Model_Stat
    {
        /**
         * Get stats
         *
         * @return array
         */
        public function getStats()
        {
            global $wpdb;

            $table = $wpdb->prefix . 'ipvisc_stats';
            $sql   = "
                SELECT *
                FROM `$table`
            ";
            $results = $wpdb->get_results( $sql );
            return $results;
        }

        /**
         * Get stat
         *
         * @param  int $stat_id
         * @return array
         */
        public function getStat( $stat_id )
        {
            global $wpdb;

            $stat_id = absint( $stat_id );
            $table   = $wpdb->prefix . 'ipvisc_stats';
            $sql     = "
                SELECT *
                FROM `$table` WHERE stat_id = %d
            ";
            $query   = $wpdb->prepare( $sql, $stat_id );
            $results = $wpdb->get_row( $query );
            return $results;
        }

        /**
         * Get stat value
         *
         * @param  int    $video_id
         * @param  string $type
         * @return array
         */
        public function getStatValue( $video_id, $type )
        {
            $count = 0;
            if ( $stat = $this->getStatBypage( $video_id )) {
                if ( isset( $stat->$type )) {
                    $count = (int)$stat->$type;
                }
            }
            return $count;
        }

        /**
         * Get stat by page
         *
         * @param  int $video_id
         * @return array
         */
        public function getStatBypage( $video_id )
        {
            global $wpdb;

            $video_id = absint( $video_id );
            $table   = $wpdb->prefix . 'ipvisc_stats';
            $sql     = "
                SELECT
                    SUM( `stat_view` ) AS `view`,
                    SUM( `stat_subscribe` ) AS `subscribe`,
                    SUM( `stat_click` ) AS `click`,
                    SUM( `stat_play` ) AS `play`
                FROM `$table` WHERE video_id = %d
            ";
            $query   = $wpdb->prepare( $sql, $video_id );
            $results = $wpdb->get_row( $query );
            return $results;
        }

        /**
         * Get stat by page date
         *
         * @param  int    $video_id
         * @param  string $date
         * @return array
         */
        public function getStatBypageDate( $video_id, $date )
        {
            global $wpdb;

            $video_id = absint( $video_id );
            $table   = $wpdb->prefix . 'ipvisc_stats';
            $sql     = "
                SELECT *
                FROM `$table`
                WHERE video_id = $video_id and stat_date = '$date'
            ";
            $results = $wpdb->get_row( $sql );
            return $results;
        }

        /**
         * Get statistic data
         *
         * @return array
         */
        public function getStatisticData( $video_id, $type, $start = null, $end = null )
        {
            global $wpdb;

            $video_id = absint( $video_id );
            $table   = $wpdb->prefix . 'ipvisc_stats';
            $query   = "
                SELECT
                    DATE_FORMAT(stat_date, '%Y-%m-%d') AS gdate,";
            //Type value
            if ( $type == 'view' ) {
                $query .= 'SUM(stat_view) AS value';
            } elseif ( $type == 'subscribe' ) {
                $query .= 'SUM(stat_subscribe) AS value';
            } elseif ( $type == 'click' ) {
                $query .= 'SUM(stat_click) AS value';
            } elseif ( $type == 'play' ) {
                $query .= 'SUM(stat_play) AS value';
            }
            $query .= " FROM $table
                        WHERE video_id = $video_id";

            if ( ! empty( $start ) && ! empty( $end ))
            {
                if ( $start == $end ) {
                    $query .= " AND DATE_FORMAT( stat_date, '%Y-%m-%d' ) = '$start'";
                } else {
                    $query .= " AND stat_date BETWEEN '$start' AND '$end'";
                }
            }
            elseif ( ! empty( $start )) {
                $query .= " AND DATE_FORMAT( stat_date, '%Y-%m-%d' ) = '$start'";
            }
            elseif ( ! empty( $end )) {
                $query .= " AND DATE_FORMAT( stat_date, '%Y-%m-%d' ) = '$end'";
            }
            $query .= " GROUP BY gdate";
            $results = $wpdb->get_results( $query );
            return $results;
        }

        /**
         * Do save statistic
         *
         * @param object $video
         * @param string $type
         * @param int    $count
         * @return void
         */
        public function saveStat( $video, $type, $count = 1 )
        {
            $_types = array(
                'view',
                'subscribe',
                'click',
                'play'
            );
            $key = 'stat_';
            if ( in_array( $type, $_types )) {
                $key .= $type;
            }
            $date = date( 'Y-m-d 00:00:00' );
            $data = array();
            if ( $stat = $this->getStatBypageDate( $video->ID, $date ))
            {
                $ccount = 0;
                if ( isset( $stat->$key )) {
                    $ccount = $stat->$key;
                }
                $data[$key] = $ccount + $count;
                $this->_updateStat( $stat->stat_id, $data );
            }
            else {
                $data['video_id']  = $video->ID;
                $data['stat_date'] = $date;
                $data[$key]        = $count;
                $this->_insertStat( $data );
            }
        }

        /**
         * Insert statistic data
         *
         * @param array $data
         * @return void
         */
        protected function _insertStat( $data )
        {
            global $wpdb;

            $table  = $wpdb->prefix . 'ipvisc_stats';
            $data   = (array)$data;

            $result = $wpdb->insert( $table, $data );
            if ( $result ) {
                return $wpdb->insert_id;
            }
            return false;
        }

        /**
         * Update statistic data
         *
         * @param int   $id
         * @param array $data
         * @return void
         */
        protected function _updateStat( $id, $data )
        {
            global $wpdb;

            $table  = $wpdb->prefix . 'ipvisc_stats';
            $data   = (array)$data;
            $where  = array(
                'stat_id' => absint( $id )
            );
            $result = $wpdb->update( $table, $data, $where );
            return $result;
        }

        /**
         * Restyle text
         *
         * @param  string $string
         * @return void
         */
        public function restyleText( $string )
        {
            $string = number_format( $string );
            $string_count = substr_count( $string, ',' );
            if( $string_count != '0' ) {
                if( $string_count == '1'){
                    return substr( $string, 0, -4 ).'K';
                } else if( $string_count == '2' ){
                    return substr( $string, 0, -8 ).'M';
                } else if( $string_count == '3' ){
                    return substr( $string, 0,  -12 ).'B';
                } else {
                    return;
                }
            } else {
                return $string;
            }
        }
    }
}
?>
