<?php
/**
 * Class model style
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPVisc_Model_Style' )) {

  /**
   * Class for manage post setting
   */
  class IPVisc_Model_Style
  {
    /**
     * Save setting style
     *
     * @param  int $styleId
     * @return void
     */
    public function saveSetting( $styleId )
    {
      $styleId  = absint( $styleId );
      $data     = $this->_getSettingData();
      $setting  = new IPVisc_Setting( $styleId, '__ipvisc-style-setting' );
      $result   = $setting->setSettings( $data );
      return $result;
    }

    /**
     * Get setting data
     *
     * @return array
     */
    protected function _getSettingData()
    {
      $setting = array();
      $data    = array_merge( $_POST, $_GET );

      //
      //
      // General
      //
      if ( isset( $data['position'] )) {
        $setting['position'] = apply_filters( 'pre_term_name', $data['position'] );
      }
      if ( isset( $data['template'] )) {
        $setting['template'] = apply_filters( 'pre_term_name', $data['template'] );
      }
      if ( isset( $data['video_play'] )) {
        $setting['video_play'] = apply_filters( 'pre_term_name', $data['video_play'] );
      }

      //
      //Style
      //
      if ( isset( $data['color'] )) {
        $setting['color'] = apply_filters( 'pre_term_name', $data['color'] );
      }
      //Custom color
      if ( isset( $data['background_color'] )) {
        $setting['background_color'] = apply_filters( 'single_post_title', $data['background_color'] );
      }
      if ( isset( $data['border_color'] )) {
        $setting['border_color'] = apply_filters( 'single_post_title', $data['border_color'] );
      }
      if ( isset( $data['text_color'] )) {
        $setting['text_color'] = apply_filters( 'single_post_title', $data['text_color'] );
      }
      if ( isset( $data['header_background_color'] )) {
        $setting['header_background_color'] = apply_filters( 'single_post_title', $data['header_background_color'] );
      }
      if ( isset( $data['header_text_color'] )) {
        $setting['header_text_color'] = apply_filters( 'single_post_title', $data['header_text_color'] );
      }
      if ( isset( $data['button_background_color'] )) {
        $setting['button_background_color'] = apply_filters( 'single_post_title', $data['button_background_color'] );
      }
      if ( isset( $data['button_border_color'] )) {
        $setting['button_border_color'] = apply_filters( 'single_post_title', $data['button_border_color'] );
      }
      if ( isset( $data['button_text_color'] )) {
        $setting['button_text_color'] = apply_filters( 'single_post_title', $data['button_text_color'] );
      }
      //General
      if ( isset( $data['width'] )) {
        $setting['width'] = absint( $data['width'] );
      }
      if ( isset( $data['border_width'] )) {
        $setting['border_width'] = absint( $data['border_width'] );
      }
      if ( isset( $data['border_radius'] )) {
        $setting['border_radius'] = apply_filters( 'pre_term_name', $data['border_radius'] );
      }
      if ( isset( $data['font_family'] )) {
        $setting['font_family'] = apply_filters( 'single_post_title', $data['font_family'] );
      }
      if ( isset( $data['font_size'] )) {
        $setting['font_size'] = apply_filters( 'pre_term_name', $data['font_size'] );
      }
      if ( isset( $data['header_height'] )) {
        $setting['header_height'] = absint( $data['header_height'] );
      }
      //Video
      if ( isset( $data['video_height'] )) {
        $setting['video_height'] = absint( $data['video_height'] );
      }
      if ( isset( $data['padding'] )) {
        $setting['padding'] = absint( $data['padding'] );
      }
      if ( isset( $data['background_image'] )) {
        $setting['background_image'] = absint( $data['background_image'] );
      }
      if ( isset( $data['background_repeat'] )) {
        $setting['background_repeat'] = apply_filters( 'pre_term_name', $data['background_repeat'] );
      }

      //
      //Content
      //
      if ( isset( $data['display_button'] )) {
        $setting['display_button'] = apply_filters( 'pre_term_name', $data['display_button'] );
      }
      if ( isset( $data['display_share'] )) {
        $setting['display_share'] = apply_filters( 'pre_term_name', $data['display_share'] );
      }

      //
      //Header
      //
      if ( isset( $data['header_activate'] )) {
        $setting['header_activate'] = apply_filters( 'pre_term_name', $data['header_activate'] );
      }
      if ( isset( $data['header_text'] )) {
        $setting['header_text'] = apply_filters( 'single_post_title', $data['header_text'] );
      }
      if ( isset( $data['header_icon'] )) {
        $setting['header_icon'] = apply_filters( 'pre_term_name', $data['header_icon'] );
      }
      if ( isset( $data['header_text_align'] )) {
        $setting['header_text_align'] = apply_filters( 'pre_term_name', $data['header_text_align'] );
      }
      if ( isset( $data['header_close'] )) {
        $setting['header_close'] = apply_filters( 'pre_term_name', $data['header_close'] );
      }
      if ( isset( $data['header_minimize'] )) {
        $setting['header_minimize'] = apply_filters( 'pre_term_name', $data['header_minimize'] );
      }

      //
      //Effect
      //
      if ( isset( $data['show_effect'] )) {
        $setting['show_effect'] = apply_filters( 'pre_term_name', $data['show_effect'] );
      }
      if ( isset( $data['show_effect_speed'] )) {
        $setting['show_effect_speed'] = absint( $data['show_effect_speed'] );
      }
      if ( isset( $data['hide_effect'] )) {
        $setting['hide_effect'] = apply_filters( 'pre_term_name', $data['hide_effect'] );
      }
      if ( isset( $data['hide_effect_speed'] )) {
        $setting['hide_effect_speed'] = absint( $data['hide_effect_speed'] );
      }
      if ( isset( $data['show_audio'] )) {
        $setting['show_audio'] = apply_filters( 'pre_term_name', $data['show_audio'] );
      }
      if ( isset( $data['hide_audio'] )) {
        $setting['hide_audio'] = apply_filters( 'pre_term_name', $data['hide_audio'] );
      }

      return $setting;
    }
  }
}
?>
