<?php
if ( ! class_exists( 'IPVisc_Table_Main' ))
{
    /**
     * Class for create list object
     */
    class IPVisc_Table_Main
    {
        /**
         * Take query object
         * @var WP_Query
         */
        protected $_query;

        /**
         * Take data result
         * @var int
         */
        protected $_result;

        /**
         * Take number of data
         * @var int
         */
        protected $_total;

        /**
         * Take number of page
         * @var int
         */
        protected $_total_page;

        /**
         * Take page number
         * @var int
         */
        protected $_page;

        /**
         * Take number of data per page
         * @var int
         */
        protected $_per_page;

        /**
         * Class constructor
         *
         * @return void
         */
        public function __construct()
        {

            $page = 1;
            if ( ! empty( $_GET['paged'] )) {
                $page = absint( $_GET['paged'] );
            }
            $this->_page     = $page;
            $this->_per_page = 12;
        }

        /**
         * Create list
         *
         * @return string
         */
        public function create()
        {
            //Get data
            $this->_get_data();
            //Build list
            return $this->_build();
        }

        /**
         * Render list
         *
         * @return void
         */
        public function render()
        {
            echo $this->create();
        }

        /**
         * Get data
         *
         * @return void
         */
        protected function _get_data()
        {
            $page     = $this->_page;
            $per_page = $this->_per_page;
            $args = array(
                'orderby'        => 'post_date',
                'order'          => 'DESC',
                'post_type'      => 'ipvisc-item',
                'post_status'    => array('publish','draft'),
                'posts_per_page' => $per_page,
                'paged'          => $page
            );
            $query = new WP_Query;
            $this->_result = $query->query( $args );
            $this->_query  = $query;
            $this->_total  = $query->found_posts;
            $this->_total_page = $this->_get_total_page();
            return $this->_result;
        }

        /**
         * Build list
         *
         * @return void
         */
        protected function _build()
        {
            $list  = $this->_get_action_top();
            $list .= $this->_get_list();
            $list .= $this->_get_action_bottom();
            $list  = $this->_get_container( $list );
            return $list;
        }

        /**
         * Get list
         *
         * @return string
         */
        protected function _get_list()
        {
            $list = '<div class="ipvisc-the-list">';
            if ( empty( $this->_result )) {
                $list .= $this->_get_empty_list();
            }
            else
            {
                $index = 1;
                foreach( $this->_result as $item ) {
                    $list .= $this->_get_list_item( $item, $index );
                    $index++;
                }
            }
            $list .= '</div>';
            return $list;
        }

        /**
         * Get list item
         *
         * @param  object $item
         * @param  int    $index
         * @return string
         */
        protected function _get_list_item( $item, $index )
        {
            $alt = '';
            if ( $index % 2 ) {
                $alt = ' ipvisc-alt';
            }
            $result  = '<div id="ipvisc-item-' . $item->ID . '" class="ipvisc-list-item' . $alt . '">';
            $result .= '<div class="ipvisc-item-inner row">';
            $result .= $this->_get_item_main  ( $item, $index );
            $result .= $this->_get_item_action( $item, $index );
            $result .= '</div>';
            $result .= '</div>';
            return $result;
        }

        /**
         * Get item main
         *
         * @param  object $item
         * @param  int    $index
         * @return string
         */
        protected function _get_item_main( $item, $index )
        {
            $title  = $item->post_title;
            $date   = mysql2date( 'F d Y, h:i', $item->post_date );
            $link   = $this->_get_link_edit( $item );
            if ( $item->post_status == 'publish' ) {
                $label = '<span class="ipvisc-label ipvisc-label-success">' . __( 'Publish', IPVISC_SLUG ) . '</span>';
            } else {
                $label = '<span class="ipvisc-label ipvisc-label-danger">' . __( 'Draft', IPVISC_SLUG ) . '</span>';
            }
            $setting = new IPVisc_Setting( $item->ID, '__ipvisc-setting' );
            $result = '<div class="col-sm-6">' .
                            '<div class="ipvisc-clear">' .
                                '<div class="ipvisc-item-main">' .
                                    '<h3 class="ipvisc-item-title">' .
                                        '<a href="' . $link . '">' . $title . '</a>' .
                                        $label .
                                    '</h3>' .
                                    '<p class="ipvisc-item-create">' .
                                        '<i class="ipvisc-fa ipvisc-fa-calendar"></i>' .
                                        $date .
                                    '</p>' .
                                '</div>' .
                            '</div>' .
                       '</div>';
            return $result;
        }

        /**
         * Get item action
         *
         * @param  object $item
         * @param  int    $index
         * @return string
         */
        protected function _get_item_action( $item, $index )
        {
          $result  =
            '<div class="col-sm-6">' .
              '<div class="ipvisc-item-action ipvisc-clear text-right">' .
                $this->_getItemStat( $item, $index ) .

                '<div class="ipvisc-item-nav ipvisc-fademenu">' .
                  '<div class="ipvisc-fademenu-inner">' .
                    '<div class="ipvisc-nav-label ipvisc-fademenu-button">' .
                      '<a class="ipvisc-menu-link" href="#"><i class="ipvisc-fa ipvisc-fa-bars"></i></a>' .
                    '</div>' .
                    '<ul class="ipvisc-submenu ipvisc-fademenu-content">' .
                      '<li>' .
                        '<a href="' . $this->_get_link_edit( $item ) . '" class="ipvisc-btn ipvisc-btn-xs ipvisc-btn-success">' .
                          '<i class="ipvisc-fa ipvisc-fa-pencil"></i>' .
                           __( 'Edit Video', IPVISC_SLUG ) .
                        '</a>' .
                      '</li>' .
                      '<li>' .
                        '<a href="#" class="ipvisc-btn ipvisc-btn-xs ipvisc-btn-danger ipvisc-item-delete" data-id="' . $item->ID . '">' .
                          '<i class="ipvisc-fa ipvisc-fa-trash"></i>' .
                          __( 'Delete Video', IPVISC_SLUG ) .
                        '</a>' .
                      '</li>' .
                    '</ul>' .
                  '</div>' .
                '</div>' .
              '</div>' .
            '</div>';
          return $result;
        }

        /**
         * Get item action
         *
         * @param  object $item
         * @param  int    $index
         * @return string
         */
        protected function _getItemStat( $item, $index )
        {
            $model  = new IPVisc_Model_Stat();
            $play   = $model->getStatValue( $item->ID, 'play' );
            $clicks = $model->getStatValue( $item->ID, 'click' );
            $result =
              '<div class="ipvisc-item-stats">' .
                '<div class="ipvisc-clear">' .
                  '<div class="ipvisc-stat ipvisc-stat-view">' .
                    '<div class="ipvisc-stat-value">' .
                      '<strong>' . $model->restyleText( $play ) . '</strong>' .
                    '</div>' .
                    '<div class="ipvisc-stat-label">' .
                      '<i class="ipvisc-fa ipvisc-fa-youtube-play"></i>' .
                      '<em>' . __( 'Play', IPVISC_SLUG ) . '</em>' .
                    '</div>' .
                  '</div>' .
                  '<div class="ipvisc-stat ipvisc-stat-click">' .
                    '<div class="ipvisc-stat-value">' .
                      '<strong>' . $model->restyleText( $clicks ) . '</strong>' .
                    '</div>' .
                    '<div class="ipvisc-stat-label">' .
                      '<i class="ipvisc-fa ipvisc-fa-check"></i>' .
                      '<em>' . __( 'Clicks', IPVISC_SLUG ) . '</em>' .
                    '</div>' .
                  '</div>' .
                '</div>' .
              '</div>';

            return $result;
        }

        /**
         * Get link edit
         *
         * @param  object $item
         * @return string
         */
        protected function _get_link_edit( $item )
        {
            $link = admin_url() . 'admin.php?page=' . IPVISC_PAGENAME .  '&action=edit&id=' . $item->ID;
            return $link;
        }

        /**
         * Get empty list
         *
         * @return string
         */
        protected function _get_empty_list()
        {
            return '<div class="ipvisc-list-empty">' .
                        '<p><em>' . __( 'Data not available', IPVISC_SLUG ) . '</em></p>' .
                    '</div>';
        }

        /**
         * Get pagination
         *
         * @return string
         */
        protected function _get_pagination()
        {
            $result = '';
            if ( $this->_need_pagination() )
            {
                $result = '<div class="ipvisc-pagination ipvisc-clear">' .
                            $this->_get_pagination_total() .
                            $this->_get_pagination_menu() .
                          '</div>';
            }
            return $result;
        }

        /**
         * Check is need pagination or not
         *
         * @return string
         */
        protected function _need_pagination()
        {
            $is_need = false;
            if ( ! empty( $this->_result ) && $this->_total_page > 1 ) {
                $is_need = true;
            }
            return $is_need;
        }

        /**
         * Get total page
         *
         * @return int
         */
        protected function _get_total_page()
        {
            $total_page = ceil( $this->_total/$this->_per_page );
            return $total_page;
        }

        /**
         * Get pagination total info
         *
         * @return string
         */
        protected function _get_pagination_total()
        {
            $total  = $this->_total;
            $result = '<div class="ipvisc-total">' .
                        sprintf( _n( '1 item', '%s items', $total, IPVISC_SLUG ), $total ) .
                      '</div>';
            return $result;
        }

        /**
         * Get pagination menu
         *
         * @return string
         */
        protected function _get_pagination_menu()
        {
            $result = '<div class="ipvisc-pagination-menu">' .
                        $this->_get_pagination_first() .
                        $this->_get_pagination_previous() .
                        $this->_get_pagination_page_info() .
                        $this->_get_pagination_next() .
                        $this->_get_pagination_last() .
                      '</div>';
            return $result;
        }

        /**
         * Get pagination go first menu
         *
         * @return string
         */
        protected function _get_pagination_first()
        {
            $result = '';
            $link   = $this->_get_pagination_link( 1 );
            $class  = 'ipvisc-pagin ipvisc-pagin-first';
            if ( $this->_page == 1 || $this->_total_page < 3 ) {
                $class .= ' disabled';
            }
            $result = '<a class="' . $class . '" href="' . $link . '"><i class="ipvisc-fa ipvisc-fa-angle-double-left"></i></a>';
            return $result;
        }

        /**
         * Get pagination go last menu
         *
         * @return string
         */
        protected function _get_pagination_last()
        {
            $result = '';
            $link   = $this->_get_pagination_link( $this->_total_page );
            $class  = 'ipvisc-pagin ipvisc-pagin-last';
            if ( $this->_page == $this->_total_page || $this->_total_page < 3 ) {
                $class .= ' disabled';
            }
            $result = '<a class="' . $class . '" href="' . $link . '"><i class="ipvisc-fa ipvisc-fa-angle-double-right"></i></a>';
            return $result;
        }

        /**
         * Get pagination previous menu
         *
         * @return string
         */
        protected function _get_pagination_previous()
        {
            $result = '';
            $class  = 'ipvisc-pagin ipvisc-pagin-previous';
            $page   = $this->_page - 1;
            if ( $page < 1 ) {
                $page = 1;
                $class .= ' disabled';
            }
            $link = $this->_get_pagination_link( $page );
            $result = '<a class="' . $class . '" href="' . $link . '"><i class="ipvisc-fa ipvisc-fa-angle-left"></i></a>';
            return $result;
        }

        /**
         * Get pagination next menu
         *
         * @return string
         */
        protected function _get_pagination_next()
        {
            $result = '';
            $class  = 'ipvisc-pagin ipvisc-pagin-next';
            $page   = $this->_page + 1;
            if ( $page > $this->_total_page ) {
                $page = $this->_total_page;
                $class .= ' disabled';
            }
            $link = $this->_get_pagination_link( $page );
            $result = '<a class="' . $class . '" href="' . $link . '"><i class="ipvisc-fa ipvisc-fa-angle-right"></i></a>';
            return $result;
        }

        /**
         * Get pagination link
         *
         * @param  int $page
         * @return string
         */
        protected function _get_pagination_link( $page )
        {
            $link = admin_url() . '?page=ipvisc&paged=' . $page;
            return $link;
        }

        /**
         * Get pagination page info
         *
         * @return string
         */
        protected function _get_pagination_page_info()
        {
            $result = '<span class="ipvisc-paged-info">' .
                        '<strong>' . $this->_page . '</strong> of <strong>' . $this->_total_page . '</strong>' .
                      '</span>';
            return $result;
        }

        /**
         * Get container
         *
         * @param  string $list
         * @return string
         */
        protected function _get_container( $list )
        {
            $result = '<div class="ipvisc-manage container-fluid container">' .
                        '<div class="ipvisc-manage-list ipvisc-list-stat">' .
                            $list .
                        '</div>' .
                      '</div>';

            return $result;
        }

        /**
         * Get action top
         *
         * @return string
         */
        protected function _get_action_top()
        {
            return '';
        }

        /**
         * Get action bottom
         *
         * @return string
         */
        protected function _get_action_bottom()
        {
            $action = '<div class="ipvisc-action-bottom">' .
                        '<div class="row">' .
                            '<div class="col-sm-6"></div>' .
                            '<div class="col-sm-6 text-right">' .
                                $this->_get_pagination() .
                            '</div>' .
                        '</div>' .
                      '</div>';
            return $action;
        }
    }

}
?>
