<?php
if ( ! class_exists( 'IPVisc_Widget' )) {

    /**
     * Class for handling display widget
     */
    class IPVisc_Widget extends WP_Widget
    {
        /**
         * Register widget with WordPress.
         */
        public function __construct()
        {
            parent::__construct(
                'ipvisc_widget_sidebar', // Base ID
                'Widget Campaign', // Name
                array( 'description' => __( 'A Widget for display campaign countdown', IPVISC_SLUG ), )
            );
        }

        /**
         * Front-end display of widget.
         *
         * @see WP_Widget::widget()
         *
         * @param array $args     Widget arguments.
         * @param array $instance Saved values from database.
         */
        public function widget( $args, $instance )
        {
            $viewer = new IPVisc_Viewer();
            $viewer->widgetCampaignFrontend( $instance, $args );
        }

        /**
         * Back-end widget form.
         *
         * @see WP_Widget::form()
         *
         * @param array $instance Previously saved values from database.
         */
        public function form( $instance )
        {
            $viewer = new IPVisc_Viewer();
            $viewer->widgetCampaignBackend( $instance, $this );
        }

        /**
         * Sanitize widget form values as they are saved.
         *
         * @see WP_Widget::update()
         *
         * @param array $new_instance Values just sent to be saved.
         * @param array $old_instance Previously saved values from database.
         *
         * @return array Updated safe values to be saved.
         */
        public function update( $new_instance, $old_instance )
        {
            $instance = array();
            if ( ! empty( $new_instance['campaign'] ) ) {
                $instance['campaign'] = absint( $new_instance['campaign'] );
            }
            if ( ! empty( $new_instance['title'] ) ) {
                $instance['title'] = apply_filters( 'single_post_title', $new_instance['title'] );
            }
            if ( ! empty( $new_instance['info'] ) ) {
                $instance['info'] = apply_filters( 'single_post_title', $new_instance['info'] );
            }
            return $instance;
        }
    }

}
?>
