<?php
/**
 * Admin header view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$pageDash    = IPVISC_PAGENAME;
$pageAdd     = IPVISC_PAGENAME . '-addnew';
$pageStyle   = IPVISC_PAGENAME . '-style';
$page        = $this->pageId;
$struct = array(
     $pageDash => array(
         'title'     => __( 'All Videos', IPVISC_SLUG ),
         'info'      => __( 'Manage all videos', IPVISC_SLUG ),
         'icon'      => 'playlist-video'
     ),
     $pageAdd => array(
         'title'     => __( 'Add Video', IPVISC_SLUG ),
         'info'      => __( 'Create new video', IPVISC_SLUG ),
         'icon'      => 'plus-alt'
     ),
     $pageStyle => array(
         'title'     => __( 'Widget Style', IPVISC_SLUG ),
         'info'      => __( 'Manage widget styles', IPVISC_SLUG ),
         'icon'      => 'admin-appearance'
     )
 );
?>
<div class="ipvisc-top">
    <div class="ipvisc-header">
        <div class="ipvisc-page-title">
            <h1>
                <i class="dashicons-before dashicons-playlist-video"></i>
                <span>
                    <?php
                    $title = IPVISC_TITLE;
                    $words = explode( ' ', $title );
                    $first = array_shift( $words );
                    $title = implode( ' ', $words );
                    ?>
                    <strong><span><?php echo $first; ?></span> <?php echo $title; ?></strong>
                    <em> <?php echo IPVISC_DESC; ?></em>
                </span>
            </h1>
        </div>
    </div>
    <div class="ipvisc-nav">
        <ul>
        <?php
        $title = isset( $this->title ) ? $this->title : '';
        $info  = isset( $this->info ) ? $this->info : '';
        if ( array_key_exists( $page, $struct ))
        {
            if ( empty( $title )) {
                $title = $struct[$page]['title'];
            }
            if ( empty( $info )) {
                $info  = $struct[$page]['info'];
            }
            if ( empty( $icon )) {
                $icon  = $struct[$page]['icon'];
            }
        }
        foreach( $struct as $name => $data )
        {
            $active = '';
            if ( $page == $name ) {
                $active = ' class="active"';
            }
            echo '<li' . $active . '>' .
                    '<a href="admin.php?page=' . $name . '">' .
                        '<i class="dashicons-before dashicons-' . $data['icon'] . '"></i>' .
                        $data['title'] .
                    '</a>' .
                '</li>';
        }
        ?>
        </ul>
    </div>
    <div class="ipvisc-page-info">
        <i class="dashicons-before dashicons-<?php echo $icon; ?>"></i>
        <div class="ipvisc-info">
            <h3><?php echo $title; ?></h3>
            <h4><?php echo $info; ?></h4>
        </div>
    </div>
</div>
