<?php
/**
 * Admin content button view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipvisc-section-button" class="ipvisc-tab-content">
  <div class="ipvisc-tab-inner">

    <div class="ipvisc-title-content ipvisc-hide">
      <i class="ipvisc-fa ipvisc-fa-square"></i>
      <div class="ipvisc-title-text">
        <h3><?php _e( 'Button', IPVISC_SLUG ); ?></h3>
        <p><?php _e( 'Set the button in the footer widget.', IPVISC_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipvisc-fields -->
    <div class="ipvisc-fields">

      <?php
      /*
       * Button Target
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-button-target"><?php _e( 'Button Target', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $target = $this->setting->getSetting( 'button_target', 'url' );
          $options = array(
            'url'  => __( 'Page URL', IPVISC_SLUG ),
            'form' => __( 'Optin Form', IPVISC_SLUG )
          );
          foreach( $options as $key => $label )
          {
            $checked = '';
            if ( $key == $target ) {
              $checked = ' checked="checked"';
            }
            echo '<label class="mr20">' .
                    '<input class="ipvisc-input-button-target" type="radio" name="button_target" value="' . $key . '"' . $checked . '>' .
                    $label .
                '</label>';
          }
          ?>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'The destination of the button.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Button Link
       */
      $linkDsp = ' style="display:none;"';
      if ( $target == 'url' ) {
        $linkDsp = '';
      }
      ?>
      <!-- start: .ipvisc-field-row -->
      <div id="ipvisc-input-button-link" class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs"<?php echo $linkDsp; ?>>
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-button-link"><?php _e( 'Page URL', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $link = $this->setting->getSetting( 'button_link' );
          ?>
          <input type="text" id="input-button-link" class="ipvisc-input ipvisc-input-full" name="button_link" value="<?php echo $link; ?>">

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'The destination link of the button.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Button Text
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-button-text"><?php _e( 'Button Text', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $title = stripslashes( $this->setting->getSetting( 'button_text' ) );
          ?>
          <input type="text" id="input-button-text" class="ipvisc-input ipvisc-input-full ipvisc-input-v-lg" name="button_text" value="<?php echo $title; ?>">

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'The text of the button.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Button Icon
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-button-icon"><?php _e( 'Button Icon', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $title = stripslashes( $this->setting->getSetting( 'button_icon' ) );
          IPVisc_Faicon::get_html_option( 'button_icon', $icon );
          ?>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'The icon of the button.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Text Align
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-button-text-align"><?php _e( 'Text Align', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select name="button_text-align" id="input-button-text-align">
            <?php
            $current = stripslashes( $this->setting->getSetting( 'button_text_align', 'center' ));
            $aligns  = array(
              'left'   => __( 'Left', IPVISC_SLUG ),
              'center' => __( 'Center', IPVISC_SLUG )
            );
            foreach( $aligns as $key => $label ) {
              $sltd = '';
              if ( $key == $current ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd .'>'. $label .'</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The text alignment of the button content.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Button size
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-button-size"><?php _e( 'Button Size', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select name="button_size" id="input-button-size">
            <?php
            $current = stripslashes( $this->setting->getSetting( 'button_size', 'md' ));
            $sizes   = array(
              'sm'   => __( 'Small', IPVISC_SLUG ),
              'md'   => __( 'Medium', IPVISC_SLUG ),
              'lg'   => __( 'Large', IPVISC_SLUG )
            );
            foreach( $sizes as $key => $label ) {
              $sltd = '';
              if ( $key == $current ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd .'>'. $label .'</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The size of the button.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * New Tab
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-button-new-tab"><?php _e( 'Open Button in New Tab', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <div class="ipvisc-onoff">
              <?php
              $val = stripslashes( $this->setting->getSetting( 'button_new_tab', 'true' ) );
              if ( $val == 'false' ) {
                  $clon  = '';
                  $cloff = ' active';
              } else {
                  $clon  = ' active';
                  $cloff = '';
              }
              ?>
              <div class="ipvisc-btn-group">
                <button data-value="true" class="ipvisc-btn-onoff<?php echo $clon; ?> ipvisc-btn-on" type="button"><?php _e( 'Yes', IPVISC_SLUG ); ?></button>
                <button data-value="false" class="ipvisc-btn-onoff<?php echo $cloff; ?> ipvisc-btn-off" type="button"><?php _e( 'No', IPVISC_SLUG ); ?></button>
              </div>
              <input type="hidden" class="ipvisc-onoff-value" name="button_new_tab" value="<?php echo $val; ?>" />
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Determines whether open link button in new tab browser.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

    </div>
    <!-- end: .ipvisc-fields -->

  </div>
</div>
