<?php
/**
 * Admin content view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipvisc-section-content" class="ipvisc-tab-content">
  <div class="ipvisc-tab-inner">

    <div class="ipvisc-title-content ipvisc-hide">
      <i class="ipvisc-fa ipvisc-fa-file-text"></i>
      <div class="ipvisc-title-text">
        <h3><?php _e( 'Content', IPVISC_SLUG ); ?></h3>
        <p><?php _e( 'Set the video content.', IPVISC_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipvisc-fields -->
    <div class="ipvisc-fields">

      <h3 class="ipvisc-field-title py10"><?php _e( 'Video', IPVISC_SLUG ); ?></h3>
      <?php
      /*
       * Video Type
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-video-type"><?php _e( 'Video Type', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $type    = $this->setting->getSetting( 'video_type', 'upload' );
          $options = array(
            'upload'  => __( 'Upload', IPVISC_SLUG ),
            'youtube' => __( 'Youtube', IPVISC_SLUG )
          );
          foreach( $options as $key => $label )
          {
            $checked = '';
            if ( $key == $type ) {
              $checked = ' checked="checked"';
            }
            echo '<label class="mr20">' .
                    '<input class="ipvisc-input-video-type" type="radio" name="video_type" value="' . $key . '"' . $checked . '>' .
                    $label .
                '</label>';
          }
          ?>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'You can add video by uploading a video file or by using your youtube video.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <!-- start: .ipvisc-video-fields -->
      <div class="ipvisc-video-fields">

        <?php
        $ulDsp = ' style="display:none;"';
        if ( $type == 'upload' ) {
          $ulDsp = '';
        }
        ?>
        <!-- start: #ipvisc-upload-video-fields -->
        <div id="ipvisc-upload-video-fields"<?php echo $ulDsp; ?>>

          <?php
          /*
           * Video File
           */
          ?>
          <!-- start: .ipvisc-field-row -->
          <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
            <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
              <label for="input-video-file"><?php _e( 'Video File', IPVISC_SLUG ); ?></label>
            </div>

            <!-- start: .ipvisc-field -->
            <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

              <div class="ipvisc-video-input">
                <a class="ipvisc-btn ipvisc-btn-secondary ipvisc-btn-video-upload ipvisc-btn-lg" data-choose="<?php esc_attr_e( 'Choose Video', IPVISC_SLUG ); ?>" data-update="<?php esc_attr_e( 'Choose video', IPVISC_SLUG ); ?>">
                    <i class="ipvisc-fa ipvisc-fa-video-camera"></i>
                    <?php _e( 'Select Video', IPVISC_SLUG ); ?>
                </a>

                <?php
                $vidsp   = ' style="display:none;"';
                $thumb   = '';
                $title   = '';
                $videoId = $this->setting->getSetting( 'video_file' );
                if ( ! empty( $videoId ))
                {
                  $vidsp = '';
                  $data  = wp_prepare_attachment_for_js( $videoId );
                  $title = $data['filename'];
                  $thumb = $data['thumb']['src'];
                }
                ?>
                <div class="ipvisc-video-selected clearfix"<?php echo $vidsp; ?>>
                  <div class="ipvisc-video-preview">
                    <img class="ipvisc-video-preview-img" src="<?php echo $thumb; ?>" alt="">
                    <strong class="ipvisc-video-preview-title"><?php echo $title; ?></strong>
                  </div>
                  <div class="ipvisc-video-delete">
                    <a href="#" class="ipvisc-btn ipvisc-btn-default ipvisc-btn-sm">
                      <i class="ipvisc-fa ipvisc-fa-trash"></i>
                      <?php _e( 'Remove Video', IPVISC_SLUG ); ?>
                    </a>
                  </div>
                  <input type="hidden" name="video_file" class="ipvisc-video-id" value="<?php echo $videoId; ?>" />
                </div>
              </div>

            </div>
            <!-- end: .ipvisc-field -->
          </div>
          <!-- end: .ipvisc-field-row -->

          <?php
          /*
           * Video Poster
           */
          ?>
          <!-- start: .ipvisc-field-row -->
          <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
            <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
              <label for="input-video-poster"><?php _e( 'Video Poster', IPVISC_SLUG ); ?></label>
            </div>

            <!-- start: .ipvisc-field -->
            <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

              <div class="ipvisc-upload-image ipvisc-clear">
                  <div class="ipvisc-upload-preview">
                      <?php
                        $setimg = false;
                        if ( $attach_id = $this->setting->getSetting( 'video_poster' ) ) {
                            $setimg = true;
                            $data   = wp_get_attachment_image_src( $attach_id, 'thumbnail' );
                        }
                        if ( $setimg ) {
                            echo '<div class="image"><img src="' . $data[0] . '" /></div>';
                            echo '<div class="none ipvisc-hide">' . __( 'No image', IPVISC_SLUG ) . '</div>';
                            $reset_dsp = '';
                        } else {
                            echo '<div class="image"></div>';
                            echo '<div class="none">' . __( 'No image', IPVISC_SLUG ) . '</div>';
                            $reset_dsp = ' style="display:none;"';
                        }
                      ?>
                  </div>

                  <div class="ipvisc-image-field">
                      <div class="ipvisc-select-image">
                          <p class="mt0"><?php _e( 'Select an image or upload new image using the button below.', IPVISC_SLUG ); ?></p>
                          <a class="ipvisc-btn ipvisc-btn-secondary ipvisc-btn-media ipvisc-btn-sm" data-choose="<?php esc_attr_e( 'Choose Photo', IPVISC_SLUG ); ?>"
                            data-update="<?php esc_attr_e( 'Choose photo', IPVISC_SLUG ); ?>">
                              <i class="ipvisc-fa ipvisc-fa-image"></i>
                              <?php _e( 'Select Photo', IPVISC_SLUG ); ?>
                          </a>
                          <a class="ipvisc-btn ipvisc-btn-reset ipvisc-btn-sm" href="#"<?php echo $reset_dsp; ?>>
                              <i class="ipvisc-fa ipvisc-fa-ban"></i>
                              <?php _e( 'Clear Photo', IPVISC_SLUG ); ?>
                          </a>
                      </div>
                      <input type="hidden" name="upload_type" class="ipvisc-upload-type" value="video_poster" />
                      <input type="hidden" name="video_poster" class="ipvisc-image-id" value="<?php echo $attach_id; ?>" />
                  </div>
              </div>

              <div class="ipvisc-help">
                <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
                <div class="ipvisc-help-content ipvisc-hide">
                  <?php _e( 'Add video poster.', IPVISC_SLUG ); ?>
                </div>
              </div>

            </div>
            <!-- end: .ipvisc-field -->
          </div>
          <!-- end: .ipvisc-field-row -->

        </div>
        <!-- end: #ipvisc-upload-video-fields -->

        <?php
        $ytDsp = ' style="display:none;"';
        if ( $type == 'youtube' ) {
          $ytDsp = '';
        }
        ?>
        <!-- start: #ipvisc-youtube-video-fields -->
        <div id="ipvisc-youtube-video-fields"<?php echo $ytDsp; ?>>

          <?php
          /*
           * Youtube Video URL
           */
          ?>
          <!-- start: .ipvisc-field-row -->
          <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs"<?php echo $linkDsp; ?>>
            <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
              <label for="input-youtube-url"><?php _e( 'Youtube Video URL', IPVISC_SLUG ); ?></label>
            </div>

            <!-- start: .ipvisc-field -->
            <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
              <?php
              $url = $this->setting->getSetting( 'youtube_url' );
              ?>
              <input type="text" id="input-youtube-url" class="ipvisc-input ipvisc-input-full" name="youtube_url" value="<?php echo $url; ?>">

              <div class="ipvisc-help">
                <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
                <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'The URL of your youtube video.', IPVISC_SLUG ); ?>
                </div>
              </div>
            </div>
            <!-- end: .ipvisc-field -->
          </div>
          <!-- end: .ipvisc-field-row -->

          <?php
          //Input Start
          ?>
          <!-- start: .ipvisc-field-row -->
          <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
            <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
              <label for="input-youtube-start"><?php _e( 'Start time', IPVISC_SLUG ); ?></label>
            </div>
            <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
              <div class="ipvisc-input-group">
                <?php
                $start = $this->setting->getSetting( 'youtube_start' );
                ?>
                <input type="text" id="input-youtube-start" class="ipvisc-input ipvisc-input-xs" name="youtube_start" value="<?php echo $start; ?>">
                <div class="ipvisc-input-addon">second</div>
              </div>

              <div class="ipvisc-help">
                <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
                <div class="ipvisc-help-content ipvisc-hide">
                  <?php _e( 'Time in second for start time of your video. You set this value when you want to start the video not from the beginning.', IPVISC_SLUG ); ?>
                </div>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field-row -->

        </div>
        <!-- end: #ipvisc-youtube-video-fields -->

      </div>
      <!-- end: .ipvisc-video-fields -->

      <h3 class="ipvisc-field-title py10 mt30"><?php _e( 'Settings', IPVISC_SLUG ); ?></h3>
      <!-- start: .ipvisc-info-fields -->
      <div class="ipvisc-info-fields">

        <?php
        /*
         * Width
         */
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-video-width"><?php _e( 'Video Width', IPVISC_SLUG ); ?></label>
          </div>

          <!-- start: .ipvisc-field -->
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

            <?php
            $width = $this->setting->getSetting( 'video_width', 450 );
            ?>
            <div class="ipvisc-input-group mr5">
                <input type="text" id="input-video-width" class="ipvisc-input ipvisc-input-xs" name="video_width" value="<?php echo $width; ?>">
                <div class="ipvisc-input-addon">px</div>
            </div>

            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide">
                <?php _e( 'Width ( in pixel ) of the video.', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field -->
        </div>
        <!-- end: .ipvisc-field-row -->

        <?php
        /*
         * Height
         */
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-video-height"><?php _e( 'Video Height', IPVISC_SLUG ); ?></label>
          </div>

          <!-- start: .ipvisc-field -->
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

            <?php
            $height = $this->setting->getSetting( 'video_height', 320 );
            ?>
            <div class="ipvisc-input-group mr5">
                <input type="text" id="input-video-height" class="ipvisc-input ipvisc-input-xs" name="video_height" value="<?php echo $height; ?>">
                <div class="ipvisc-input-addon">px</div>
            </div>

            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide">
                <?php _e( 'Height ( in pixel ) of the video.', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field -->
        </div>
        <!-- end: .ipvisc-field-row -->

        <?php
        //Input autoplay
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-video-autoplay"><?php _e( 'Autoplay', IPVISC_SLUG ); ?></label>
          </div>
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
            <div class="ipvisc-onoff">
                <?php
                $val = $this->setting->getSetting( 'video_autoplay', 'false' );
                if ( $val == 'false' ) {
                    $clon  = '';
                    $cloff = ' active';
                } else {
                    $clon  = ' active';
                    $cloff = '';
                }
                ?>
                <div class="ipvisc-btn-group">
                  <button data-value="true" class="ipvisc-btn-onoff<?php echo $clon; ?> ipvisc-btn-on" type="button"><?php _e( 'On', IPVISC_SLUG ); ?></button>
                  <button data-value="false" class="ipvisc-btn-onoff<?php echo $cloff; ?> ipvisc-btn-off" type="button"><?php _e( 'Off', IPVISC_SLUG ); ?></button>
                </div>
                <input type="hidden" class="ipvisc-onoff-value" name="video_autoplay" value="<?php echo $val; ?>" />
            </div>

            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide">
                <?php _e( 'Is the video automatically plays when the page is loaded?', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field-row -->

      </div>
      <!-- end: .ipvisc-info-fields -->

      <h3 class="ipvisc-field-title py10 mt30"><?php _e( 'Info', IPVISC_SLUG ); ?></h3>
      <!-- start: .ipvisc-info-fields -->
      <div class="ipvisc-info-fields">
        <?php
        /*
         * Title
         */
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-content-title"><?php _e( 'Title', IPVISC_SLUG ); ?></label>
          </div>

          <!-- start: .ipvisc-field -->
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
            <?php
            $title = stripslashes( $this->setting->getSetting( 'content_title' ) );
            ?>
            <input type="text" id="input-content-title" class="ipvisc-input ipvisc-input-full ipvisc-input-v-lg" name="content_title" value="<?php echo $title; ?>">

            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'The title of the video.', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field -->
        </div>
        <!-- end: .ipvisc-field-row -->

        <?php
        /*
         * Info
         */
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-content-info"><?php _e( 'Info', IPVISC_SLUG ); ?></label>
          </div>

          <!-- start: .ipvisc-field -->
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
            <?php
            $info = $this->setting->getSetting( 'content_info' );

            $tinymceInit = array(
                'editor_height' => 120
            );
            $content = stripslashes( $info );
            wp_editor( $content, 'content_info', array(
                'editor_height' => 120,
                'tinymce'       => $tinymceInit
            ));
            ?>

            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'The info of the video.', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field -->
        </div>
        <!-- end: .ipvisc-field-row -->

      </div>
      <!-- end: .ipvisc-info-fields -->

    </div>
    <!-- end: .ipvisc-fields -->

  </div>
</div>
