<?php
/**
 * Admin content countdown view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipvisc-section-countdown" class="ipvisc-tab-content">
  <div class="ipvisc-tab-inner">

    <div class="ipvisc-title-content ipvisc-hide">
      <i class="ipvisc-fa ipvisc-fa-square"></i>
      <div class="ipvisc-title-text">
        <h3><?php _e( 'Countdown', IPVISC_SLUG ); ?></h3>
        <p><?php _e( 'Set the countdown content.', IPVISC_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipvisc-fields -->
    <div class="ipvisc-fields">

      <?php
      /*
       * Show/hide
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-countdown-activate"><?php _e( 'Show/Hide Countdown', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <div class="ipvisc-onoff">
              <?php
              $val = stripslashes( $this->setting->getSetting( 'countdown_activate', 'false' ) );
              if ( $val == 'false' ) {
                  $clon  = '';
                  $cloff = ' active';
              } else {
                  $clon  = ' active';
                  $cloff = '';
              }
              ?>
              <div class="ipvisc-btn-group">
                <button data-value="true" class="ipvisc-btn-onoff<?php echo $clon; ?> ipvisc-btn-on" type="button"><?php _e( 'Show', IPVISC_SLUG ); ?></button>
                <button data-value="false" class="ipvisc-btn-onoff<?php echo $cloff; ?> ipvisc-btn-off" type="button"><?php _e( 'Hide', IPVISC_SLUG ); ?></button>
              </div>
              <input type="hidden" class="ipvisc-onoff-value" name="countdown_activate" value="<?php echo $val; ?>" />
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Determines whether displaying countdown.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Target Date
      ?>
      <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-countdown-target-date"><?php _e( 'Target Date', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $date = $this->setting->getSetting( 'countdown_target_date', current_time( 'Y/m/d' ) );
          $time = $this->setting->getSetting( 'countdown_target_time', current_time( 'H:i' ) );
          ?>
          <div class="ipvisc-input-group mr5">
            <input type="text" value="<?php echo $date; ?>" name="countdown_target_date" class="ipvisc-input ipvisc-input-sm ipvisc-date-picker" id="input-countdown-target_date" readonly>
            <div class="ipvisc-input-addon"><i class="ipvisc-fa ipvisc-fa-calendar"></i></div>
          </div>
          @
          <div class="ipvisc-input-group ml5">
            <input type="text" value="<?php echo $time; ?>" name="countdown_target_time" class="ipvisc-input ipvisc-input-xs ipvisc-time-picker" id="input-countdown-target-time" readonly>
            <div class="ipvisc-input-addon"><i class="ipvisc-fa ipvisc-fa-clock-o"></i></div>
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Target date of your countdown.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>

      <?php
      //Format
      ?>
      <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-countdown-format"><?php _e( 'Format', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select id="input-countdown-format" name="countdown_format">
            <?php
            $format  = $this->setting->getSetting( 'countdown_format', 'd_h_i_s' );
            $formats = array(
              'y_m_d_h_i_s'  => __( 'Year Month Days Hours Minutes Seconds', IPVISC_SLUG ),
              'y_m_d_h_i'    => __( 'Year Month Days Hours Minutes', IPVISC_SLUG ),
              'y_m_d_h'      => __( 'Year Month Days Hours', IPVISC_SLUG ),
              'y_m_d'        => __( 'Year Month Days', IPVISC_SLUG ),
              'm_d_h'        => __( 'Month Days Hours', IPVISC_SLUG ),
              'd_h_i_s'      => __( 'Days Hours Minutes Seconds', IPVISC_SLUG ),
              'd_h_i'        => __( 'Days Hours Minutes', IPVISC_SLUG ),
              'h_mi_s'       => __( 'Hours Minutes Seconds', IPVISC_SLUG ),
              'w_d_h_i_s'    => __( 'Week Days Hours Minutes Seconds', IPVISC_SLUG )
            );
            foreach( $formats as $skey => $label ) {
              $sltd = '';
              if ( $skey == $format ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $skey . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-message ipvisc-hide">
              <?php _e( 'Format of the date of the countdown.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>

      <h4 class="ipvisc-field-title mb0 py10">
          <?php _e( 'Design', IPVISC_SLUG ); ?>
      </h4>

      <?php
      //Background Color
      ?>
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-countdown-bgcolor"><?php _e( 'Background Color', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <input type="text" class="ipvisc-color-picker" id="input-countdown-bgcolor" name="countdown_bgcolor" value="<?php echo $this->setting->getSetting( 'countdown_bgcolor', '#333333' ); ?>" />

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Background color of the countdown.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>

      <?php
      //Font Family
      ?>
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-countdown-font-family"><?php _e( 'Font Family', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $current = $this->setting->getSetting( 'countdown_font_family', 'roboto' );
          $fonts   = IPVisc_Font::getOptions();
          $fname   = IPVisc_Font::getFontName( $current );
          ?>
          <span class="ipvisc-font-family">
            <div class="ipvisc-menu ipvisc-fancy-option">
              <div class="ipvisc-selected">
                <div class="ipvisc-selected-box">
                  <span data-select="<?php echo $current; ?>"><?php echo $fname; ?></span>
                </div>
                <span class="toggle"></span>
              </div>
              <div class="ipvisc-select" style="display: none;">
                <div class="ipvisc-select-content">
                  <ul class="clearfix">
                    <?php
                    foreach( $fonts as $fkey => $label ) :
                    ?>
                    <li data-select="<?php echo $fkey; ?>">
                      <strong class="ipvisc-select-label">
                        <?php echo $label; ?>
                      </strong>
                    </li>
                    <?php
                    endforeach;
                    ?>
                  </ul>
                </div>
              </div>
              <input type="hidden" name="countdown_font_family" class="ipvisc-input-select" value="<?php echo $current; ?>" />
            </div>
          </span>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The font family of the text in your countdown.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>

      <?php
      //Color
      ?>
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-countdown-color"><?php _e( 'Text Color', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <input type="text" class="ipvisc-color-picker" id="input-countdown-color" name="countdown_color" value="<?php echo $this->setting->getSetting( 'countdown_color', '#ffffff' ); ?>" />

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The text color of the countdown.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>

      <?php
      //Border
      ?>
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-countdown-border-width"><?php _e( 'Border', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <div class="ipvisc-input-group mr5">
            <?php
            $bowidth = $this->setting->getSetting( 'countdown_border_width', 2 );
            $bocolor = $this->setting->getSetting( 'countdown_border_color', '#222222' );
            ?>
            <input type="text" id="input-countdown-border-width" class="ipvisc-input ipvisc-input-xxs" name="countdown_border_width" value="<?php echo $bowidth; ?>">
            <div class="ipvisc-input-addon">px</div>
          </div>
          <input type="text" class="ipvisc-color-picker" id="input-countdown-border-color" name="countdown_border_color" value="<?php echo $bocolor; ?>" />

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The border that surrounds the countdown.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>

      <?php
      //Border radius
      ?>
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-countdown-border-radius"><?php _e( 'Border Radius', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select name="countdown_border_radius" id="input-countdown-border-radius">
            <?php
            $current = $this->setting->getSetting( 'countdown_border_radius', 'none' );
            $styles  = array(
              'none' => __( 'None', IPVISC_SLUG ),
              'sm'   => __( 'Small', IPVISC_SLUG ),
              'md'   => __( 'Medium', IPVISC_SLUG ),
              'lg'   => __( 'Large', IPVISC_SLUG )
            );
            foreach( $styles as $skey => $label ) {
              $sltd = '';
              if ( $skey == $current ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $skey . '"' . $sltd .'>'. $label .'</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The border radius of the countdown.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>

    </div>
    <!-- end: .ipvisc-fields -->

  </div>
</div>
