<?php
/**
 * Admin content general view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipvisc-section-general" class="ipvisc-tab-content">
  <div class="ipvisc-tab-inner">

    <div class="ipvisc-title-content ipvisc-hide">
      <i class="ipvisc-fa ipvisc-fa-cogs"></i>
      <div class="ipvisc-title-text">
        <h3><?php _e( 'General', IPVISC_SLUG ); ?></h3>
        <p><?php _e( 'Basic settings and info of your video', IPVISC_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipvisc-fields -->
    <div class="ipvisc-fields">

      <?php
      /*
       * Title
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-title"><?php _e( 'Video Title', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $title = '';
          if ( $this->video ) {
            $title = stripslashes( $this->video->post_title );
          }
          ?>
          <input type="text" id="input-title" class="ipvisc-input ipvisc-input-full ipvisc-input-v-lg" name="title" value="<?php echo $title; ?>">

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'The title of the video. This data will not be used directly in creating video, only to mark the video, so it easier for you to manage it.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Style
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-widget-style"><?php _e( 'Widget Style', IPSURV_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select name="widget_style" id="input-widget-style">
            <?php
            $current = $this->setting->getSetting( 'widget_style', 'none' );
            foreach( $this->styles as $style )
            {
              $sltd = '';
              if ( $current == $style->ID ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $style->ID . '"' . $sltd . '>' . $style->post_title . '</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Set the style of the video.', IPSURV_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Status
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-status"><?php _e( 'Status', IPSURV_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <div class="ipvisc-onoff">
              <?php
              $val  = 'true';
              if ( $this->video && $this->video->post_status == 'draft' ) {
                  $val = 'false';
              }
              if ( $val == 'false' ) {
                  $clon  = '';
                  $cloff = ' active';
              } else {
                  $clon  = ' active';
                  $cloff = '';
              }
              ?>
              <div class="ipvisc-btn-group">
                <button data-value="true" class="ipvisc-btn-onoff<?php echo $clon; ?> ipvisc-btn-on" type="button"><?php _e( 'Show', IPSURV_SLUG ); ?></button>
                <button data-value="false" class="ipvisc-btn-onoff<?php echo $cloff; ?> ipvisc-btn-off" type="button"><?php _e( 'Hide', IPSURV_SLUG ); ?></button>
              </div>
              <input type="hidden" class="ipvisc-onoff-value" name="status" value="<?php echo $val; ?>" />
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Determines the status of the video, whether the video will be viewable by the public or not.', IPSURV_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Restricted user
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-restricted"><?php _e( 'Restricted', IPSURV_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <div class="ipvisc-onoff">
              <?php
              $val = $this->setting->getSetting( 'restricted', 'false' );
              if ( $val == 'false' ) {
                  $clon  = '';
                  $cloff = ' active';
              } else {
                  $clon  = ' active';
                  $cloff = '';
              }
              ?>
              <div class="ipvisc-btn-group">
                <button data-value="true" class="ipvisc-btn-onoff<?php echo $clon; ?> ipvisc-btn-on" type="button"><?php _e( 'On', IPSURV_SLUG ); ?></button>
                <button data-value="false" class="ipvisc-btn-onoff<?php echo $cloff; ?> ipvisc-btn-off" type="button"><?php _e( 'Off', IPSURV_SLUG ); ?></button>
              </div>
              <input type="hidden" class="ipvisc-onoff-value" name="restricted" value="<?php echo $val; ?>" />
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Deciding whether to tighten the contest page where only logged-in user can view the page.', IPSURV_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

    </div>
    <!-- end: .ipvisc-fields -->

  </div>
</div>
