<?php
/**
 * Admin content Optin Form view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipvisc-section-optin" class="ipvisc-tab-content">
  <div class="ipvisc-tab-inner">

    <div class="ipvisc-title-content ipvisc-hide">
      <i class="ipvisc-fa ipvisc-fa-pencil-square-o"></i>
      <div class="ipvisc-title-text">
        <h3><?php _e( 'Optin Form', IPVISC_SLUG ); ?></h3>
        <p><?php _e( 'Settings for Optin Form', IPVISC_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipvisc-fields -->
    <div class="ipvisc-fields">

      <?php
      //Form Title
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-responder-title"><?php _e( 'Form Title', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $title = stripslashes( $this->setting->getSetting( 'responder_title', '' ));
          ?>
          <input type="text" id="input-responder-title" class="ipvisc-input ipvisc-input-full ipvisc-input-preview" name="responder_title" value="<?php echo $title; ?>">

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Set the title for the optin form.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Form Info
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-responder-info"><?php _e( 'Form Info', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $info = stripslashes( $this->setting->getSetting( 'responder_info', '' ));
          ?>
          <input type="text" id="input-responder-info" class="ipvisc-input ipvisc-input-full ipvisc-input-preview" name="responder_info" value="<?php echo $info; ?>">

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Set the info for the optin form.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Form Code
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-y ipvisc-help-abs">
        <div class="ipvisc-form-label">
          <label for="input-autoresponder-code"><?php _e( 'Form Code', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field">

          <?php
          $code = $this->setting->getSetting( 'autoresponder_code', '' );
          ?>
          <textarea class="ipvisc-input ipvisc-input-full ipvisc-input-optin" id="input-autoresponder-code" name="autoresponder_code" rows="7"><?php echo $code; ?></textarea>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Code of autoresponder form which can be obtained from the online email marketing you use such as MailChimp, AWeber', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      $hdisplay = ' style="display:none;"';
      if ( ! empty( $code ) ) {
          $hdisplay = '';
      }
      $data = IPVisc_Form::parse( $code );
      ?>
      <!-- start: .ipvisc-optin-settings -->
      <div class="ipvisc-optin-settings"<?php echo $hdisplay; ?>>

        <?php
        //Form Action URL
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-autoresponder-action"><?php _e( 'Action URL', IPVISC_SLUG ); ?></label>
          </div>
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
            <?php
            $action = $this->setting->getSetting( 'autoresponder_action', $data['action'] );
            ?>
            <input type="text" id="input-autoresponder-action" class="ipvisc-input ipvisc-input-full ipvisc-input-autoresponder-action" name="autoresponder_action" value="<?php echo $action; ?>">
            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide">
                <?php _e( 'The url of the script that will handle the optin form', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field-row -->

        <?php
        //Form Email Field
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-autoresponder-email"><?php _e( 'Form Email Field', IPVISC_SLUG ); ?></label>
          </div>
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
            <select name="autoresponder_email" id="input-autoresponder-email">
              <option value="0">-- <?php _e( 'Select field', IPVISC_SLUG ); ?> --</option>
                <?php
                $value = stripslashes( $this->setting->getSetting( 'autoresponder_email', '' ) );
                if ( ! empty( $data['fields'] )) {
                  foreach( $data['fields'] as $field ) {
                    $sltd = '';
                    if ( $field == $value ) {
                      $sltd = ' selected="selected"';
                    }
                    echo '<option value="' . $field . '"' . $sltd . '>' . $field . '</option>';
                  }
                }
                ?>
              </select>
              <?php
              $label = stripslashes( $this->setting->getSetting( 'autoresponder_email_label', '' ) );
              ?>
              <input class="ipvisc-input ipvisc-input-full mt10" type="text" id="input-autoresponder-email-label" value="<?php echo $label; ?>" name="autoresponder_email_label" placeholder="<?php _e( 'Input email label', IPVISC_SLUG ); ?>">
              <div class="ipvisc-help">
                <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
                <div class="ipvisc-help-content ipvisc-hide">
                  <?php _e( 'Set the input of the email optin form. Select a name that represents an email input and specify the title of the email input', IPVISC_SLUG ); ?>
                </div>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field-row -->

          <?php
          //Form Name Field
          ?>
          <!-- start: .ipvisc-field-row -->
          <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
            <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
              <label for="input-autoresponder-name"><?php _e( 'Form Name Field', IPVISC_SLUG ); ?></label>
            </div>
            <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
              <div class="ipvisc-onoff mr10">
                <?php
                $val = $this->setting->getSetting( 'autoresponder_name_activate', 'true' );
                if ( $val == 'false' ) {
                  $clon  = '';
                  $cloff = ' active';
                } else {
                  $clon  = ' active';
                  $cloff = '';
                }
                ?>
                <div class="ipvisc-btn-group">
                  <button data-value="true" class="ipvisc-btn-onoff<?php echo $clon; ?> ipvisc-btn-on" type="button"><?php _e( 'On', IPVISC_SLUG ); ?></button>
                  <button data-value="false" class="ipvisc-btn-onoff<?php echo $cloff; ?> ipvisc-btn-off" type="button"><?php _e( 'Off', IPVISC_SLUG ); ?></button>
                </div>
                <input type="hidden" class="ipvisc-onoff-value" name="autoresponder_name_activate" value="<?php echo $val; ?>" />
              </div>

              <select name="autoresponder_name" id="input-autoresponder-name">
                <option value="0">-- <?php _e( 'Select field', IPVISC_SLUG ); ?> --</option>
                <?php
                $value = stripslashes( $this->setting->getSetting( 'autoresponder_name', '' ) );
                if ( ! empty( $data['fields'] )) {
                  foreach( $data['fields'] as $field ) {
                    $sltd = '';
                    if ( $field == $value ) {
                      $sltd = ' selected="selected"';
                    }
                    echo '<option value="' . $field . '"' . $sltd . '>' . $field . '</option>';
                  }
                }
                ?>
              </select>
              <?php
              $label = stripslashes( $this->setting->getSetting( 'autoresponder_name_label', '' ) );
              ?>
              <input class="ipvisc-input ipvisc-input-full mt10" type="text" id="input-autoresponder-name-label" value="<?php echo $label; ?>" name="autoresponder_name_label" placeholder="<?php _e( 'Input name label', IPVISC_SLUG ); ?>">
              <div class="ipvisc-help">
                <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
                <div class="ipvisc-help-content ipvisc-hide">
                  <?php _e( 'Set the input name of the optin form. You can set whether to display the input name or not. if shown you should choose a name that represents the input name and determine the title of the input name', IPVISC_SLUG ); ?>
                </div>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field-row -->

      </div>
      <!-- end: .ipvisc-optin-settings -->

      <?php
      //Show/Hide Form Label
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-autoresponder-form-label"><?php _e( 'Show/Hide Form Label', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <div class="ipvisc-onoff mr10">
            <?php
            $val = $this->setting->getSetting( 'autoresponder_form_label', 'true' );
            if ( $val == 'false' ) {
              $clon  = '';
              $cloff = ' active';
            } else {
              $clon  = ' active';
              $cloff = '';
            }
            ?>
            <div class="ipvisc-btn-group">
              <button data-value="true" class="ipvisc-btn-onoff<?php echo $clon; ?> ipvisc-btn-on" type="button"><?php _e( 'Show', IPVISC_SLUG ); ?></button>
              <button data-value="false" class="ipvisc-btn-onoff<?php echo $cloff; ?> ipvisc-btn-off" type="button"><?php _e( 'Hide', IPVISC_SLUG ); ?></button>
            </div>
            <input type="hidden" class="ipvisc-onoff-value" name="autoresponder_form_label" value="<?php echo $val; ?>" />
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Specifies whether to display the label on each input form. If set to off, the label will be displayed as a placeholder in the input.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Button Text
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-autoresponder-button-text"><?php _e( 'Submit Button Text', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $text = $this->setting->getSetting( 'autoresponder_button_text', '' );
          ?>
          <input class="ipvisc-input ipvisc-input-full" type="text" id="input-autoresponder-button-text" value="<?php echo $text; ?>" name="autoresponder_button_text">
          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Specifies text or labels of the form submit button', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

    </div>
    <!-- end: .ipvisc-fields -->

  </div>
</div>
