<?php
/**
 * Admin content share view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipvisc-section-share" class="ipvisc-tab-content">
  <div class="ipvisc-tab-inner">

    <div class="ipvisc-title-content ipvisc-hide">
      <i class="ipvisc-fa ipvisc-fa-share-alt"></i>
      <div class="ipvisc-title-text">
        <h3><?php _e( 'Share', IPVISC_SLUG ); ?></h3>
        <p><?php _e( 'Setting the share button in the widget.', IPVISC_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipvisc-fields -->
    <div class="ipvisc-fields ipvisc-social-option">

      <?php
      /*
       * Show/hide Share
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-share-activate"><?php _e( 'Show/Hide Share Buttons', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <div class="ipvisc-onoff">
              <?php
              $val = stripslashes( $this->setting->getSetting( 'share_activate', 'false' ) );
              if ( $val == 'false' ) {
                  $clon  = '';
                  $cloff = ' active';
              } else {
                  $clon  = ' active';
                  $cloff = '';
              }
              ?>
              <div class="ipvisc-btn-group">
                <button data-value="true" class="ipvisc-btn-onoff<?php echo $clon; ?> ipvisc-btn-on" type="button"><?php _e( 'Show', IPVISC_SLUG ); ?></button>
                <button data-value="false" class="ipvisc-btn-onoff<?php echo $cloff; ?> ipvisc-btn-off" type="button"><?php _e( 'Hide', IPVISC_SLUG ); ?></button>
              </div>
              <input type="hidden" class="ipvisc-onoff-value" name="share_activate" value="<?php echo $val; ?>" />
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Determines whether displaying share buttons in widget.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * DIsplay options
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-y ipvisc-help-abs">
        <div class="ipvisc-form-label">
          <label for="input-share-activate"><?php _e( 'Button Activate', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field">

          <p><?php _e( 'Select one or more share button that you want to display on the contest below.', IPVISC_SLUG ); ?></p>
          <div class="ipvisc-social-active">
              <ul>
                  <?php
                  $social = array(
                      'facebook'      => 'Facebook',
                      'twitter'       => 'Twitter',
                      'google-plus'   => 'Google+',
                      'linkedin'      => 'LinkedIn',
                      'tumblr'        => 'Tumblr',
                      'pinterest'     => 'Pinterest',
                      'stumbleupon'   => 'Stumble Upon',
                      'digg'          => 'Digg'
                  );
                  foreach( $social as $key => $label ) {
                      $value = $this->setting->getSetting( 'share_'.$key, 'on' );
                      $class = 'inactive';
                      if ( $value == 'on' ) {
                          $class = "active";
                      }
                      $icon = $key;
                  ?>
                      <li>
                          <a class="<?php echo $class; ?>" href="#<?php echo $key; ?>">
                              <i class="ipvisc-fa ipvisc-fa-<?php echo $icon; ?>"></i>
                              <span><?php echo $label; ?></span>
                              <input type="hidden" name="share_<?php echo $key; ?>" value="<?php echo $value; ?>" />
                          </a>
                      </li>
                  <?php
                  }
                  ?>
              </ul>
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Determine the share button which will be displayed.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Style
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-y ipvisc-help-abs">
        <div class="ipvisc-form-label">
          <label for="input-share-button-style"><?php _e( 'Button Style', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field">

          <select name="share_button_style" id="input-share-button-style">
              <?php
              $style   = $this->setting->getSetting( 'share_button_style', 'square_flat' );
              $options = array(
                  'square_flat'   => __( 'Square Flat', IPVISC_SLUG ),
                  'square_grad'   => __( 'Square Gradient', IPVISC_SLUG ),
                  'square_3d'     => __( 'Square 3D', IPVISC_SLUG ),
                  'square_shadow' => __( 'Square Shadow', IPVISC_SLUG ),
                  'round_flat'    => __( 'Round Flat', IPVISC_SLUG ),
                  'round_grad'    => __( 'Round Gradient', IPVISC_SLUG ),
                  'round_3d'      => __( 'Round 3D', IPVISC_SLUG ),
                  'round_shadow'  => __( 'Round Shadow', IPVISC_SLUG )
              );
              foreach( $options as $no => $label ) {
                  $sltd = '';
                  if ( $no == $style ) {
                      $sltd = ' selected="selected"';
                  }
                  echo '<option value="' . $no . '"' . $sltd . '>' . $label . '</option>';
              }
              ?>
          </select>
          <h4 class="mb15"><?php _e( 'Preview', IPVISC_SLUG ); ?></h4>
          <div class="ipvisc-icon-preview ipvisc-clear">
                  <?php
                  $socials = array(
                      'facebook',
                      'twitter',
                      'linkedin',
                      'pinterest',
                      'googleplus',
                      'tumblr',
                      'stumbleupon',
                      'digg'
                  );
                  foreach( $socials as $name ) {
                      $src = IPVISC_BASE_URL . 'assets/img/icon/'.$style.'/'.$name.'.png';
                      echo '<span class="ipvisc-icon"><img src="'.$src.'" alt="'.$name.'"></span>';
                  }
                  ?>
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The style of the share button.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

    </div>
    <!-- end: .ipvisc-fields -->

  </div>
</div>
