<?php
/**
 * Admin statistic view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipvisc-section-statistic" class="ipvisc-tab-content ipvisc-save-hide">
  <div class="ipvisc-tab-inner">

    <div class="ipvisc-title-content ipvisc-hide">
      <i class="ipvisc-fa ipvisc-fa-line-chart"></i>
      <div class="ipvisc-title-text">
        <h3><?php _e( 'Statistic', IPVISC_SLUG ); ?></h3>
        <p><?php _e( 'See the statistic data for your video', IPVISC_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipvisc-fields -->
    <div class="ipvisc-fields">

      <!-- start: .ipvisc-statistic -->
      <div class="ipvisc-statistic">

        <?php
        $model      = new IPVisc_Model_Stat();
        $videoId    = $this->video->ID;
        $view       = $model->getStatValue( $videoId, 'view' );
        $click      = $model->getStatValue( $videoId, 'click' );
        $subscribe  = $model->getStatValue( $videoId, 'subscribe' );
        $play       = $model->getStatValue( $videoId, 'play' );
        ?>

        <div class="ipvisc-stat-filter ipvisc-clear">
          <div class="ipvisc-stat-nav">
            <div class="container container-fluid">
              <ul class="row">
                <li class="col-sm-3 ipvisc-nav-view ipvisc-nav-blue active">
                  <a href="#stat-view">
                    <i class="ipvisc-fa ipvisc-fa-eye"></i>
                    <span class="stat-value">
                      <strong> <?php echo number_format( $view ); ?></strong>
                      <em> <?php _e( 'View', IPVISC_SLUG ); ?></em>
                    </span>
                  </a>
                </li>
                <li class="col-sm-3 ipvisc-nav-subscribe ipvisc-nav-red">
                  <a href="#stat-play">
                    <i class="ipvisc-fa ipvisc-fa-youtube-play"></i>
                    <span class="stat-value">
                      <strong> <?php echo number_format( $play ); ?></strong>
                      <em> <?php _e( 'Play', IPVISC_SLUG ); ?></em>
                    </span>
                  </a>
                </li>
                <li class="col-sm-3 ipvisc-nav-buy ipvisc-nav-orange">
                  <a href="#stat-click">
                    <i class="ipvisc-fa ipvisc-fa-shield"></i>
                    <span class="stat-value">
                      <strong> <?php echo number_format( $click ); ?></strong>
                      <em> <?php _e( 'Clicks', IPVISC_SLUG ); ?></em>
                    </span>
                  </a>
                </li>
                <li class="col-sm-3 ipvisc-nav-social ipvisc-nav-green">
                  <a href="#stat-subscribe">
                    <i class="ipvisc-fa ipvisc-fa-chain"></i>
                    <span class="stat-value">
                      <strong> <?php echo number_format( $subscribe ); ?></strong>
                      <em> <?php _e( 'Subscribe', IPVISC_SLUG ); ?></em>
                    </span>
                  </a>
                </li>
              </ul>
            </div>
          </div>
          <div class="ipvisc-date-filter">
            <form action="" method="post">
              <input type="hidden" id="value-videoid" name="videoid" value="<?php echo $videoId; ?>" />
              <input type="hidden" id="value-stat-type" name="stat_type" value="display" />
              <?php
              $dateStart = date('m/d/Y');
              $dateEnd   = date('m/d/Y');
              ?>
              <strong> <?php _e( 'Filter By Date', IPVISC_SLUG ); ?>: </strong>
              <span class="ipvisc-date-input">
                <input type="text" id="date-start" name="cdatestart" value="<?php echo $dateStart; ?>" />
                -
                <input type="text" id="date-end" name="cdateend" value="<?php echo $dateEnd; ?>" />
              </span>
              <span class="ipvisc-do-filter">
                <input type="submit" id="do-filter-date" class="button button-primary" name="do_filter_date" value="<?php _e( 'Go', IPVISC_SLUG ); ?>" />
              </span>
            </form>
          </div>
        </div>

        <div class="ipvisc-stat-main">
            <h4><?php _e( 'Views Statistic', IPVISC_SLUG ); ?></h4>
            <div class="ipvisc-stat-chart">

                <script type="text/javascript" src="https://www.google.com/jsapi"></script>
                <script type="text/javascript">
                    google.load("visualization", "1", {packages:["corechart"]});
                    google.setOnLoadCallback(drawChart);
                    function drawChart() {

                        var dataTable = new google.visualization.DataTable();
                        dataTable.addColumn( 'date', '<?php _e( 'Date', IPVISC_SLUG ); ?>' );
                        dataTable.addColumn( 'number', '<?php _e( 'Display', IPVISC_SLUG ); ?>' );

                        var rows = [
                        <?php
                        $stdata = $model->getStatisticData( $videoId, 'view' );
                        if ( $stdata ) {
                            foreach( $stdata as $data ) {
                                $timestamp = strtotime( $data->gdate );
                                $phpdate   = getdate($timestamp);

                                echo '[new Date('
                                        . $phpdate['year'] . ', '
                                        . ( $phpdate['mon']  - 1 ) . ', '
                                        . $phpdate['mday'] . ',0,0,0), '
                                        . $data->value
                                    . '],';
                            }
                        }
                        ?>
                        ];
                        dataTable.addRows( rows );

                        var options = {
                            series: [{pointSize:6}]
                        };
                        var chart = new google.visualization.LineChart(document.getElementById('ipvisc-chart-div'));
                        chart.draw(dataTable, options);
                    }
                </script>

                <div id="ipvisc-chart-div" class="ipvisc-chart-main" style="width: 100%; height: 500px;"></div>
                <div class="ipvisc-chart-load" style="display: none;">
                    <?php
                    $src = IPVISC_BASE_URL . 'assets/img/loading.gif';
                    ?>
                    <img src="<?php echo $src; ?>" alt="Loading..." />
                </div>

            </div>
        </div>

      </div>
      <!-- end: .ipvisc-statistic -->

    </div>
    <!-- end: .ipvisc-fields -->

  </div>
</div>
