<?php
/**
 * Admin content style view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipvisc-section-style" class="ipvisc-tab-content">
  <div class="ipvisc-tab-inner">

    <div class="ipvisc-title-content ipvisc-hide">
      <i class="ipvisc-fa ipvisc-fa-paint-brush"></i>
      <div class="ipvisc-title-text">
        <h3><?php _e( 'Style', IPVISC_SLUG ); ?></h3>
        <p><?php _e( 'Set the style of the video section.', IPVISC_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipvisc-fields -->
    <div class="ipvisc-fields">

      <?php
      /*
       * Background Color
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-background-color"><?php _e( 'Background Color', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $color = stripslashes( $this->setting->getSetting( 'background_color', '#ffffff' ) );
          ?>
          <input type="text" class="ipvisc-color-picker" id="input-background-color" name="background_color" value="<?php echo $color; ?>" />

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Add background color for the video section.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Border
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-border-width"><?php _e( 'Border', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $color   = stripslashes( $this->setting->getSetting( 'border_color', '#cccccc' ) );
          $bowidth = $this->setting->getSetting( 'border_width', 0 );
          ?>
          <div class="ipvisc-input-group mr5">
            <input type="text" id="input-border-width" class="ipvisc-input ipvisc-input-xxs" name="border_width" value="<?php echo $bowidth; ?>">
            <div class="ipvisc-input-addon">px</div>
          </div>
          <input type="text" class="ipvisc-color-picker" id="input-border-color" name="border_color" value="<?php echo $color; ?>" />

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Add border for the video section.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Text Color
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-text-color"><?php _e( 'Text Color', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $color = stripslashes( $this->setting->getSetting( 'text_color', '#333333' ) );
          ?>
          <input type="text" class="ipvisc-color-picker" id="input-text-color" name="text_color" value="<?php echo $color; ?>" />

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Add text color for the video section.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Font Family
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-font-family"><?php _e( 'Font Family', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $current = $this->setting->getSetting( 'font_family', 'roboto' );
          $fonts   = IPVisc_Font::getOptions();
          $fname   = IPVisc_Font::getFontName( $current );
          ?>
          <span class="ipvisc-font-family">
            <div class="ipvisc-menu ipvisc-fancy-option">
              <div class="ipvisc-selected">
                <div class="ipvisc-selected-box">
                  <span data-select="<?php echo $current; ?>"><?php echo $fname; ?></span>
                </div>
                <span class="toggle"></span>
              </div>
              <div class="ipvisc-select" style="display: none;">
                <div class="ipvisc-select-content">
                  <ul class="clearfix">
                    <?php
                    foreach( $fonts as $fkey => $label ) :
                    ?>
                    <li data-select="<?php echo $fkey; ?>">
                      <strong class="ipvisc-select-label">
                        <?php echo $label; ?>
                      </strong>
                    </li>
                    <?php
                    endforeach;
                    ?>
                  </ul>
                </div>
              </div>
              <input type="hidden" name="font_family" class="ipvisc-input-select" value="<?php echo $current; ?>" />
            </div>
          </span>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The font family of the widget content.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Font size
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-font-size"><?php _e( 'Font Size', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select name="font_size" id="input-font-size">
            <?php
            $current = stripslashes( $this->setting->getSetting( 'font_size', 'md' ));
            $sizes   = array(
              'sm'   => __( 'Small', IPVISC_SLUG ),
              'md'   => __( 'Medium', IPVISC_SLUG ),
              'lg'   => __( 'Large', IPVISC_SLUG )
            );
            foreach( $sizes as $key => $label ) {
              $sltd = '';
              if ( $key == $current ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd .'>'. $label .'</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The font size of the widget content.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Text Align
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-text-align"><?php _e( 'Text Align', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select name="text_align" id="input-text-align">
            <?php
            $current = stripslashes( $this->setting->getSetting( 'text_align', 'center' ));
            $aligns  = array(
              'left'   => __( 'Left', IPVISC_SLUG ),
              'center' => __( 'Center', IPVISC_SLUG )
            );
            foreach( $aligns as $key => $label ) {
              $sltd = '';
              if ( $key == $current ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd .'>'. $label .'</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The text alignment of the header content.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Padding
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-padding"><?php _e( 'Padding', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $padding = $this->setting->getSetting( 'padding' );
          ?>
          <div class="ipvisc-input-group mr5">
              <input type="text" id="input-padding" class="ipvisc-input ipvisc-input-xs" name="padding" value="<?php echo $padding; ?>">
              <div class="ipvisc-input-addon">px</div>
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Space arround the video section.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Border radius
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-border-radius"><?php _e( 'Border Radius', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select name="border_radius" id="input-border-radius">
            <?php
            $current = stripslashes( $this->setting->getSetting( 'border_radius', 'none' ));
            $styles  = array(
              'none' => __( 'None', IPVISC_SLUG ),
              'sm'   => __( 'Small', IPVISC_SLUG ),
              'md'   => __( 'Medium', IPVISC_SLUG ),
              'lg'   => __( 'Large', IPVISC_SLUG )
            );
            foreach( $styles as $key => $label ) {
              $sltd = '';
              if ( $key == $current ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd .'>'. $label .'</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The border radius of the video.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Shadow
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-shadow"><?php _e( 'Shadow', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <div class="ipvisc-onoff">
              <?php
              $val = $this->setting->getSetting( 'shadow', 'false' );
              if ( $val == 'false' ) {
                  $clon  = '';
                  $cloff = ' active';
              } else {
                  $clon  = ' active';
                  $cloff = '';
              }
              ?>
              <div class="ipvisc-btn-group">
                <button data-value="true" class="ipvisc-btn-onoff<?php echo $clon; ?> ipvisc-btn-on" type="button"><?php _e( 'Show', IPSURV_SLUG ); ?></button>
                <button data-value="false" class="ipvisc-btn-onoff<?php echo $cloff; ?> ipvisc-btn-off" type="button"><?php _e( 'Hide', IPSURV_SLUG ); ?></button>
              </div>
              <input type="hidden" class="ipvisc-onoff-value" name="shadow" value="<?php echo $val; ?>" />
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Set On if you want add shadow in the video section.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

    </div>
    <!-- end: .ipvisc-fields -->

  </div>
</div>
