<?php
/**
 * Admin setting view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipvisc-setting" class="wrap ipvisc-wrap ipvisc-admin">
  <div class="ipvisc-inner">

    <?php
    $this->view( 'manage/general/header' );
    ?>

    <div class="ipvisc-main">
      <div class="ipvisc-main-info"></div>

      <div class="ipvisc-primary">
        <div class="ipvisc-manage-wrap">
          <?php
          $formAction = admin_url( 'admin-ajax.php' ) . '?doajax=1&ipvisc=1&action=setting';
          ?>
          <form id="ipvisc-form-setting" class="ipvisc-form-container ipvisc-form" method="post" action="<?php echo $formAction; ?>" enctype="multipart/form-data">

            <div class="container-fluid container">
              <div class="mb40">
                <h3 class="ipvisc-field-title mb20 py10"><?php _e( 'Permalink', IPVISC_SLUG ); ?></h3>
                <p><?php _e( 'Set the base path permalink for all your survey pages through the following input:', IPVISC_SLUG ); ?></p>
                <div class="fields">

                  <div class="ipvisc-field-row ipvisc-field-x">
                    <div class="ipvisc-form-label col-lg-2 col-md-3 col-sm-4">
                      <label for="input-promo-base-path"><?php _e( 'Promo Page Base Path', IPVISC_SLUG ); ?></label>
                    </div>
                    <div class="ipvisc-field col-lg-6 col-md-8 col-sm-8">
                      <?php
                      $promoPath = get_option( '__ipvisc_promo_base_path', 'promo' );
                      ?>
                      <input type="text" id="input-promo-base-path" class="ipvisc-input ipvisc-input-full" name="promo_base_path" value="<?php echo $promoPath; ?>">
                    </div>
                  </div>

                </div>

                <h3 class="ipvisc-field-title mb20 py10"><?php _e( 'General Widget', IPVISC_SLUG ); ?></h3>
                <p><?php _e( 'Show a widget in all page. If it is determined that all of the settings of widget object in every page of the website will be ignored.', IPVISC_SLUG ); ?></p>
                <div class="fields">

                  <?php
                  /*
                   * Widget
                   */
                  ?>
                  <!-- start: .ipvisc-field-row -->
                  <div class="ipvisc-field-row ipvisc-field-x">
                    <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
                      <label for="input-general-widget"><?php _e( 'Widget', IPVISC_SLUG ); ?></label>
                    </div>

                    <!-- start: .ipvisc-field -->
                    <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

                      <select name="general_widget" id="input-general-widget">
                        <option value="0"><?php _e( 'None', IPVISC_SLUG ); ?></option>
                        <?php
                        $current = get_option( '__ipvisc_general_widget' );
                        if ( ! empty( $this->widgets ))
                        {
                          foreach( $this->widgets as $widget )
                          {
                            $sltd = '';
                            if ( $widget->ID == $current ) {
                              $sltd = ' selected="selected"';
                            }
                            echo '<option value="' . $widget->ID . '"' . $sltd . '>' . $widget->post_title . '</option>';
                          }
                        }
                        ?>
                      </select>
                    </div>
                    <!-- end: .ipvisc-field -->
                  </div>
                  <!-- end: .ipvisc-field-row -->

                </div>

                <h3 class="ipvisc-field-title mb20 py10"><?php _e( 'Home Widget', IPVISC_SLUG ); ?></h3>
                <p><?php _e( 'Select a widget in bellow to show widget in your homepage.', IPVISC_SLUG ); ?></p>
                <div class="fields">

                  <?php
                  /*
                   * Widget
                   */
                  ?>
                  <!-- start: .ipvisc-field-row -->
                  <div class="ipvisc-field-row ipvisc-field-x">
                    <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
                      <label for="input-home-widget"><?php _e( 'Widget', IPVISC_SLUG ); ?></label>
                    </div>

                    <!-- start: .ipvisc-field -->
                    <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

                      <select name="home_widget" id="input-home-widget">
                          <option value="0"><?php _e( 'None', IPVISC_SLUG ); ?></option>
                          <?php
                          $current = get_option( '__ipvisc_home_widget' );

                          if ( ! empty( $this->widgets ))
                          {
                              foreach( $this->widgets as $widget )
                              {
                                  $sltd = '';
                                  if ( $widget->ID == $current ) {
                                      $sltd = ' selected="selected"';
                                  }
                                  echo '<option value="' . $widget->ID . '"' . $sltd . '>' . $widget->post_title . '</option>';
                              }
                          }
                          ?>
                      </select>
                    </div>
                    <!-- end: .ipvisc-field -->
                  </div>
                  <!-- end: .ipvisc-field-row -->
                </div>

              </div>

              <div class="ipvisc-form-footer">
                <div class="row">
                  <div class="col-md-6">
                    <div class="ipvisc-bottom-submit">
                      <button type="submit" class="ipvisc-form-submit ipvisc-btn ipvisc-btn-secondary ipvisc-btn-lg" id="do-save-setting" name="save_setting">
                        <i class="ipvisc-fa ipvisc-fa-floppy-o"></i>
                        <strong><?php _e( 'Save Change', IPVISC_SLUG ); ?></strong>
                      </button>
                    </div>
                  </div>
                  <div class="col-md-6">
                  </div>
                </div>

              </div>

            </div>
          </form>
        </div>
      </div>

    </div>

  </div>

</div>
