<?php
/**
 * Autoresponder shortcode view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$videoPost    = $this->videoPost;
$setting      = $this->setting;
$style        = $this->style;
$styleSetting = $this->styleSetting;

$target = $setting->getSetting( 'button_target', 'url' );
if ( $target != 'form' ) {
  return true;
}

$label   = $setting->getSetting( 'autoresponder_form_label', 'false' );
$action  = $setting->getSetting( 'autoresponder_action' );
$nameon  = $setting->getSetting( 'autoresponder_name_activate', 'true' );
$fname   = $setting->getSetting( 'autoresponder_name' );
$femail  = $setting->getSetting( 'autoresponder_email' );
$lname   = stripslashes( $setting->getSetting( 'autoresponder_name_label', __( 'Your Name', IPVISC_SLUG  ) ));
$lemail  = stripslashes( $setting->getSetting( 'autoresponder_email_label', __( 'Your Email', IPVISC_SLUG  ) ));

$class  = 'ipvisc-autoresponder';
$class .= ' ipvisc-autoresponder-' . $videoPost->ID;
?>

<div class="<?php echo $class; ?>">
<div class="ipvisc-ui-modal" style="display:none;">
  <div class="ipvisc-popup-inner ipvisc-ui-modal-main">
    <div class="ipvisc-ui-close">
      <a class="ipvisc-ui-close-link" href="#">
        <i class="ipvisc-fa ipvisc-fa-times"></i>
      </a>
    </div>
    <div class="ipvisc-ui-modal-content">
      <div class="ipvisc-optin-form-content">

        <div class="ipvisc-form">

          <h3> <?php echo $setting->getSetting( 'responder_title', '' ); ?></h3>
          <div class="ipvisc-form-info">
            <?php echo $setting->getSetting( 'responder_info', '' ); ?>
          </div>

          <div class="ipvisc-autoresponder">
            <form class="ipvisc-form-main" method="post" action="<?php echo $action; ?>"  target="_blank">
              <div class="ipvisc-fields ipvisc-clear">
                <?php
                if ( $code = $setting->getSetting( 'autoresponder_code' ) )
                {
                  $data = IPVisc_Form::parse( $code );
                  if ( ! empty( $data['hiddens'] ))
                  {
                    foreach( $data['hiddens'] as $key => $value ) {
                      $value    = str_replace( '"', '', $value );
                      echo '<input type="hidden" name="' . $key . '" value="' . $value . '" />';
                    }
                  }
                }
                if ( $nameon == 'true' ) :
                  $placeholder = ' placeholder="' . $lname . '"';
                ?>
                <div class="ipvisc-field">
                  <?php
                  if ( $label == 'true' ):
                    $placeholder = '';
                  ?>
                  <div class="ipvisc-form-label">
                    <label for="ipvisc-input-name"><?php echo $lname; ?></label>
                  </div>
                  <?php
                  endif;
                  ?>
                  <div class="ipvisc-form-control">
                    <input type="text" id="ipvisc-input-name" name="<?php echo $fname; ?>" value=""<?php echo $placeholder; ?>>
                  </div>
                </div>
                <?php
                endif;
                ?>
                <div class="ipvisc-field">
                  <?php
                  $placeholder = ' placeholder="' . $lemail . '"';
                  if ( $label == 'true' ):
                    $placeholder = '';
                  ?>
                  <div class="ipvisc-form-label">
                    <label for="ipvisc-input-email"><?php echo $lemail; ?></label>
                  </div>
                  <?php
                  endif;
                  ?>
                  <div class="ipvisc-form-control">
                    <input type="text" id="ipvisc-input-email" name="<?php echo $femail; ?>" value=""<?php echo $placeholder; ?>>
                  </div>
                </div>
              </div>
              <?php
              $btnlabel = $setting->getSetting( 'autoresponder_button_text', __( 'Subscribe', IPVISC_SLUG ) );
              ?>
              <div class="ipvisc-form-button">
                <button type="submit" name="do_save_email" class="ipvisc-form-submit" data-id="<?php echo $videoPost->ID; ?>">
                  <?php echo stripslashes( $btnlabel ); ?>
                </button>
              </div>
            </form>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
</div>
