<?php
/**
 * Buttons shortcode view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$videoPost    = $this->videoPost;
$setting      = $this->setting;
$style        = $this->style;
$styleSetting = $this->styleSetting;

//
//Href
$class  = 'ipvisc-button-main';
$target = $setting->getSetting( 'button_target', 'url' );
if ( $target == 'url' ) {
  $href   = $setting->getSetting( 'button_link', '#' );
  $class .= ' ipvisc-button-url';
} else {
  $href   = '#';
  $class .= ' ipvisc-button-optin';
}
$class .= ' ipvisc-button-' . $setting->getSetting( 'button_size', 'md' );

$color    = $styleSetting->getSetting( 'color', 'grey' );
$newtab   = '';
$isNewtab = $setting->getSetting( 'button_new_tab', 'true' );
if ( $target == 'url' && $isNewtab == 'true' ) {
  $newtab = ' target="_blank"';
}
?>

<?php
if ( $color == 'custom' ) :
?>
  <style>
  .ipvisc-video-<?php echo $videoPost->ID; ?> .ipvisc-button a,
  .ipvisc-video-<?php echo $videoPost->ID; ?> .ipvisc-form-submit {
    background-color: <?php echo $styleSetting->getSetting( 'button_background_color', '#dddddd' ); ?>!important;
    color: <?php echo $styleSetting->getSetting( 'button_text_color', '#333333' ); ?>!important;
    border-color: <?php echo $styleSetting->getSetting( 'button_border_color', '#bbbbbb' ); ?>!important;
  }
  </style>
<?php
endif;
?>

<div class="ipvisc-button-wrapper ipvisc-color-<?php echo $color; ?>">
  <div class="ipvisc-button">
    <a href="<?php echo $href; ?>" class="<?php echo $class; ?>"<?php echo $newtab; ?>>
      <?php
      $icon = $setting->getSetting( 'button_icon' );
      if ( ! empty( $icon ) && $icon != 'none' ) {
        echo '<i class="ipvisc-fa ipvisc-fa-' . $icon . '"></i>';
      }
      ?>
      <span>
        <?php echo $setting->getSetting( 'button_text', __( 'Buy Now', IPVISC_SLUG ) ); ?>
      </span>
    </a>
  </div>
</div>
