<?php
/**
 * Countdown shortcode view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$videoPost = $this->videoPost;
$setting   = $this->setting;

if ( $setting->getSetting( 'countdown_activate', 'false' ) == 'false' ) {
  return true;
}

//
//Get time
$dtime = 0;
$date  =  $setting->getSetting( 'countdown_target_date' );
$time  =  $setting->getSetting( 'countdown_target_time' );
if ( $date && $time ) {
    $dtime = $date . ' ' . $time . ':00';
}
//
//Get format
$format = $setting->getSetting( 'countdown_format', 'y_m_d_h_mi_s' );

//
//Get font-family name
$ffname = $setting->getSetting( 'countdown_font_family', 'roboto' );
$ffont  = IPVisc_Font::getFontName( $ffname );

//
//Get style
$istyle  = ' style="';
//Font family
$istyle .= 'font-family:' . $ffont . ';';
//Color
$istyle .= 'color:' . $setting->getSetting( 'countdown_color', '#333333' ) . ';';
$istyle .= '"';

//
//Get main style
$mstyle  = ' style="';
//Background color
$mstyle .= 'background-color:' . $setting->getSetting( 'countdown_bgcolor', '#ffffff' ) . ';';
//Border
$bosize  = $setting->getSetting( 'countdown_border_width' );
$bocolor = $setting->getSetting( 'countdown_border_color', '#dddddd' );
if ( $bosize ) {
  $mstyle .= 'border:' . $bosize . 'px solid ' . $bocolor . ';';
}
$mstyle .= '"';

//
//Get main class
$mclass  = 'ipvisc-countdown-main';
$mclass .= ' ipvisc-radius-' . $setting->getSetting( $key . 'border_radius', 'none' );
?>
<div class="ipvisc-countdown">
  <div class="ipvisc-countdown-inner"<?php echo $istyle; ?>>
    <div class="<?php echo $mclass; ?>"<?php echo $mstyle; ?>>
      <div class="ipvisc-countdown-item ipvisc-clear" data-time="<?php echo $dtime; ?>" data-format="<?php echo $format; ?>"></div>
    </div>
  </div>
</div>
