<?php
/**
 * Main shortcode view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$videoPost    = $this->videoPost;
$setting      = $this->setting;
$styleSetting = $this->styleSetting;
$type         = $setting->getSetting( 'video_type' );

$this->view( 'shortcode/frontend/styleMain' );

//Container class
$class  = 'ipvisc ipvisc-container';
$class .= ' ipvisc-video-' . $videoPost->ID;
$class .= ' ipvisc-font-' . $setting->getSetting( 'font_size', 'md' );
$class .= ' ipvisc-radius-' . $setting->getSetting( 'border_radius', 'none' );
$class .= ' ipvisc-color-' . $styleSetting->getSetting( 'color', 'grey' );
if ( $setting->getSetting( 'shadow', 'false' ) == 'true' ) {
  $class .= ' ipvisc-shadow-on';
} else {
  $class .= ' ipvisc-shadow-off';
}

$data  = '';
$data .= ' data-id="' . $videoPost->ID . '"';
$data .= ' data-type="' . $type . '"';
$data .= ' data-play="' . $styleSetting->getSetting( 'video_play', 'continue' ) . '"';
?>

<div class="<?php echo $class; ?>"<?php echo $data; ?>>
  <div class="ipvisc-inner">
    <div class="ipvisc-body">
      <?php
      $title = stripslashes( $setting->getSetting( 'content_title' ) );
      $info  = stripslashes( $setting->getSetting( 'content_info' ) );

      if ( ! empty( $title ) || ! empty( $info )) :
      ?>
      <div class="ipvisc-content">
        <?php
        if ( ! empty( $title )) :
        ?>
        <h3 class="ipvisc-title"><?php echo $title; ?></h3>
        <?php
        endif;

        if ( ! empty( $info )) :
        ?>
        <div class="ipvisc-info">
          <?php echo $info; ?>
        </div>
        <?php
        endif;
        ?>
      </div>
      <?php
      endif;

      $videoHeight = $setting->getSetting( 'video_height', 320 );
      ?>

      <div class="ipvisc-video" style="height:<?php echo $videoHeight; ?>px;">
        <?php
        if ( $type == 'upload' ) {
          $this->view( 'shortcode/frontend/videoMedia' );
        }
        else {
          $this->view( 'shortcode/frontend/videoYoutube' );
        }
        ?>
      </div>

      <?php
      //
      //Countdown
      $this->view( 'shortcode/frontend/countdown' );
      //
      //Button
      $this->view( 'shortcode/frontend/button' );
      ?>
    </div>
    <?php
    //
    //Share
    $this->view( 'shortcode/frontend/share' );
    ?>
  </div>
  <?php
  //
  //Autoresponder
  $this->view( 'shortcode/frontend/autoresponder' );
  //
  //Widget
  $this->view( 'shortcode/frontend/widget' );
  ?>
</div>
