<?php
/**
 * Share buttons shortcode view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$videoPost = $this->videoPost;
$setting   = $this->setting;

if ( $setting->getSetting( 'share_activate', 'false' ) == 'false' ) {
  return true;
}
?>
<div class="ipvisc-share">
  <div class="ipvisc-share-inner">
    <h3><?php _e( 'Share', IPVISC_SLUG ); ?></h3>
    <div class="ipvisc-share-main">
      <ul class="ipvisc-share-buttons">
        <?php
        $socials  = array(
          'facebook',
          'twitter',
          'google-plus',
          'pinterest',
          'linkedin',
          'tumblr',
          'stumbleupon',
          'digg',
          'email'
        );
        $style = $setting->getSetting( 'share_button_style', 'square_flat' );
        $root  = IPVISC_BASE_URL . 'assets/img/icon/' . $style . '/';
        foreach( $socials as $social )
        {
          if ( $setting->getSetting( 'share_' . $social, 'on' ) == 'on' )
          {
            $icon = $root . $social . '.png';
            $link = $this->getShareLink( $social );

            echo    '<li class="ipvisc-share-button ipvisc-share-' . $social . '">' .
                      '<a href="' . $link . '" class="ipvisc-share-link">' .
                        '<img src="' . $icon . '" alt="' . $social . '">' .
                      '</a>'.
                    '</li>';
          }
        }
        ?>
      </ul>
    </div>
  </div>
</div>
