<?php
/**
 * Main style view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$videoPost    = $this->videoPost;
$setting      = $this->setting;
$styleSetting = $this->styleSetting;

//
//Google font
$families   = array();
$families[] = $setting->getSetting( 'font_family', 'roboto' );
$families[] = $setting->getSetting( 'countdown_font_family', 'roboto' );
$families[] = $styleSetting->getSetting( 'font_family', 'roboto' );

$families = array_unique( $families );
$fams = array();
foreach( $families as $famname ) {
    $fams[] = $this->getGoogleFontFamily( $famname );
}
$family   = implode( '|', $fams );
$fontUrl  = 'http://fonts.googleapis.com/css?family=' . $family;
echo '<link id="ipvisc-font" href="' . $fontUrl . '" rel="stylesheet" type="text/css">';
?>

<style>
.ipvisc-video-<?php echo $videoPost->ID; ?> {
  <?php
  //
  //Font
  $fontName = $this->setting->getSetting( 'font_family', 'roboto' );
  $family   = IPVisc_Font::getFamily( $fontName );
  echo 'font-family:' . $family . ';';
  ?>
}
.ipvisc-video-<?php echo $videoPost->ID; ?> .ipvisc-body {
  background-color: <?php echo $setting->getSetting( 'background_color', '#ffffff' ); ?>;
  color: <?php echo $setting->getSetting( 'text_color', '#333333' ); ?>;
  text-align: <?php echo $setting->getSetting( 'text_align', 'center' ); ?>;
  <?php
  //
  //Padding
  if ( $padding = $setting->getSetting( 'padding' ) ) {
    echo 'padding:' . $padding . 'px;';
  }
  //
  //Border
  if ( $bowidth = $setting->getSetting( 'border_width') ) {
    $bocolor = $setting->getSetting( 'border_color', '#cccccc' );
    echo 'border:' . $bowidth . 'px solid ' . $bocolor . ';';
  }
  ?>
}
</style>
