<?php
/**
 * Video internal view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

function ipvisc_videoShortcodeClass( $class ) { return 'ipvisc-video-upload-player'; }
add_filter( 'wp_video_shortcode_class', 'ipvisc_videoShortcodeClass' );

$videoPost = $this->videoPost;
$setting   = $this->setting;
$videoId   = $setting->getSetting( 'video_file' );
$poster    = 0;

if ( $imageId = $setting->getSetting( 'video_poster' ) ){
  $data   = wp_get_attachment_image_src( $imageId, 'full' );
  $poster = $data[0];
}
$auto = $setting->getSetting( 'video_autoplay', 'false' );
if ( $auto == 'true' ) {
  $autoplay = true;
} else {
  $autoplay = false;
}
$videoAtts = wp_prepare_attachment_for_js( $videoId );
$videoPath = get_attached_file( $videoId );

$width  = $setting->getSetting( 'video_width', 450 );
$height = $setting->getSetting( 'video_height', 320 );

$scAtts = array(
  'src'       => $videoAtts['url'],
  'poster'    => $poster,
  'autoplay'  => $autoplay,
  'height'    => $height,
  'width'     => $width
);
echo wp_video_shortcode( $scAtts );
?>
