<?php
/**
 * Video youtube view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$videoPost    = $this->videoPost;
$setting      = $this->setting;
$styleSetting = $this->styleSetting;

//
//Get video url
$url           = $setting->getSetting( 'youtube_url', '#' );
$videoKey      = $this->getVideoId( $url );
$videoId       = 'ipvisc-video-' . $this->videoCode;
$videoWidgetId = 'ipvisc-widget-video-' . $this->videoCode;
?>
<div class="ipvisc-video-youtube">
  <div id="<?php echo $videoId; ?>" class="ipvisc-video-youtube-edge">
  </div>
</div>
<script>
  // 2. This code loads the IFrame Player API code asynchronously.
  var tag = document.createElement('script');
  tag.src = "https://www.youtube.com/iframe_api";
  var firstScriptTag = document.getElementsByTagName('script')[0];
  firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

  // 3. This function creates an <iframe> (and YouTube player)
  //    after the API code downloads.
  var ipvisc_videoId = '<?php echo $this->videoPost->ID; ?>';
  var ipvisc_player;
  var ipvisc_playerOn = false;
  var ipvisc_playerWidget;
  var ipvisc_playerWidgetOn = false;
  <?php
  $auto = $setting->getSetting( 'video_autoplay', 'false' );
  if ( $auto == 'false' ) {
    echo 'var player_autoplay = false;';
  } else {
    echo 'var player_autoplay = true;';
  }
  ?>
  function onYouTubeIframeAPIReady() {
    <?php
    //Video main
    $width   = $setting->getSetting( 'video_width', 450 );
    $height  = $setting->getSetting( 'video_height', 320 );
    ?>
    ipvisc_player = new YT.Player('<?php echo $videoId; ?>', {
      height: <?php echo $height; ?>,
      width: <?php echo $width; ?>,
      videoId: '<?php echo $videoKey; ?>',
      events: {
        'onReady': onPlayerReady,
        'onStateChange': onPlayerStateChange
      }
    });
    <?php
    //Video widget
    $width   = $styleSetting->getSetting( 'width', 320 );
    $padding = $styleSetting->getSetting( 'padding', 0 );
    $vheight = $styleSetting->getSetting( 'video_height', 260 );
    $vwidth  = $width - ($padding*2);
    ?>
    ipvisc_playerWidget = new YT.Player('<?php echo $videoWidgetId; ?>', {
      height: <?php echo $vheight; ?>,
      width: <?php echo $vwidth; ?>,
      videoId: '<?php echo $videoKey; ?>',
      events: {
        'onReady': onWidgetPlayerReady,
        'onStateChange': onWidgetPlayerStateChange
      }
    });
  }

  // 4. The API will call this function when the video player is ready.
  function onPlayerReady(event) {
    if ( player_autoplay ) {
      event.target.playVideo();
      ipvisc_playerOn = true;
    }
  }
  function onWidgetPlayerReady(event) {
    event.target.stopVideo();
  }

  //5.The API calls this function when the player's state changes.
  function onPlayerStateChange(event) {
    if (event.data == YT.PlayerState.PLAYING && ! ipvisc_playerOn ) {
      ipvisc_playerOn = true;
      if ( ! ipvisc_playerWidgetOn ) {
        ipvisc_saveStateVideoYoutube();
      }
    }
  }
  function onWidgetPlayerStateChange(event) {
    if (event.data == YT.PlayerState.PLAYING && ! ipvisc_playerWidgetOn ) {
      ipvisc_playerWidgetOn = true;
      if ( ! ipvisc_playerOn ) {
        ipvisc_saveStateVideoYoutube();
      }
    }
  }

  function ipvisc_saveStateVideoYoutube()
  {
    jQuery.ajax({
      url: ipvisc_ajaxurl+'?doajax=1&ipvisc=1&action=savestat',
      type: "POST",
      data: 'video_id='+ipvisc_videoId+'&type=play',
      dataType: "json",
      success: function ( result ) {}
    });
  }
</script>
