<?php
/**
 * Widgets view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$videoPost    = $this->videoPost;
$videoSetting = $this->setting;
$style        = $this->style;
$setting      = $this->styleSetting;
$color        = $setting->getSetting( 'color', 'grey' );

//
//Style
$this->view( 'shortcode/frontend/widget/style' );

//Class
$class  = 'ipvisc-video-widget ipvisc-close';
$class .= ' ipvisc-video-widget-' . $videoPost->ID;
$class .= ' ipvisc-font-' . $setting->getSetting( 'font_size', 'md' );
$class .= ' ipvisc-radius-' . $setting->getSetting( 'border_radius', 'none' );
$class .= ' ipvisc-color-' . $color;
$class .= ' ipvisc-video-widget-' . $setting->getSetting( 'position', 'bottom_left' );
$class .= ' ipvisc-template-' . $setting->getSetting( 'template', 'default' );

$data   = '';
$data  .= ' data-show_effect="' . $setting->getSetting( 'show_effect', 'none' ) . '"';
$data  .= ' data-show_speed="' . $setting->getSetting( 'show_speed', 500 ) . '"';
$data  .= ' data-hide_effect="' . $setting->getSetting( 'hide_effect', 'none' ) . '"';
$data  .= ' data-hide_speed="' . $setting->getSetting( 'hide_speed', 500 ) . '"';
?>
<div class="<?php echo $class; ?>"<?php echo $data; ?>>
  <div class="ipvisc-video-widget-inner">
    <?php
    //
    //Header
    $this->view( 'shortcode/frontend/widget/header' );
    ?>
    <div class="ipvisc-video-widget-body">
      <div class="ipvisc-video-widget-main">
        <div class="ipvisc-video">
          <?php
          $type = $videoSetting->getSetting( 'video_type' );

          if ( $type == 'upload' ) {
            $this->view( 'shortcode/frontend/widget/videoMedia' );
          }
          else {
            $this->view( 'shortcode/frontend/widget/videoYoutube' );
          }
          ?>
        </div>
        <?php
        $this->view( 'shortcode/frontend/widget/share' );
        ?>
      </div>
      <?php
      if ( $setting->getSetting( 'display_button', 'true' ) == 'true' ) {
        $this->view( 'shortcode/frontend/button' );
      }
      ?>
    </div>
  </div>

  <?php
  //
  //Show Audio
  $showAudio = $setting->getSetting( 'show_audio', 0 );
  if ( ! empty( $showAudio ) ) :
    $path = IPVISC_BASE_URL . 'assets/audio/audio-' . $showAudio;
  ?>
  <audio class="ipvisc-audio ipvisc-audio-show" style="display:none;">
    <source src="<?php echo $path; ?>.mp3" type="audio/mpeg">
    <source src="<?php echo $path; ?>.ogg" type="audio/ogg">
    <?php _e( 'Your browser does not support this audio format.', IPVISC_SLUG ); ?>
  </audio>
  <?php
  endif;

  //
  //Hide Audio
  $hideAudio = $setting->getSetting( 'hide_audio', 0 );
  if ( ! empty( $hideAudio ) ) :
    $path = IPVISC_BASE_URL . 'assets/audio/audio-' . $hideAudio;
  ?>
  <audio class="ipvisc-audio ipvisc-audio-hide" style="display:none;">
    <source src="<?php echo $path; ?>.mp3" type="audio/mpeg">
    <source src="<?php echo $path; ?>.ogg" type="audio/ogg">
    <?php _e( 'Your browser does not support this audio format.', IPVISC_SLUG ); ?>
  </audio>
  <?php
  endif;
  ?>
</div>
