<?php
/**
 * Widget style
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$videoPost    = $this->videoPost;
$videoSetting = $this->setting;
$style        = $this->style;
$setting      = $this->styleSetting;
$color        = $setting->getSetting( 'color', 'grey' );
?>
<style>
  .ipvisc-video-widget-<?php echo $videoPost->ID; ?> {
    width: <?php echo $setting->getSetting( 'width', 320 ); ?>px;
    <?php
    //
    //Font
    $fontName = $setting->getSetting( 'font_family', 'roboto' );
    $family   = IPVisc_Font::getFamily( $fontName );
    echo 'font-family:' . $family . ';';

    //
    //Border
    if ( $bowidth = $setting->getSetting( 'border_width' )) {
      echo 'border-style:solid;';
      echo 'border-width:' . $bowidth . 'px;';
    }

    //
    //Css color custom
    if ( $color == 'custom' )
    {
      $bgcolor = $setting->getSetting( 'background_color', '#dddddd' );
      $bocolor = $setting->getSetting( 'border_color', '#bbbbbb' );
      $bocolor = $setting->getSetting( 'text_color', '#333333' );

      echo 'background-color:' . $bgcolor . ';';
      echo 'border-color:' . $bocolor . ';';
      echo 'color:' . $color . ';';
    }

    //
    //Margin left
    $position = $setting->getSetting( 'position', 'bottom_right' );
    if ( $position == 'bottom_center' || $position == 'top_center' )
    {
      $width      = $setting->getSetting( 'width', 320 );
      $marginLeft = $width/2;
      echo 'margin-left: -' . $marginLeft . 'px;';
    }
    ?>
  }

  <?php
  $bgImage = $setting->getSetting( 'background_image' );
  if ( ! empty( $bgImage )) :
    $data   = wp_get_attachment_image_src( $bgImage, 'full' );
    $src    = $data[0];
    $repeat = $setting->getSetting( 'background_repeat', 'repeat' );
  ?>
  .ipvisc-video-widget-<?php echo $videoPost->ID; ?> .ipvisc-video-widget-main {
    background-image: url('<?php echo $src; ?>');
    background-repeat: <?php echo $repeat; ?>;
  }
  <?php
  endif;
  ?>

  .ipvisc-video-widget-<?php echo $videoPost->ID; ?> .ipvisc-video-widget-main {
    padding:<?php echo $setting->getSetting( 'padding', 0 ); ?>px;
  }

  <?php
  //Header
  $headerHeight = $setting->getSetting( 'header_height', 40 );
  ?>
  .ipvisc-video-widget-<?php echo $videoPost->ID; ?> .ipvisc-video-widget-header {
    height:<?php echo $headerHeight; ?>px;
    line-height:<?php echo $headerHeight; ?>px;
  }
  .ipvisc-video-widget-<?php echo $videoPost->ID; ?> .ipvisc-video-widget-actions {
    height:<?php echo $headerHeight; ?>px;
    line-height:<?php echo $headerHeight; ?>px;
  }

  <?php
  if ( $color == 'custom' ) :
  ?>
  .ipvisc-video-widget-<?php echo $videoPost->ID; ?> .ipvisc-video-widget-header {
    background-color:<?php echo $setting->getSetting( 'header_background_color', '#666666' ); ?>;
    color:<?php echo $setting->getSetting( 'header_text_color', '#ffffff' ); ?>;
  }
  .ipvisc-video-widget-<?php echo $videoPost->ID; ?> .ipvisc-video-widget-actions a {
    color:<?php echo $setting->getSetting( 'header_text_color', '#ffffff' ); ?>;
  }
  <?php
  endif;
  ?>
</style>
