<?php
/**
 * Admin content effect view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipvisc-section-effect" class="ipvisc-tab-content">
  <div class="ipvisc-tab-inner">

    <div class="ipvisc-title-content ipvisc-hide">
      <i class="ipvisc-fa ipvisc-fa-magic"></i>
      <div class="ipvisc-title-text">
        <h3><?php _e( 'Effect', IPVISC_SLUG ); ?></h3>
        <p><?php _e( 'Set the effect when the widget to appear/hide.', IPVISC_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipvisc-fields -->
    <div class="ipvisc-fields">

      <?php
      //Show Effect
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-md-3 col-sm-12">
          <label for="input-show-effect"><?php _e( 'Show Animation', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-md-9 col-sm-12">

          <select name="show_effect" id="input-show-effect">
            <?php
            $current = $this->setting->getSetting( 'show_effect', 'none' );
            $effects = array(
              'none'      => __( 'None', IPVISC_SLUG ),
              'linear'    => __( 'Linear', IPVISC_SLUG ),
              'bounce'    => __( 'Bounce', IPVISC_SLUG ),
              'back'      => __( 'Back', IPVISC_SLUG ),
              'elastic'   => __( 'Elastic', IPVISC_SLUG ),
              'expo'      => __( 'Expo', IPVISC_SLUG )
            );
            foreach( $effects as $key => $label )
            {
              $sltd = '';
              if ( $current == $key ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The type of effect that is executed when the widget is displayed.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Show effect speed
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-show-effect-speed"><?php _e( 'Show Animation Speed', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $speed = $this->setting->getSetting( 'show_effect_speed', 500 );
          ?>
          <div class="ipvisc-input-group mr5">
              <input type="text" id="input-show-effect-speed" class="ipvisc-input ipvisc-input-xs" name="show_effect_speed" value="<?php echo $speed; ?>">
              <div class="ipvisc-input-addon">second</div>
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The speed (in second) of effect that is executed when the widget is displayed.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Hide Effect
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-md-3 col-sm-12">
          <label for="input-hide-effect"><?php _e( 'Hide Animation', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-md-9 col-sm-12">

          <select name="hide_effect" id="input-hide-effect">
            <?php
            $current = $this->setting->getSetting( 'hide_effect', 'none' );
            $effects = array(
              'none'      => __( 'None', IPVISC_SLUG ),
              'linear'    => __( 'Linear', IPVISC_SLUG ),
              'bounce'    => __( 'Bounce', IPVISC_SLUG ),
              'back'      => __( 'Back', IPVISC_SLUG ),
              'elastic'   => __( 'Elastic', IPVISC_SLUG ),
              'expo'      => __( 'Expo', IPVISC_SLUG )
            );
            foreach( $effects as $key => $label )
            {
              $sltd = '';
              if ( $current == $key ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The type of effect that is executed when the widget is hidden.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Hide effect speed
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-hide-effect-speed"><?php _e( 'Hide Animation Speed', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $speed = $this->setting->getSetting( 'hide_effect_speed', 500 );
          ?>
          <div class="ipvisc-input-group mr5">
              <input type="text" id="input-hide-effect-speed" class="ipvisc-input ipvisc-input-xs" name="hide_effect_speed" value="<?php echo $speed; ?>">
              <div class="ipvisc-input-addon">second</div>
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The speed (in second) of effect that is executed when the widget is hidden.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Show Audio
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-md-3 col-sm-12">
          <label for="input-show-audio"><?php _e( 'Show Audio', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-md-9 col-sm-12">

          <select id="input-show-audio" class="ipvisc-input" name="show_audio">
            <option value="0"> <?php _e( 'No Audio', IPVISC_SLUG );  ?> </option>
            <?php
            $audio   = absint( $this->setting->getSetting( 'content_audio', 0 ) );
            $options = range(1,5);
            foreach( $options as $key ) {
              $sltd = '';
              if ( $key == $audio ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>Audio #' . $key . '</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The sound effect when the widget is displayed.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Hide Audio
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-md-3 col-sm-12">
          <label for="input-hide-audio"><?php _e( 'Hide Audio', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-md-9 col-sm-12">

          <select id="input-hide-audio" class="ipvisc-input" name="hide_audio">
            <option value="0"> <?php _e( 'No Audio', IPVISC_SLUG );  ?> </option>
            <?php
            $audio   = absint( $this->setting->getSetting( 'hide_audio', 0 ) );
            $options = range(1,5);
            foreach( $options as $key ) {
              $sltd = '';
              if ( $key == $audio ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>Audio #' . $key . '</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The sound effect when the widget is hidden.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

    </div>
    <!-- end: .ipvisc-fields -->

  </div>
</div>
