<?php
/**
 * Admin content general view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipvisc-section-general" class="ipvisc-tab-content">
  <div class="ipvisc-tab-inner">

    <div class="ipvisc-title-content ipvisc-hide">
      <i class="ipvisc-fa ipvisc-fa-cogs"></i>
      <div class="ipvisc-title-text">
        <h3><?php _e( 'General', IPVISC_SLUG ); ?></h3>
        <p><?php _e( 'Basic settings and info of your widget', IPVISC_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipvisc-fields -->
    <div class="ipvisc-fields">

      <?php
      /*
       * Title
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-title"><?php _e( 'Widget Title', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $title = '';
          if ( $this->style ) {
            $title = stripslashes( $this->style->post_title );
          }
          ?>
          <input type="text" id="input-title" class="ipvisc-input ipvisc-input-full ipvisc-input-v-lg" name="title" value="<?php echo $title; ?>">

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'The title of the widget. This data will not be used directly in creating widget, only to mark the widget, so it easier for you to manage it.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Position
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-position"><?php _e( 'Position', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select id="input-position" name="position">
            <?php
            $position  = $this->setting->getSetting( 'position', 'bottom_left' );
            $positions = array(
              'bottom_left'      => __( 'Bottom Left', IPVISC_SLUG ),
              'bottom_right'     => __( 'Bottom Right', IPVISC_SLUG ),
              'bottom_center'    => __( 'Bottom Center', IPVISC_SLUG ),
              'top_left'         => __( 'Top Left', IPVISC_SLUG ),
              'top_right'        => __( 'Top Right', IPVISC_SLUG ),
              'top_center'       => __( 'Top Center', IPVISC_SLUG )
            );
            foreach( $positions as $id => $label )
            {
                $sltd = '';
                if ( $id == $position ) {
                    $sltd = ' selected="selected"';
                }
                echo '<option value="' . $id . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'Set the position of the widget in your page.', IPVISC_SLUG ); ?>
            </div>
          </div>

        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Template
       *
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-template"><?php _e( 'Template', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select id="input-template" name="template">
            <?php
            $template  = $this->setting->getSetting( 'template', 'default' );
            $templates = array(
              'default'      => __( 'Default', IPVISC_SLUG ),
              'classic'      => __( 'Classic', IPVISC_SLUG ),
              'modern'       => __( 'Modern', IPVISC_SLUG ),
              'flat'         => __( 'Flat', IPVISC_SLUG ),
              'simple'       => __( 'Simple', IPVISC_SLUG ),
            );
            foreach( $templates as $id => $label )
            {
                $sltd = '';
                if ( $id == $template ) {
                    $sltd = ' selected="selected"';
                }
                echo '<option value="' . $id . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'Set the template of the widget.', IPVISC_SLUG ); ?>
            </div>
          </div>

        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->
      */
      ?>

      <?php
      /*
       * Video play
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-video-play"><?php _e( 'Widget Video Play Method', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select id="input-video-play" name="video_play">
            <?php
            $method  = $this->setting->getSetting( 'video_play', 'continue' );
            $methods = array(
              'continue'  => __( 'Continue', IPVISC_SLUG ),
              'restart'   => __( 'Restart', IPVISC_SLUG ),
              'stop'      => __( 'Stop', IPVISC_SLUG )
            );
            foreach( $methods as $id => $label )
            {
                $sltd = '';
                if ( $id == $method ) {
                    $sltd = ' selected="selected"';
                }
                echo '<option value="' . $id . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'Determine how the video is played when the widget to appear.', IPVISC_SLUG ); ?>
            </div>
          </div>

        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

    </div>
    <!-- end: .ipvisc-fields -->

  </div>
</div>
