<?php
/**
 * Admin content style view
 *
 * @package wp-video-attention
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipvisc-section-style" class="ipvisc-tab-content">
  <div class="ipvisc-tab-inner">

    <div class="ipvisc-title-content ipvisc-hide">
      <i class="ipvisc-fa ipvisc-fa-paint-brush"></i>
      <div class="ipvisc-title-text">
        <h3><?php _e( 'Style', IPVISC_SLUG ); ?></h3>
        <p><?php _e( 'Set look and feel of the widget', IPVISC_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipvisc-fields -->
    <div class="ipvisc-fields">

      <?php
      /*
       * Color
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-color"><?php _e( 'Color', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select id="ipvisc-input-style-color" name="color">
            <?php
            $color  = $this->setting->getSetting( 'color', 'grey' );
            $colors = array(
              'grey'        => __( 'Grey', IPVISC_SLUG ),
              'red'         => __( 'Red', IPVISC_SLUG ),
              'orange'      => __( 'Orange', IPVISC_SLUG ),
              'blue'        => __( 'Blue', IPVISC_SLUG ),
              'light_blue'  => __( 'Light Blue', IPVISC_SLUG ),
              'green'       => __( 'Green', IPVISC_SLUG ),
              'custom'      => __( 'Custom', IPVISC_SLUG ),
            );
            foreach( $colors as $id => $label )
            {
                $sltd = '';
                if ( $id == $color ) {
                    $sltd = ' selected="selected"';
                }
                echo '<option value="' . $id . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide"><?php _e( 'Set the display color of the widget.', IPVISC_SLUG ); ?>
            </div>
          </div>

        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      $cstmDsp = ' style="display:none;"';
      if ( $color == 'custom' ) {
        $cstmDsp = '';
      }
      ?>
      <div id="ipvisc-color-custom-fields"<?php echo $cstmDsp; ?>>
        <h3 class="ipvisc-field-title py10"><?php _e( 'Custom Color', IPVISC_SLUG ); ?></h3>

        <?php
        /*
         * Background Color
         */
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-background-color"><?php _e( 'Background Color', IPVISC_SLUG ); ?></label>
          </div>

          <!-- start: .ipvisc-field -->
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

            <?php
            $color = stripslashes( $this->setting->getSetting( 'background_color', '#dddddd' ) );
            ?>
            <input type="text" class="ipvisc-color-picker" id="input-background-color" name="background_color" value="<?php echo $color; ?>" />

            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide">
                <?php _e( 'Add background color for the widget.', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field -->
        </div>
        <!-- end: .ipvisc-field-row -->

        <?php
        /*
         * Border Color
         */
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-border-color"><?php _e( 'Border Color', IPVISC_SLUG ); ?></label>
          </div>

          <!-- start: .ipvisc-field -->
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

            <?php
            $color = stripslashes( $this->setting->getSetting( 'border_color', '#bbbbbb' ) );
            ?>
            <input type="text" class="ipvisc-color-picker" id="input-border-color" name="border_color" value="<?php echo $color; ?>" />

            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide">
                <?php _e( 'Add border color for the widget.', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field -->
        </div>
        <!-- end: .ipvisc-field-row -->

        <?php
        /*
         * Text Color
         */
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-text-color"><?php _e( 'Text Color', IPVISC_SLUG ); ?></label>
          </div>

          <!-- start: .ipvisc-field -->
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

            <?php
            $color = stripslashes( $this->setting->getSetting( 'text_color', '#333333' ) );
            ?>
            <input type="text" class="ipvisc-color-picker" id="input-text-color" name="text_color" value="<?php echo $color; ?>" />

            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide">
                <?php _e( 'Add text color for the widget content.', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field -->
        </div>
        <!-- end: .ipvisc-field-row -->

        <?php
        /*
         * Header Background Color
         */
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-header-background-color">
              <?php _e( 'Header Background Color', IPVISC_SLUG ); ?>
            </label>
          </div>

          <!-- start: .ipvisc-field -->
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

            <?php
            $color = stripslashes( $this->setting->getSetting( 'header_background_color', '#666666' ) );
            ?>
            <input type="text" class="ipvisc-color-picker" id="input-header-background-color" name="header_background_color" value="<?php echo $color; ?>" />

            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide">
                <?php _e( 'Add background color for the header area.', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field -->
        </div>
        <!-- end: .ipvisc-field-row -->

        <?php
        /*
         * Header Text Color
         */
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-header-text-color">
              <?php _e( 'Header Text Color', IPVISC_SLUG ); ?>
            </label>
          </div>

          <!-- start: .ipvisc-field -->
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

            <?php
            $color = stripslashes( $this->setting->getSetting( 'header_text_color', '#ffffff' ) );
            ?>
            <input type="text" class="ipvisc-color-picker" id="input-header-text-color" name="header_text_color" value="<?php echo $color; ?>" />

            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide">
                <?php _e( 'Add text color for the header area.', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field -->
        </div>
        <!-- end: .ipvisc-field-row -->

        <?php
        /*
         * Button Background Color
         */
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-button-background-color">
              <?php _e( 'Button Background Color', IPVISC_SLUG ); ?>
            </label>
          </div>

          <!-- start: .ipvisc-field -->
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

            <?php
            $color = stripslashes( $this->setting->getSetting( 'button_background_color', '#666666' ) );
            ?>
            <input type="text" class="ipvisc-color-picker" id="input-button-background-color" name="button_background_color" value="<?php echo $color; ?>" />

            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide">
                <?php _e( 'Add background color for the button widget.', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field -->
        </div>
        <!-- end: .ipvisc-field-row -->

        <?php
        /*
         * Button border Color
         */
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-header-text-color">
              <?php _e( 'Button Border Color', IPVISC_SLUG ); ?>
            </label>
          </div>

          <!-- start: .ipvisc-field -->
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

            <?php
            $color = stripslashes( $this->setting->getSetting( 'button_border_color', '#444444' ) );
            ?>
            <input type="text" class="ipvisc-color-picker" id="input-button-border-color" name="button_border_color" value="<?php echo $color; ?>" />

            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide">
                <?php _e( 'Add border color for the button widget.', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field -->
        </div>
        <!-- end: .ipvisc-field-row -->

        <?php
        /*
         * Button Text Color
         */
        ?>
        <!-- start: .ipvisc-field-row -->
        <div class="ipvisc-field-row ipvisc-field-x">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-button-text-color">
              <?php _e( 'Button Text Color', IPVISC_SLUG ); ?>
            </label>
          </div>

          <!-- start: .ipvisc-field -->
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

            <?php
            $color = stripslashes( $this->setting->getSetting( 'button_text_color', '#ffffff' ) );
            ?>
            <input type="text" class="ipvisc-color-picker" id="input-button-text-color" name="button_text_color" value="<?php echo $color; ?>" />

            <div class="ipvisc-help">
              <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
              <div class="ipvisc-help-content ipvisc-hide">
                <?php _e( 'Add text color for the button widget.', IPVISC_SLUG ); ?>
              </div>
            </div>
          </div>
          <!-- end: .ipvisc-field -->
        </div>
        <!-- end: .ipvisc-field-row -->

      </div>

      <?php
      /*
       * Width
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-width"><?php _e( 'Widget Width', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $width = $this->setting->getSetting( 'width', 320 );
          ?>
          <div class="ipvisc-input-group mr5">
              <input type="text" id="input-width" class="ipvisc-input ipvisc-input-xs" name="width" value="<?php echo $width; ?>">
              <div class="ipvisc-input-addon">px</div>
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Width ( in pixel ) of the video.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Border
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-border"><?php _e( 'Border', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $bowidth = $this->setting->getSetting( 'border_width', 0 );
          ?>
          <div class="ipvisc-input-group mr5">
            <input type="text" id="input-border-width" class="ipvisc-input ipvisc-input-xxs" name="border_width" value="<?php echo $bowidth; ?>">
            <div class="ipvisc-input-addon">px</div>
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Set border in arround the video.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Border radius
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-border-radius"><?php _e( 'Border Radius', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select name="border_radius" id="input-border-radius">
            <?php
            $current = stripslashes( $this->setting->getSetting( 'border_radius', 'none' ));
            $styles  = array(
              'none' => __( 'None', IPVISC_SLUG ),
              'sm'   => __( 'Small', IPVISC_SLUG ),
              'md'   => __( 'Medium', IPVISC_SLUG ),
              'lg'   => __( 'Large', IPVISC_SLUG )
            );
            foreach( $styles as $key => $label ) {
              $sltd = '';
              if ( $key == $current ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd .'>'. $label .'</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The border radius of the video.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Font Family
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-font-family"><?php _e( 'Font Family', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $current = $this->setting->getSetting( 'font_family', 'roboto' );
          $fonts   = IPVisc_Font::getOptions();
          $fname   = IPVisc_Font::getFontName( $current );
          ?>
          <span class="ipvisc-font-family">
            <div class="ipvisc-menu ipvisc-fancy-option">
              <div class="ipvisc-selected">
                <div class="ipvisc-selected-box">
                  <span data-select="<?php echo $current; ?>"><?php echo $fname; ?></span>
                </div>
                <span class="toggle"></span>
              </div>
              <div class="ipvisc-select" style="display: none;">
                <div class="ipvisc-select-content">
                  <ul class="clearfix">
                    <?php
                    foreach( $fonts as $fkey => $label ) :
                    ?>
                    <li data-select="<?php echo $fkey; ?>">
                      <strong class="ipvisc-select-label">
                        <?php echo $label; ?>
                      </strong>
                    </li>
                    <?php
                    endforeach;
                    ?>
                  </ul>
                </div>
              </div>
              <input type="hidden" name="font_family" class="ipvisc-input-select" value="<?php echo $current; ?>" />
            </div>
          </span>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The font family of the widget content.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Font size
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-font-size"><?php _e( 'Font Size', IPVISC_SLUG ); ?></label>
        </div>
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <select name="font_size" id="input-font-size">
            <?php
            $current = stripslashes( $this->setting->getSetting( 'font_size', 'sm' ));
            $sizes   = array(
              'sm'   => __( 'Small', IPVISC_SLUG ),
              'md'   => __( 'Medium', IPVISC_SLUG ),
              'lg'   => __( 'Large', IPVISC_SLUG )
            );
            foreach( $sizes as $key => $label ) {
              $sltd = '';
              if ( $key == $current ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd .'>'. $label .'</option>';
            }
            ?>
          </select>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'The font size of the widget content.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Header height
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-header-height"><?php _e( 'Header Height', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $height = $this->setting->getSetting( 'header_height', 40 );
          ?>
          <div class="ipvisc-input-group mr5">
              <input type="text" id="input-header-height" class="ipvisc-input ipvisc-input-xs" name="header_height" value="<?php echo $height; ?>">
              <div class="ipvisc-input-addon">px</div>
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Width ( in pixel ) of the video.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <h3 class="ipvisc-field-title py10"><?php _e( 'Video Section', IPVISC_SLUG ); ?></h3>

      <?php
      /*
       * Height
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-video-height"><?php _e( 'Height', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $height = $this->setting->getSetting( 'video_height', 260 );
          ?>
          <div class="ipvisc-input-group mr5">
              <input type="text" id="input-video-height" class="ipvisc-input ipvisc-input-xs" name="video_height" value="<?php echo $height; ?>">
              <div class="ipvisc-input-addon">px</div>
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Height ( in pixel ) of the video.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Padding
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-padding"><?php _e( 'Padding', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $padding = $this->setting->getSetting( 'padding', 0 );
          ?>
          <div class="ipvisc-input-group mr5">
              <input type="text" id="input-padding" class="ipvisc-input ipvisc-input-xs" name="padding" value="<?php echo $padding; ?>">
              <div class="ipvisc-input-addon">px</div>
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Space arround the video.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      /*
       * Background Image
       */
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x ipvisc-help-abs">
        <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-background-image"><?php _e( 'Background Image', IPVISC_SLUG ); ?></label>
        </div>

        <!-- start: .ipvisc-field -->
        <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

          <div class="ipvisc-upload-image ipvisc-clear">
              <div class="ipvisc-upload-preview">
                  <?php
                    $setimg = false;
                    if ( $attach_id = $this->setting->getSetting( 'background_image' ) ) {
                        $setimg = true;
                        $data   = wp_get_attachment_image_src( $attach_id, 'thumbnail' );
                    }
                    if ( $setimg ) {
                        echo '<div class="image"><img src="' . $data[0] . '" /></div>';
                        echo '<div class="none ipvisc-hide">' . __( 'No image', IPVISC_SLUG ) . '</div>';
                        $reset_dsp = '';
                    } else {
                        echo '<div class="image"></div>';
                        echo '<div class="none">' . __( 'No image', IPVISC_SLUG ) . '</div>';
                        $reset_dsp = ' style="display:none;"';
                    }
                  ?>
              </div>

              <div class="ipvisc-image-field">
                  <div class="ipvisc-select-image">
                      <p class="mt0"><?php _e( 'Select an image or upload new image using the button below.', IPVISC_SLUG ); ?></p>
                      <a class="ipvisc-btn ipvisc-btn-secondary ipvisc-btn-media ipvisc-btn-sm" data-choose="<?php esc_attr_e( 'Choose Photo', IPVISC_SLUG ); ?>"
                        data-update="<?php esc_attr_e( 'Choose photo', IPVISC_SLUG ); ?>">
                          <i class="ipvisc-fa ipvisc-fa-image"></i>
                          <?php _e( 'Select Photo', IPVISC_SLUG ); ?>
                      </a>
                      <a class="ipvisc-btn ipvisc-btn-reset ipvisc-btn-sm" href="#"<?php echo $reset_dsp; ?>>
                          <i class="ipvisc-fa ipvisc-fa-ban"></i>
                          <?php _e( 'Clear Photo', IPVISC_SLUG ); ?>
                      </a>
                  </div>
                  <input type="hidden" name="upload_type" class="ipvisc-upload-type" value="background_image" />
                  <input type="hidden" name="background_image" class="ipvisc-image-id" value="<?php echo $attach_id; ?>" />
              </div>
          </div>

          <div class="ipvisc-help">
            <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
            <div class="ipvisc-help-content ipvisc-hide">
              <?php _e( 'Add background image in bellow the video.', IPVISC_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipvisc-field -->
      </div>
      <!-- end: .ipvisc-field-row -->

      <?php
      //Background repeat
      ?>
      <!-- start: .ipvisc-field-row -->
      <div class="ipvisc-field-row ipvisc-field-x">
          <div class="ipvisc-form-label col-lg-3 col-md-4 col-sm-12">
              <label for="input-background-repeat"><?php _e( 'Background Image Repeat', IPVISC_SLUG ); ?></label>
          </div>
          <div class="ipvisc-field col-lg-9 col-md-8 col-sm-12">

              <select name="background_repeat" id="input-background-repeat">
              <?php
              $current = stripslashes( $this->setting->getSetting( 'background_repeat', 'repeat' ));
              $repeats = array(
                  'no-repeat' => __( 'No Repeat', IPVISC_SLUG ),
                  'repeat'    => __( 'Repeat All', IPVISC_SLUG ),
                  'repeat-x'  => __( 'Repeat Horizontally', IPVISC_SLUG ),
                  'repeat-y'  => __( 'Repeat Vertically', IPVISC_SLUG )
              );
              foreach( $repeats as $key => $label ) {
                  $sltd = '';
                  if ( $key == $current ) {
                      $sltd = ' selected="selected"';
                  }
                  echo '<option value="' . $key . '"' . $sltd .'>'. $label .'</option>';
              }
              ?>
              </select>

              <div class="ipvisc-help">
                <a class="ipvisc-btn-help ipvisc-btn ipvisc-btn-default" href="#"><i class="ipvisc-fa ipvisc-fa-question"></i></a>
                  <div class="ipvisc-help-content ipvisc-hide">
                  <?php _e( 'The repeat method of the background image.', IPVISC_SLUG ); ?>
                </div>
            </div>
          </div>
      </div>
      <!-- end: .ipvisc-field-row -->

    </div>
    <!-- end: .ipvisc-fields -->
  </div>
</div>
