(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
/*!
 * The Final Countdown for jQuery v2.0.4 (http://hilios.github.io/jQuery.countdown/)
 * Copyright (c) 2014 Edson Hilios
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
(function(factory) {
    "use strict";
    if (typeof define === "function" && define.amd) {
        define([ "jquery" ], factory);
    } else {
        factory(jQuery);
    }
})(function($) {
    "use strict";
    var PRECISION = 100;
    var instances = [], matchers = [];
    matchers.push(/^[0-9]*$/.source);
    matchers.push(/([0-9]{1,2}\/){2}[0-9]{4}( [0-9]{1,2}(:[0-9]{2}){2})?/.source);
    matchers.push(/[0-9]{4}([\/\-][0-9]{1,2}){2}( [0-9]{1,2}(:[0-9]{2}){2})?/.source);
    matchers = new RegExp(matchers.join("|"));
    function parseDateString(dateString) {
        if (dateString instanceof Date) {
            return dateString;
        }
        if (String(dateString).match(matchers)) {
            if (String(dateString).match(/^[0-9]*$/)) {
                dateString = Number(dateString);
            }
            if (String(dateString).match(/\-/)) {
                dateString = String(dateString).replace(/\-/g, "/");
            }
            return new Date(dateString);
        } else {
            throw new Error("Couldn't cast `" + dateString + "` to a date object.");
        }
    }
    var DIRECTIVE_KEY_MAP = {
        Y: "years",
        m: "months",
        w: "weeks",
        d: "days",
        D: "totalDays",
        H: "hours",
        M: "minutes",
        S: "seconds"
    };
    function strftime(offsetObject) {
        return function(format) {
            var directives = format.match(/%(-|!)?[A-Z]{1}(:[^;]+;)?/gi);
            if (directives) {
                for (var i = 0, len = directives.length; i < len; ++i) {
                    var directive = directives[i].match(/%(-|!)?([a-zA-Z]{1})(:[^;]+;)?/), regexp = new RegExp(directive[0]), modifier = directive[1] || "", plural = directive[3] || "", value = null;
                    directive = directive[2];
                    if (DIRECTIVE_KEY_MAP.hasOwnProperty(directive)) {
                        value = DIRECTIVE_KEY_MAP[directive];
                        value = Number(offsetObject[value]);
                    }
                    if (value !== null) {
                        if (modifier === "!") {
                            value = pluralize(plural, value);
                        }
                        if (modifier === "") {
                            if (value < 10) {
                                value = "0" + value.toString();
                            }
                        }
                        format = format.replace(regexp, value.toString());
                    }
                }
            }
            format = format.replace(/%%/, "%");
            return format;
        };
    }
    function pluralize(format, count) {
        var plural = "s", singular = "";
        if (format) {
            format = format.replace(/(:|;|\s)/gi, "").split(/\,/);
            if (format.length === 1) {
                plural = format[0];
            } else {
                singular = format[0];
                plural = format[1];
            }
        }
        if (Math.abs(count) === 1) {
            return singular;
        } else {
            return plural;
        }
    }
    var Countdown = function(el, finalDate, callback) {
        this.el = el;
        this.$el = $(el);
        this.interval = null;
        this.offset = {};
        this.instanceNumber = instances.length;
        instances.push(this);
        this.$el.data("countdown-instance", this.instanceNumber);
        if (callback) {
            this.$el.on("update.countdown", callback);
            this.$el.on("stoped.countdown", callback);
            this.$el.on("finish.countdown", callback);
        }
        this.setFinalDate(finalDate);
        this.start();
    };
    $.extend(Countdown.prototype, {
        start: function() {
            if (this.interval !== null) {
                clearInterval(this.interval);
            }
            var self = this;
            this.update();
            this.interval = setInterval(function() {
                self.update.call(self);
            }, PRECISION);
        },
        stop: function() {
            clearInterval(this.interval);
            this.interval = null;
            this.dispatchEvent("stoped");
        },
        pause: function() {
            this.stop.call(this);
        },
        resume: function() {
            this.start.call(this);
        },
        remove: function() {
            this.stop();
            instances[this.instanceNumber] = null;
            delete this.$el.data().countdownInstance;
        },
        setFinalDate: function(value) {
            this.finalDate = parseDateString(value);
        },
        update: function() {
            if (this.$el.closest("html").length === 0) {
                this.remove();
                return;
            }
            this.totalSecsLeft = this.finalDate.getTime() - new Date().getTime();
            this.totalSecsLeft = Math.ceil(this.totalSecsLeft / 1e3);
            this.totalSecsLeft = this.totalSecsLeft < 0 ? 0 : this.totalSecsLeft;
            this.offset = {
                seconds: this.totalSecsLeft % 60,
                minutes: Math.floor(this.totalSecsLeft / 60) % 60,
                hours: Math.floor(this.totalSecsLeft / 60 / 60) % 24,
                days: Math.floor(this.totalSecsLeft / 60 / 60 / 24) % 7,
                totalDays: Math.floor(this.totalSecsLeft / 60 / 60 / 24),
                weeks: Math.floor(this.totalSecsLeft / 60 / 60 / 24 / 7),
                months: Math.floor(this.totalSecsLeft / 60 / 60 / 24 / 30),
                years: Math.floor(this.totalSecsLeft / 60 / 60 / 24 / 365)
            };
            if (this.totalSecsLeft === 0) {
                this.stop();
                this.dispatchEvent("finish");
            } else {
                this.dispatchEvent("update");
            }
        },
        dispatchEvent: function(eventName) {
            var event = $.Event(eventName + ".countdown");
            event.finalDate = this.finalDate;
            event.offset = $.extend({}, this.offset);
            event.strftime = strftime(this.offset);
            this.$el.trigger(event);
        }
    });
    $.fn.countdown = function() {
        var argumentsArray = Array.prototype.slice.call(arguments, 0);
        return this.each(function() {
            var instanceNumber = $(this).data("countdown-instance");
            if (instanceNumber !== undefined) {
                var instance = instances[instanceNumber], method = argumentsArray[0];
                if (Countdown.prototype.hasOwnProperty(method)) {
                    instance[method].apply(instance, argumentsArray.slice(1));
                } else if (String(method).match(/^[$A-Z_][0-9A-Z_$]*$/i) === null) {
                    instance.setFinalDate.call(instance, method);
                    instance.start();
                } else {
                    $.error("Method %s does not exist on jQuery.countdown".replace(/\%s/gi, method));
                }
            } else {
                new Countdown(this, argumentsArray[0], argumentsArray[1]);
            }
        });
    };
});
},{}],2:[function(require,module,exports){
var ui = require( './../libs/ui.js' );

(function($)
{
  "use strict";

  $(document).ready(function()
  {
    //
    //Save view stat
    $( '.ipvisc-container' ).each( function()
    {
      var videoId = $(this).data( 'id' );
      $.ajax({
        url: ipvisc_ajaxurl+'?doajax=1&ipvisc=1&action=savestat',
        type: "POST",
        data: 'video_id='+videoId+'&type=view',
        dataType: "json",
        success: function ( result ) {}
      });
    });

    //
    //Video upload init
    //
    var playerUpload,
        playerUploadWidget = false;

    $( '.ipvisc-video-upload-player' ).each( function()
    {
      var playerSettings = {};
      if ( typeof _wpmejsSettings !== 'undefined' ) {
  			playerSettings = _wpmejsSettings;
  		}
      playerSettings.success = playerSettings.success || function (mejs, dom) {
  			var autoplay, loop;
        var playerUploadOn = false;

  			if ( 'flash' === mejs.pluginType ) {
  				autoplay = mejs.attributes.autoplay && 'false' !== mejs.attributes.autoplay;
  				loop = mejs.attributes.loop && 'false' !== mejs.attributes.loop;

  				autoplay && mejs.addEventListener( 'canplay', function () {
  					mejs.play();
  				}, false );

  				loop && mejs.addEventListener( 'ended', function () {
  					mejs.play();
  				}, false );

          mejs.addEventListener('playing', function(e)
          {
            if ( ! playerUploadOn )
            {
              playerUploadOn = true;
              ipvisc_saveStateVideoUpload( dom );
            }
          }, false);
  			}
  		};
      playerUpload       = new MediaElementPlayer('.ipvisc-video-upload-player', playerSettings );
      playerUploadWidget = new MediaElementPlayer('.ipvisc-video-widget-upload-player', playerSettings );

    });

    //
    //Save stat
    function ipvisc_saveStateVideoUpload( dom )
    {
      var el      = $( dom );
      var root    = el.parents( '.ipvisc-container' );
      var videoId = root.data( 'id' );

      $.ajax({
        url: ipvisc_ajaxurl+'?doajax=1&ipvisc=1&action=savestat',
        type: "POST",
        data: 'video_id='+videoId+'&type=play',
        dataType: "json",
        success: function ( result ) {}
      });
    }

    //
    //Init ui
    ui.base.modal.prototype.top_margin = '20px';
    var modal  = new ui.base.modal();

    ui.base.loader.prototype.loader_file = ipvisc_img_url+'loading.gif';
    var loader = new ui.base.loader();

    //
    //Button optin
    $( '.ipvisc-button-optin' ).click( function()
    {
      //Show loader
      loader.show();
      //
      //Save stat
      var root    = $(this).parents( '.ipvisc-container' );
      var videoId = root.data( 'id' );

      $.ajax({
        url: ipvisc_ajaxurl+'?doajax=1&ipvisc=1&action=savestat',
        type: "POST",
        data: 'video_id='+videoId+'&type=click',
        dataType: "json",
        success: function ( result )
        {
          //Hide loader
          loader.hide();

          var popup = $( '.ipvisc-ui-modal', root );
          modal.popup_show( popup );
        }
      });

      return false;
    });

    //
    //Autoresponder submit
    $( '.ipvisc-autoresponder .ipvisc-form-submit' ).click( function()
    {
      //Show loader
      loader.show();
      //
      //Save stat
      var button  = $(this);
      var root    = button.parents( '.ipvisc-container' );
      var videoId = root.data( 'id' );

      $.ajax({
        url: ipvisc_ajaxurl+'?doajax=1&ipvisc=1&action=savestat',
        type: "POST",
        data: 'video_id='+videoId+'&type=subscribe',
        dataType: "json",
        success: function ( result )
        {
          //Hide loader
          loader.hide();

          //Form submit
          $( 'form', root )[0].submit();

        }
      });
      return false;
    });

    //
    //Button url
    $( '.ipvisc-button-url' ).click( function()
    {
      //Show loader
      loader.show();
      //
      //Save stat
      var button  = $(this);
      var root    = button.parents( '.ipvisc-container' );
      var videoId = root.data( 'id' );

      $.ajax({
        url: ipvisc_ajaxurl+'?doajax=1&ipvisc=1&action=savestat',
        type: "POST",
        data: 'video_id='+videoId+'&type=click',
        dataType: "json",
        success: function ( result )
        {
          //Hide loader
          loader.hide();

          window.location.href = button.attr( 'href' );
        }
      });

      return false;
    });


    //
    //Share link
    $( '.ipvisc-share .ipvisc-share-link' ).click( function()
    {
      var href = $(this).attr( 'href' );
      window.open(href,'t','toolbar=0,resizable=1,status=0,width=640,height=528');
      return false;
    });

    //
    //Modal close
    $( '.ipvisc-ui-close-link' ).click( function()
    {
        var popup = $(this).parents( '.ipvisc-ui-modal' );
        modal.popup_hide( popup );
    });

    //
    //Countdown
    $( '.ipvisc-countdown-item' ).each( function()
    {
      var item   = $(this);
      var time   = item.data( 'time' );
      var format = item.data( 'format' );
      var ftext  = ipvisc_format_text( format );

      item.countdown( time )
        .on('update.countdown', function(event) {
          var $this = $(this).html(event.strftime( '' + ftext ));
        });
    });

    //
    //
    //Widget
    //
    var widgetIsOpen = false;
    $( '.ipvisc-container' ).each( function()
    {
      var root   = $(this);
      var video  = $( '.ipvisc-video', root );
      var widget = $( '.ipvisc-video-widget', root );
      var top    = video.position().top;
      var height = video.height();
      var bottom = top+height+50;

      $( window ).scroll( function()
      {
        var scrollTop = $(this).scrollTop();
        if ( scrollTop > bottom ) {
          if ( ! widgetIsOpen ) {
            widgetIsOpen = true;
            openWidget( widget );
          }
        } else {
          if ( widgetIsOpen ) {
            widgetIsOpen = false;
            closeWidget( widget );
          }
        }
      });

    });

    //
    //Close widget
    $( '.ipvisc-video-widget ._action-close' ).click( function()
    {
      var widget = $(this).parents( '.ipvisc-video-widget' );
      widgetIsOpen = false;
      closeWidget( widget );
      return false;
    });

    //
    //Minimze widget
    $( '.ipvisc-video-widget ._action-minimize' ).click( function()
    {
      var widget = $(this).parents( '.ipvisc-video-widget' );
      if ( widget.hasClass( 'ipvisc-close' ) ) {
        widgetIsOpen = true;
        openWidget( widget );
      } else {
        widgetIsOpen = false;
        minimizeCloseWidget( widget );
      }
      return false;
    });

    //
    //Open widget
    function openWidget( widget )
    {
      //
      //Play video
      var root       = widget.parents( '.ipvisc-container' );
      var videoType  = root.data( 'type' );
      var playMethod = root.data( 'play' );

      if ( videoType == 'youtube' )
      {
        if ( ipvisc_player && ipvisc_playerWidget )
        {
          var state = ipvisc_player.getPlayerState();
          if ( state == 1 ) {
            ipvisc_player.pauseVideo();
          }

          if ( playMethod == 'restart' ) {
            ipvisc_playerWidget.playVideo();
          }
          else if ( playMethod == 'continue' )
          {
            if ( state == 1 ) {
              var time = ipvisc_player.getCurrentTime();
              ipvisc_playerWidget.seekTo( time );
            }
            ipvisc_playerWidget.playVideo();
          }
        }
      }
      else if ( videoType == 'upload' )
      {
        playerUpload.pause();
        if ( playMethod == 'restart' ) {
          playerUploadWidget.play();
        }
        else if ( playMethod == 'continue' )
        {
          var time = playerUpload.getCurrentTime();
          if ( time > 0 ) {
            playerUploadWidget.setCurrentTime( time );
          }
          playerUploadWidget.play();
        }
      }

      widget.removeClass( 'ipvisc-close' );
      widget.addClass( 'ipvisc-open' );

      var effect = widget.data( 'show_effect' );
      var speed  = widget.data( 'show_speed' );
      var easing = _getEasing( effect );

      if ( widget.hasClass( 'ipvisc-video-widget-top_right' ) ||
           widget.hasClass( 'ipvisc-video-widget-top_left' ) ||
           widget.hasClass( 'ipvisc-video-widget-top_center' )
      ) {
        widget.animate(
            {top:0},
            {queue:false, duration:speed, easing: easing }
        );
      }
      else
      {
        widget.animate(
            {bottom:0},
            {queue:false, duration:speed, easing: easing }
        );
      }

      //
      //Play audio
      var audio = $( '.ipvisc-audio-show', widget );
      if ( audio.length > 0 )
      {
        audio[0].play();
      }
    }

    //
    //Close widget
    function closeWidget( widget )
    {
      //
      //Pause widget video
      pauseVideoWidget( widget );

      widget.removeClass( 'ipvisc-open' );
      widget.addClass( 'ipvisc-close' );

      var effect = widget.data( 'hide_effect' );
      var speed  = widget.data( 'hide_speed' );
      var easing = _getEasing( effect );

      if ( widget.hasClass( 'ipvisc-video-widget-top_right' ) ||
           widget.hasClass( 'ipvisc-video-widget-top_left' ) ||
           widget.hasClass( 'ipvisc-video-widget-top_center' )
      ) {
        widget.animate(
            {top:'-200%'},
            {queue:false, duration:speed, easing: easing }
        );
      }
      else
      {
        widget.animate(
            {bottom:'-200%'},
            {queue:false, duration:speed, easing: easing }
        );
      }
      //
      //Play audio
      var audio = $( '.ipvisc-audio-hide', widget );
      if ( audio.length > 0 )
      {
        audio[0].play();
      }
    }

    //
    //Minimize widget
    function minimizeCloseWidget( widget )
    {
      //
      //Pause widget video
      pauseVideoWidget( widget );

      widget.removeClass( 'ipvisc-open' );
      widget.addClass( 'ipvisc-close' );

      var effect = widget.data( 'hide_effect' );
      var speed  = widget.data( 'hide_speed' );
      var easing = _getEasing( effect );

      var widgetHeight = widget.height();
      var headerHeight = $( '.ipvisc-video-widget-header', widget ).height();
      var bodyHeight   = (widgetHeight - headerHeight +2) * -1;

      if ( widget.hasClass( 'ipvisc-video-widget-top_right' ) ||
           widget.hasClass( 'ipvisc-video-widget-top_left' ) ||
           widget.hasClass( 'ipvisc-video-widget-top_center' )
      ) {
        widget.animate(
            {top: bodyHeight+'px'},
            {queue:false, duration:speed, easing: easing }
        );
      }
      else
      {
        widget.animate(
            {bottom:bodyHeight+'px'},
            {queue:false, duration:speed, easing: easing }
        );
      }
    }

    //
    //Pause video widget
    function pauseVideoWidget( widget )
    {
      //
      //Pause widget video
      var root       = widget.parents( '.ipvisc-container' );
      var videoType  = root.data( 'type' );
      var playMethod = root.data( 'play' );

      if ( videoType == 'youtube' )
      {
        if ( ipvisc_playerWidget )
        {
          ipvisc_playerWidget.pauseVideo();
        }
      }
      else if ( videoType == 'upload' )
      {
        playerUploadWidget.pause();
      }
    }

    function ipvisc_format_text( format )
    {
      var day    = '<div class="ipvisc-countdown-val"><strong>%D</strong> <em>day%!d</em></div>';
      var month  = '<div class="ipvisc-countdown-val"><strong>%m</strong> <em>month%!d</em></div>';
      var year   = '<div class="ipvisc-countdown-val"><strong>%Y</strong> <em>year%!d</em></div>';
      var week   = '<div class="ipvisc-countdown-val"><strong>%w</strong> <em>week%!d</em></div>';
      var hour   = '<div class="ipvisc-countdown-val"><strong>%H</strong> <em>hour%!d</em></div>';
      var minute = '<div class="ipvisc-countdown-val"><strong>%M</strong> <em>minute%!d</em></div>';
      var second = '<div class="ipvisc-countdown-val"><strong>%S</strong> <em>second%!d</em></div>';

      var _text = format
                  .replace( /_/g, ' ' )
                  .replace( 'y', '{y}' )
                  .replace( 'i', '{i}' )
                  .replace( 'd', '{d}' )
                  .replace( 'w', '{w}' )
                  .replace( 'h', '{h}' )
                  .replace( 'm', '{m}' )
                  .replace( 's', '{s}' );

      var text = _text
                  .replace( '{y}', year )
                  .replace( '{m}', month )
                  .replace( '{d}', day )
                  .replace( '{w}', week )
                  .replace( '{h}', hour )
                  .replace( '{i}', minute )
                  .replace( '{s}', second );

      return text;
    }

    function _getSpeed( speedType )
    {
      var speed = 800;
      if ( speedType == 'xs' ) {
        speed = 200;
      } else if ( speedType == 'sm' ) {
        speed = 500;
      } else if ( speedType == 'lg' ) {
        speed = 1200;
      } else if ( speedType == 'xg' ) {
        speed = 1800;
      }
      return speed;
    }

    function _getEasing( effect )
    {
      if ( effect == 'bounce' ) {
        var easing = 'easeOutBounce';
      } else if ( effect == 'back' ) {
        var easing = 'easeOutBack';
      } else if ( effect == 'elastic' ) {
        var easing = 'easeOutElastic';
      } else if ( effect == 'expo' ) {
        var easing = 'easeOutExpo';
      } else {
        var easing = 'linear';
      }
      return easing;
    }

    function _getHiddingEasing( effect )
    {
      if ( effect == 'bounce' ) {
        var easing = 'easeInBounce';
      } else if ( effect == 'back' ) {
        var easing = 'easeInBack';
      } else if ( effect == 'elastic' ) {
        var easing = 'easeInElastic';
      } else if ( effect == 'expo' ) {
        var easing = 'easeInExpo';
      } else {
        var easing = 'linear';
      }
      return easing;
    }

    function _playAudio( type, root )
    {
      if ( type == 'hiding' ) {
        var audio = $( '._hiding-audio', root );
        if ( audio.length > 0 ) {
          audio[0].play();
        }
      } else
      {
        var audio = $( '._showing-audio', root );
        if ( audio.length > 0 ) {
          audio[0].play();
        }
      }
    }
  });
})(jQuery);

},{"./../libs/ui.js":3}],3:[function(require,module,exports){
/*
 *===========================================================
 * UI
 *===========================================================
 */
var ui;

(function($)
{
    "use strict";

    //Inherit function
    function inherit( proto )
    {
        function F() {}
        F.prototype = proto
        return new F
    }

    /*
     *===========================================================
     * Ui prototype
     *===========================================================*/
    function ui_construct( options ){};

    ui_construct.prototype =
    {

        vars:               {},
        class_prefix:       'ipvisc-',
        class_main:         '-main',
        class_title:        '-title',
        class_content:      '-content',
        class_disabled:     'disabled',
        class_close:        'ui-close',
        label_close:        'x',
        image_base:         '',

        top_margin:         '80px',
        overlay_speed:      600,
        main_speed:         400,
        show_speed:         4000,

        show_after:         function(){},
        hide_after:         function(){},

        popup_body: function( class_root, content, title, close )
        {
            var body = $( '<div class="'+class_root+'"></div>' );
            var main = $( '<div class="'+class_root + this.class_main+'"></div>' );
            if ( title )
            {
                var _title = $( '<div class="'+class_root + this.class_title+'"></div>' )
                                .append( '<h3>'+title+'</h3>' );
                if ( close )
                {
                    var _close = $( '<a href="#">'+this.label_close+'</a>' );
                    this.popup_close( _close, class_root );

                    _title.append(
                        $( '<div class="'+this.class_prefix+this.class_close+'"></div>' ).append( _close )
                    );
                }
                main.append( _title );
            }
            if ( content ) {
                main.append(
                    $( '<div class="'+class_root + this.class_content+'"></div>' ).append( content )
                );
            }
            body.append( main );
            return body;
        },
        popup_show: function( popup )
        {
            var c_root = popup.attr( 'class' );
            var main   = $( '.'+c_root+this.class_main, popup );
            popup.show();
            main.css( 'margin-top', '-40%' )
                .animate({marginTop: this.top_margin}, this.main_speed, this.show_after);
        },
        popup_hide: function( popup )
        {
            var c_root = popup.attr( 'class' );
            var main   = $( '.'+c_root+this.class_main, popup );

            popup.animate( {opacity: 0}, this.overlay_speed, function(){
                $(this).css( 'opacity', 1 )
                       .hide();
            });
            main.animate( {marginTop: '-60%'}, this.main_speed, this.hide_after);
        },
        popup_close: function( button, class_popup )
        {
            var ui = this;
            button.click( function(){
                var popup = $( '.'+class_popup );
                ui.popup_hide( popup );
                return false;
            });
        },
        is_load: function( selector )
        {
            if ( $( selector ).length > 0 ) {
                return true;
            }
            return false;
        },
        set_vars: function( options )
        {
            this.vars = $.extend(this.vars, options);
        },
        set_base_vars: function( options )
        {
            this.vars = $.extend(this, options);
        },
        go_to: function( selector )
        {
            var pos = $( selector ).position();
            $('html, body').animate({scrollTop: ( pos.top )}, 600);
            return false;
        }
    };

    /*
     * Modal Class
     **/
    function modal(){};
    modal.prototype = inherit( ui_construct.prototype );
    //Modal message
    modal.prototype.ajax = function( id, url )
    {
        var ui      = this;
        var c_root  = this.class_prefix + this.class_modal;
        var modal   = this.popup_body( c_root, '', false, false ).appendTo( $( 'body' ) );
        modal.addClass( class_type )
             .attr( 'id', id );

        this.popup_show( modal );
    };

    /*
     * Loader Class
     **/
    function loader(){};
    loader.prototype = inherit( ui_construct.prototype );
    //Properties
    loader.prototype.class_root     = 'ui-loader';
    loader.prototype.loader_file    = 'loading.gif';
    //Show loader
    loader.prototype.show = function()
    {
        var loader = this.create();
        this.popup_show( loader );
    };
    //Hide loader
    loader.prototype.hide = function()
    {
        var loader = this.create();
        this.popup_hide( loader );
    };
    //Create loader
    loader.prototype.create = function()
    {
        var c_root = this.class_prefix + this.class_root;
        if ( this.is_load( '.'+c_root )) {
            return $( '.'+c_root );
        } else
        {
            var image  = '<img src="'+this.image_base+this.loader_file+'" alt="Loading...">';
            var loader = this.popup_body( c_root, image, false, false ).appendTo( $( 'body' ) );
            loader.hide();

            return loader;
        }
    };


    /*
     * Inline loader Class
     **/
    function iloader(){};
    iloader.prototype = inherit( ui_construct.prototype );
    //Properties
    iloader.prototype.class_root   = 'ui-inline-loader';
    iloader.prototype.loader_file  = 'spin.gif';
    //Loader show
    iloader.prototype.show = function( button )
    {
        button.attr( 'disabled', 'disabled' );
        this.create( button ).show();
    };
    //Loader hide
    iloader.prototype.hide = function( button )
    {
        button.removeAttr( 'disabled' );
        this.create( button ).hide();
    };
    //Creating loader
    iloader.prototype.create = function( button )
    {
        var root   = button.parent();
        var lclass = this.class_prefix + this.class_root;
        if ( $( '.'+lclass, root ).length > 0 ) {
            var loader = $( '.'+lclass, root );
        } else {
            var image  = '<img src="'+this.image_base+this.loader_file+'" alt="Loading...">';
            var loader = $( '<span class="'+lclass+'"></span>' )
                            .append( image )
                            .css( 'margin-left', '8px' );
        }
        button.after( loader );
        return loader;
    };


    /*
     * Confirm popup
     **/
    function confirm( options )
    {
        var defaults = {
            title:      'Confirmation',
            info:       '',
            yes_label:  'Yes',
            no_label:   'Cancel',
            yes_class:  'btn btn-danger',
            no_class:   'btn btn-success',
            action:     function( object ){}
        };
        this.vars = $.extend(defaults, options);
    };
    confirm.prototype = inherit( ui_construct.prototype );
    //Properties
    confirm.prototype.class_root = 'ui-confirm';
    //Confirm show
    confirm.prototype.show = function( object )
    {
        var confirm = this.create( object );
        this.popup_show( confirm );
    };
    //Confirm hide
    confirm.prototype.hide = function( object )
    {
        var confirm = this.create( object );
        this.popup_hide( confirm );
    };
    //Creating confirm
    confirm.prototype.create = function( object )
    {
        var ui     = this;
        var c_root = this.class_prefix + this.class_root;
        if ( this.is_load( '.'+c_root )) {
            $( '.'+c_root ).remove();
        }
        //Create confirm
        var yesbtn = $( '<a href="#" class="ip-confirm-yes '+this.vars.yes_class+'">'+this.vars.yes_label+'</a>' );
        var nobtn  = $( '<a href="#" class="ip-confirm-no '+this.vars.no_class+'">'+this.vars.no_label+'</a>' );

        yesbtn.click( function(){
            ui.vars.action( object, ui );
            return false;
        });
        this.popup_close( nobtn, c_root );

        var content = $( '<div class="'+c_root+'-inner"></div>' )
            .append( '<p>'+this.vars.info+'</p>' )
            .append(
                $( '<div class="'+c_root+'-actions"></div>' )
                    .append( yesbtn )
                    .append( nobtn )
            );

        var confirm = this.popup_body( c_root, content, this.vars.title, false ).appendTo( $( 'body' ) );
        confirm.hide();

        return confirm;
    };


    /*
     * Alert popup
     **/
    function alert( options )
    {
        var defaults = {
            message:        '',
            label_button:   'Ok',
            class_root:     '',
            class_button:   'ipvisc-btn ipvisc-btn-sm ipvisc-btn-danger',
            after:          function(){}
        };
        this.vars = $.extend(defaults, options);
    };
    alert.prototype = inherit( ui_construct.prototype );
    //Properties
    alert.prototype.class_root = 'ui-alert';
    //Alert show
    alert.prototype.show = function( message )
    {
        this.vars.message = message;
        var alert = this.create();
        this.popup_show( alert );
    };
    //Alert hide
    alert.prototype.hide = function()
    {
        var alert = this.create();
        this.hide_after = this.vars.after;
        this.popup_hide( alert );
    };
    //Creating alert
    alert.prototype.create = function()
    {
        var ui     = this;
        var c_root = this.class_prefix + this.class_root;
        if ( this.is_load( '.'+c_root )) {
            return $( '.'+c_root );
        } else
        {
            var button = $( '<a href="#" class="'+this.vars.class_button+'">'+this.vars.label_button+'</a>' );
            this.popup_close( button, c_root );

            var c_info  = c_root + '-inner';
            if ( this.vars.class_root != '' ) {
                c_info += ' ' + this.vars.class_root;
            }
            var content = $( '<div class="'+c_info+'"></div>' )
                .append( '<p>'+this.vars.message+'</p>' )
                .append(
                    $( '<div class="'+c_root+'-actions"></div>' )
                        .append( button )
                );

            var popup  = this.popup_body( c_root, content, false, false ).appendTo( $( 'body' ) );
            popup.hide();

            return popup;
        }
    };


    /*
     * Message
     **/
    function message(){};
    message.prototype = inherit( ui_construct.prototype );
    //Properties
    message.prototype.class_modal = 'ui-modal-message';
    message.prototype.class_block = 'ui-message';
    //Modal message
    message.prototype.modal = function( message, class_type )
    {
        var ui      = this;
        var c_root  = this.class_prefix + this.class_modal;
        var content = '<p>'+message+'</p>';
        var msg     = this.popup_body( c_root, content, false, false ).appendTo( $( 'body' ) );
        msg.addClass( class_type )
           .show()
           .animate({top: "0"}, ui.overlay_speed, function(){
                var object = $( this );
                setTimeout( function(){
                    object.animate({top: '-100px'}, ui.overlay_speed, function(){
                        object.remove();
                    });
                }, ui.show_speed);
            });
    };
    //Bloack message
    message.prototype.block = function( message, class_type, block, close )
    {
        var ui      = this;
        var c_root  = this.class_prefix + this.class_block;
        var parent  = block.parent();

        $( '.'+c_root, parent ).remove();

        var msg = $( '<div></div>' );
        msg.addClass( c_root )
           .addClass( class_type )
           .append( '<p>'+message+'</p>' );

        if ( close )
        {
            var _close = $( '<a href="#">'+this.close_label+'</a>' );
            _close.click( function()
            {
                var _msg = $(this).parents( '.'+c_root );
                _msg.animate({opacity: "0"}, ui.overlay_speed, function(){
                    _msg.remove();
                });
                return false;
            });
            msg.append(
                $( '<div class="'+this.class_prefix+this.class_close+'"></div>' ).append( _close )
            );
        }
        msg.css( 'opacity', '0' );
        parent.prepend( msg );
        msg.animate({opacity: "1"}, ui.overlay_speed);
    };

    ui =
    {
        base: {
            construct:  ui_construct,
            loader:     loader,
            iloader:    iloader,
            confirm:    confirm,
            message:    message,
            alert:      alert,
            modal:      modal

        },
        init: function()
        {
            this.loader  = new this.base.loader(),
            this.iloader = new this.base.iloader(),
            this.confirm = new this.base.confirm(),
            this.message = new this.base.message(),
            this.alert   = new this.base.alert(),
            this.modal   = new this.base.modal()
        }
    };

})(jQuery);

module.exports = ui;

},{}]},{},[1,2]);
