var constants_1 = require("../../util/constants");
var utils = require("../../util/utilsCore");
var $ = utils.getLocaleString;
var documentation;
function addDocumentationAction(name, args, description, action) {
    documentation.command(name + " " + args).description(description)
        .option("-e, --environment <env>", "Use <env> environment for this command")
        .execute(action).usage(args);
}
exports.init = function (cli) {
    documentation = cli.category("documentation").description("Get documentation");
    addDocumentationAction("gettingStarted", " ", "Access the Control-M Automation API documentation", function (options, _) {
        cli.setupOptions(options);
        var targetUrl = constants_1.Constants.apiDocumentation;
        utils.launchBrowserPromis(targetUrl).then(function (msg) {
            console.info($("opening url: %s", targetUrl));
        }).catch(function (error) {
            console.info($("failed to opening url: %s. error: %s.", targetUrl, error));
        });
    });
    addDocumentationAction("codeReference", " ", "Access the Control-M Automation API Code Reference documentation", function (options, _) {
        cli.setupOptions(options);
        var targetUrl = constants_1.Constants.apiDocumentationCode;
        utils.launchBrowserPromis(targetUrl).then(function (msg) {
            console.info($("opening url: %s", targetUrl));
        }).catch(function (error) {
            console.info($("failed to opening url: %s. error: %s.", targetUrl, error));
        });
    });
    addDocumentationAction("services", " ", "Access the Control-M Automation API Services Reference documentation", function (options, _) {
        cli.setupOptions(options);
        var targetUrl = constants_1.Constants.apiDocumentationServices;
        utils.launchBrowserPromis(targetUrl).then(function (msg) {
            console.info($("opening url: %s", targetUrl));
        }).catch(function (error) {
            console.info($("failed to opening url: %s. error: %s.", targetUrl, error));
        });
    });
    addDocumentationAction("installation", " ", "Access the Control-M Automation API Installation documentation", function (options, _) {
        cli.setupOptions(options);
        var targetUrl = constants_1.Constants.apiDocumentationInstall;
        utils.launchBrowserPromis(targetUrl).then(function (msg) {
            console.info($("opening url: %s", targetUrl));
        }).catch(function (error) {
            console.info($("failed to opening url: %s. error: %s.", targetUrl, error));
        });
    });
    addDocumentationAction("github", " ", "Access the Control-M Automation API GitHub", function (options, _) {
        cli.setupOptions(options);
        var targetUrl = constants_1.Constants.apiDocumentationGitHub;
        utils.launchBrowserPromis(targetUrl).then(function (msg) {
            console.info($("opening url: %s", targetUrl));
        }).catch(function (error) {
            console.info($("failed to opening url: %s. error: %s.", targetUrl, error));
        });
    });
    addDocumentationAction("deployDescriptor", " ", "Access the Control-M Automation API Deploy Descriptor", function (options, _) {
        cli.setupOptions(options);
        var targetUrl = constants_1.Constants.apiDocumentationDeployDescriptor;
        utils.launchBrowserPromis(targetUrl).then(function (msg) {
            console.info($("opening url: %s", targetUrl));
        }).catch(function (error) {
            console.info($("failed to opening url: %s. error: %s.", targetUrl, error));
        });
    });
    addDocumentationAction("restApi", " ", "Access the Control-M Automation REST API documentation", function (options, _) {
        cli.setupOptions(options);
        var targetUrl = cli.targetUrl + "/swagger-ui.html";
        console.info($("opening url: %s", targetUrl));
        utils.launchBrowser(targetUrl);
    });
};
//# sourceMappingURL=dk_portal.js.map