"use strict";
var argData_1 = require("../../util/argData");
var utilsCore = require("../../util/utilsCore");
var S = utilsCore.getLocaleString;
exports.init = function (cli) {
    cli.modelsArgs = {
        ActionsAuthRecord: [
            { description: "component in which the action sent - Possible Values - EM, CTM_Server, CTM_Agent, CTM_CM",
                hidden: false,
                prompt: "",
                name: "destination",
                required: false,
                type: "ActionsAuthRecord.ActionsAuthRecord.DestinationEnum" },
            { description: "action name unique list of actions&#39; names as appear in the actions_auth em db table, along with the destination makes a unique action auth entry",
                hidden: false,
                prompt: "",
                name: "action",
                required: false,
                type: "ActionsAuthRecord.ActionsAuthRecord.ActionEnum" },
            { description: "Privilege (Can be empty) Possible Values for categories fields  - OPER, DATABASE, CONFIG, CTMSEC, CPMAN, RAMAN, AGMAN, CMMAN, CCP, UNKNOWN",
                hidden: false,
                prompt: "",
                name: "category",
                required: false,
                type: "string" },
            { description: "required minimum authorization level - BROWSE, UPDATE, FULL",
                hidden: false,
                prompt: "",
                name: "authLevel",
                required: false,
                type: "string" },
            { description: "R - request always pass, authorization is done on the response; C - Connection Profile name will remain empty and will be ignored; E - Not related to authorization",
                hidden: false,
                prompt: "",
                name: "actionType",
                required: false,
                type: "string" },
            { description: "currently not in use regarding authorization",
                hidden: false,
                prompt: "",
                name: "additionalInfo",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "category2",
                required: false,
                type: "string" },
            { description: "relation between Category and category2 - 1. Only category, 2. Only Category2, 3. Category AND Category2, 4. Category OR Category2",
                hidden: false,
                prompt: "",
                name: "policy",
                required: false,
                type: "ActionsAuthRecord.ActionsAuthRecord.PolicyEnum" },
            { description: "In case that not all information for authorization exist in the header request, it contain path in the body for the missing field\\fields.",
                hidden: false,
                prompt: "",
                name: "authAttr",
                required: false,
                type: "string" },
        ],
        ActiveServices: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "serviceLastUpdatedTime",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "activeServices",
                required: false,
                type: "Array<SLAService>" },
        ],
        AddAgentParams: [
            { description: "The hostname or alias of the agent machine.",
                hidden: false,
                prompt: "",
                name: "host",
                required: true,
                type: "string" },
            { description: "The agent&#39;s listening port.",
                hidden: false,
                prompt: "",
                name: "port",
                required: true,
                type: "number" },
            { description: "The agent&#39;s tag.",
                hidden: false,
                prompt: "",
                name: "tag",
                required: false,
                type: "string" },
            { description: "The agent&#39;s ssl State. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "sslState",
                required: false,
                type: "string" },
            { description: "Is the connection persistent or create each time it is needed. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "persistentConnection",
                required: false,
                type: "boolean" },
            { description: "maximum time in seconds to wait (default 60). HIDDEN",
                hidden: false,
                prompt: "",
                name: "timeout",
                required: false,
                type: "number" },
            { description: "Suppress ping action to added agent (default false). HIDDEN.",
                hidden: false,
                prompt: "",
                name: "suppressPing",
                required: false,
                type: "boolean" },
        ],
        AddRemoteHostParams: [
            { description: "The remote host (name) which will execute the commands. REQUIRED.",
                hidden: false,
                prompt: "",
                name: "remotehost",
                required: false,
                type: "string" },
            { description: "The remote host SSH port.",
                hidden: false,
                prompt: "",
                name: "port",
                required: false,
                type: "number" },
            { description: "The SSH encrypt algorithm to be used. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "encryptAlgorithm",
                required: false,
                type: "string" },
            { description: "Is compression used. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "compression",
                required: false,
                type: "boolean" },
            { description: "authorize SSL remote host while creating the remote host. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "authorize",
                required: false,
                type: "boolean" },
            { description: "Agents to execute the commands on. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "agents",
                required: false,
                type: "Array<string>" },
        ],
        AddRemoveSuccessData: [
            { description: "The success message that describes the performed action.",
                hidden: false,
                prompt: "",
                name: "message",
                required: false,
                type: "string" },
            { description: "List of the items remained after the action.",
                hidden: false,
                prompt: "",
                name: "currentItems",
                required: false,
                type: "Array<string>" },
        ],
        AddServerParams: [
            { description: "The Control-M Server host name.",
                hidden: false,
                prompt: "",
                name: "host",
                required: true,
                type: "string" },
            { description: "The Control-M Server name.",
                hidden: false,
                prompt: "",
                name: "ctm",
                required: true,
                type: "string" },
            { description: "The id of the Control-M Server, 3 digits id",
                hidden: false,
                prompt: "",
                name: "id",
                required: true,
                type: "string" },
            { description: "The Control-M Server port number.",
                hidden: false,
                prompt: "",
                name: "port",
                required: false,
                type: "number" },
        ],
        AgentCertificateExpirationData: [
            { description: "The Certificate expiration date",
                hidden: false,
                prompt: "",
                name: "expirationDate",
                required: false,
                type: "string" },
        ],
        AgentData: [
            { description: "The Agent name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "The Agent host",
                hidden: false,
                prompt: "",
                name: "host",
                required: false,
                type: "string" },
            { description: "The Agent nodeID",
                hidden: false,
                prompt: "",
                name: "nodeID",
                required: false,
                type: "string" },
            { description: "The Control-M name",
                hidden: false,
                prompt: "",
                name: "ctm",
                required: false,
                type: "string" },
            { description: "The Control-M Host",
                hidden: false,
                prompt: "",
                name: "ctmHost",
                required: false,
                type: "string" },
            { description: "The Agent current state",
                hidden: false,
                prompt: "",
                name: "currentState",
                required: false,
                type: "string" },
            { description: "The Agent status",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
            { description: "The Agent status message",
                hidden: false,
                prompt: "",
                name: "statusMessage",
                required: false,
                type: "string" },
            { description: "The Agent operating System",
                hidden: false,
                prompt: "",
                name: "operatingSystem",
                required: false,
                type: "string" },
            { description: "The Agent platform",
                hidden: false,
                prompt: "",
                name: "platform",
                required: false,
                type: "string" },
            { description: "The Agent version",
                hidden: false,
                prompt: "",
                name: "version",
                required: false,
                type: "string" },
            { description: "The Agent last update",
                hidden: false,
                prompt: "",
                name: "lastUpdate",
                required: false,
                type: "string" },
            { description: "The Agent communication version",
                hidden: false,
                prompt: "",
                name: "communicationVersion",
                required: false,
                type: "string" },
            { description: "The Agent tag",
                hidden: false,
                prompt: "",
                name: "tag",
                required: false,
                type: "string" },
            { description: "The Agent ssl state",
                hidden: false,
                prompt: "",
                name: "sslState",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "plugins",
                required: false,
                type: "Array<PluginData>" },
        ],
        AgentDetails: [
            { description: "agent machine",
                hidden: false,
                prompt: "",
                name: "nodeid",
                required: false,
                type: "string" },
            { description: "agent status",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
        ],
        AgentDetailsList: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "agents",
                required: false,
                type: "Array<AgentDetails>" },
        ],
        AgentInGroupParams: [
            { description: "The hostname of the agent.",
                hidden: false,
                prompt: "",
                name: "host",
                required: true,
                type: "string" },
            { description: "The host condition. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "hostgroupAgentParticipation",
                required: false,
                type: "HostgroupAgentParticipation" },
        ],
        AgentMngAuth: [
            { description: "control-M server name",
                hidden: false,
                prompt: "",
                name: "controlmServer",
                required: false,
                type: "string" },
            { description: "agent name",
                hidden: false,
                prompt: "",
                name: "agent",
                required: false,
                type: "string" },
            { description: "access level (full, update, browse)",
                hidden: false,
                prompt: "",
                name: "privilege",
                required: false,
                type: "string" },
        ],
        AgentsDataList: [],
        AgentsInGroupListResult: [],
        AgentsInGroupSuccessData: [
            { description: "The success message that describes the performed action.",
                hidden: false,
                prompt: "",
                name: "message",
                required: false,
                type: "string" },
            { description: "List of the items remained after the action.",
                hidden: false,
                prompt: "",
                name: "agents",
                required: false,
                type: "Array<AgentInGroupParams>" },
        ],
        AiDeployResponse: [
            { description: "response message",
                hidden: false,
                prompt: "",
                name: "message",
                required: false,
                type: "string" },
        ],
        AiError: [
            { description: "Error message",
                hidden: false,
                prompt: "",
                name: "message",
                required: false,
                type: "string" },
            { description: "Http status code",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "number" },
        ],
        AiJobtype: [
            { description: "Jobtype display name",
                hidden: false,
                prompt: "",
                name: "jobTypeName",
                required: false,
                type: "string" },
            { description: "Jobtype internal appname",
                hidden: false,
                prompt: "",
                name: "jobTypeId",
                required: false,
                type: "string" },
            { description: "Jobtype status [&#39;ready to deploy&#39;, &#39;draft&#39;]",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
            { description: "Jobtype description",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
        ],
        AiJobtypeList: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "jobtypes",
                required: false,
                type: "Array<AiJobtype>" },
        ],
        AllowedJobActions: [
            { description: "True if Properties action is allowed",
                hidden: false,
                prompt: "",
                name: "viewProperties",
                required: false,
                type: "boolean" },
            { description: "True if Documentation action is allowed",
                hidden: false,
                prompt: "",
                name: "documentation",
                required: false,
                type: "boolean" },
            { description: "True if Log action is allowed",
                hidden: false,
                prompt: "",
                name: "log",
                required: false,
                type: "boolean" },
            { description: "True if Statistics action is allowed",
                hidden: false,
                prompt: "",
                name: "statistics",
                required: false,
                type: "boolean" },
            { description: "True if ViewOutputList action is allowed",
                hidden: false,
                prompt: "",
                name: "viewOutputList",
                required: false,
                type: "boolean" },
            { description: "True if ViewJcl action is allowed",
                hidden: false,
                prompt: "",
                name: "viewJcl",
                required: false,
                type: "boolean" },
            { description: "True if Why action is allowed",
                hidden: false,
                prompt: "",
                name: "why",
                required: false,
                type: "boolean" },
            { description: "True if Hold action is allowed",
                hidden: false,
                prompt: "",
                name: "hold",
                required: false,
                type: "boolean" },
            { description: "True if Free action is allowed",
                hidden: false,
                prompt: "",
                name: "free",
                required: false,
                type: "boolean" },
            { description: "True if Confirm action is allowed",
                hidden: false,
                prompt: "",
                name: "confirm",
                required: false,
                type: "boolean" },
            { description: "True if Rerun action is allowed",
                hidden: false,
                prompt: "",
                name: "rerun",
                required: false,
                type: "boolean" },
            { description: "True if React action is allowed",
                hidden: false,
                prompt: "",
                name: "react",
                required: false,
                type: "boolean" },
            { description: "True if Restart action is allowed",
                hidden: false,
                prompt: "",
                name: "restart",
                required: false,
                type: "boolean" },
            { description: "True if Kill action is allowed",
                hidden: false,
                prompt: "",
                name: "kill",
                required: false,
                type: "boolean" },
            { description: "True if Bypass action is allowed",
                hidden: false,
                prompt: "",
                name: "bypass",
                required: false,
                type: "boolean" },
            { description: "True if Delete action is allowed",
                hidden: false,
                prompt: "",
                name: "_delete",
                required: false,
                type: "boolean" },
            { description: "True if Undelete action is allowed",
                hidden: false,
                prompt: "",
                name: "undelete",
                required: false,
                type: "boolean" },
            { description: "True if SetToOk action is allowed",
                hidden: false,
                prompt: "",
                name: "setToOk",
                required: false,
                type: "boolean" },
            { description: "True if EditProperties action is allowed",
                hidden: false,
                prompt: "",
                name: "editProperties",
                required: false,
                type: "boolean" },
            { description: "True if EditJcl action is allowed",
                hidden: false,
                prompt: "",
                name: "editJcl",
                required: false,
                type: "boolean" },
        ],
        AllowedJobs: [
            { description: "list of including term Groups, combined by OR",
                hidden: false,
                prompt: "",
                name: "included",
                required: false,
                type: "Array<TermGroup>" },
            { description: "list of excluding term Groups, combined by OR",
                hidden: false,
                prompt: "",
                name: "excluded",
                required: false,
                type: "Array<TermGroup>" },
        ],
        App: [
            { description: "job type display name",
                hidden: false,
                prompt: "",
                name: "displayname",
                required: false,
                type: "string" },
            { description: "job type name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "description",
                hidden: false,
                prompt: "",
                name: "desc",
                required: false,
                type: "string" },
            { description: "default type",
                hidden: false,
                prompt: "",
                name: "defaultType",
                required: false,
                type: "string" },
            { description: "last modification date",
                hidden: false,
                prompt: "",
                name: "lastModified",
                required: false,
                type: "string" },
            { description: "creation date",
                hidden: false,
                prompt: "",
                name: "createdOn",
                required: false,
                type: "string" },
            { description: "creation author",
                hidden: false,
                prompt: "",
                name: "createdBy",
                required: false,
                type: "string" },
        ],
        AppDeployResponse: [
            { description: "status",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
            { description: "message",
                hidden: false,
                prompt: "",
                name: "message",
                required: false,
                type: "string" },
            { description: "agent name",
                hidden: false,
                prompt: "",
                name: "agentName",
                required: false,
                type: "string" },
        ],
        AppDeployed: [
            { description: "job type display name",
                hidden: false,
                prompt: "",
                name: "displayname",
                required: false,
                type: "string" },
            { description: "job type name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "version",
                hidden: false,
                prompt: "",
                name: "version",
                required: false,
                type: "string" },
            { description: "default type",
                hidden: false,
                prompt: "",
                name: "defaultType",
                required: false,
                type: "string" },
            { description: "last deployment date",
                hidden: false,
                prompt: "",
                name: "lastDeployed",
                required: false,
                type: "string" },
            { description: "creation date",
                hidden: false,
                prompt: "",
                name: "createdOn",
                required: false,
                type: "string" },
            { description: "creation author",
                hidden: false,
                prompt: "",
                name: "createdBy",
                required: false,
                type: "string" },
        ],
        AppList: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "appNames",
                required: false,
                type: "Array<App>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "deployedNames",
                required: false,
                type: "Array<AppDeployed>" },
        ],
        AppPredeployResponse: [
            { description: "app name",
                hidden: false,
                prompt: "",
                name: "appName",
                required: false,
                type: "string" },
            { description: "ready status",
                hidden: false,
                prompt: "",
                name: "readyStatus",
                required: false,
                type: "string" },
        ],
        ArchiveJobsList: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "jobs",
                required: false,
                type: "Array<Job>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "returned",
                required: false,
                type: "number" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "additionalJobsMatchSearchCriteria",
                required: false,
                type: "boolean" },
        ],
        ArchiveRule: [
            { description: "The Control-M Workload Archiving rule name. REQUIRED. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "The description of Control-M Workload Archiving rule. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
            { description: "The maximum job&#39;s output size to collect. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "maxOutputSize",
                required: false,
                type: "string" },
            { description: "The maximum job&#39;s output size type to collect - KB or MB. The default is MB. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "maxOutputSizeType",
                required: false,
                type: "string" },
            { description: "Trim in case the output exceed the maximum job&#39;s output - Omit , Beginning, End. The default is to Omit. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "trimType",
                required: false,
                type: "string" },
            { description: "The retention period to keep archive job by rule. The default is 1. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "retention",
                required: false,
                type: "string" },
            { description: "The retention period type to keep archive job by rule- Years, Months and Days are available. The default is Years. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "retentionType",
                required: false,
                type: "string" },
            { description: "Is Control-M Workload Archiving rule is active. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "isActive",
                required: false,
                type: "string" },
            { description: "The rule archived data - logs, output or both. The default is both. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "archivedType",
                required: false,
                type: "string" },
            { description: "Rule parameters - ctm, type, jobName, jobType, application, subApplication, jobStatus, folder and library. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "ruleParameters",
                required: false,
                type: "Array<RuleCriteria>" },
        ],
        ArchiveRulesList: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "rules",
                required: false,
                type: "Array<ArchiveRule>" },
        ],
        As2KeyData: [
            { description: "as2 id HIDDEN",
                hidden: false,
                prompt: "",
                name: "as2Id",
                required: false,
                type: "string" },
            { description: "partners certificate alias HIDDEN",
                hidden: false,
                prompt: "",
                name: "certificate",
                required: false,
                type: "string" },
            { description: "AS2 destination folder HIDDEN",
                hidden: false,
                prompt: "",
                name: "destinationFolder",
                required: false,
                type: "string" },
        ],
        AssociateData: [
            { description: "associate typed REQUIRED",
                hidden: false,
                prompt: "",
                name: "type",
                required: false,
                type: "string" },
            { description: "associate name REQUIRED",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
        ],
        AuthenticationData: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "controlM",
                required: false,
                type: "ControlMAuthenticationData" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "externalProvider",
                required: false,
                type: "ExternalProviderAuthenticationData" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "identityProvider",
                required: false,
                type: "IdentityProviderData" },
        ],
        CPMngAuth: [
            { description: "control-M server name",
                hidden: false,
                prompt: "",
                name: "controlmServer",
                required: false,
                type: "string" },
            { description: "agent name",
                hidden: false,
                prompt: "",
                name: "agent",
                required: false,
                type: "string" },
            { description: "plugin type",
                hidden: false,
                prompt: "",
                name: "pluginType",
                required: false,
                type: "string" },
            { description: "connection profile name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "access level (full, update, browse)",
                hidden: false,
                prompt: "",
                name: "privilege",
                required: false,
                type: "string" },
        ],
        CTMNameValueSW: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "cTMAttrName",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "cTMAttrValue",
                required: false,
                type: "string" },
        ],
        CertificateSigningRequestData: [
            { description: "The organization HIDDEN",
                hidden: false,
                prompt: "",
                name: "organization",
                required: false,
                type: "string" },
            { description: "The organizationUnit HIDDEN",
                hidden: false,
                prompt: "",
                name: "organizationUnit",
                required: false,
                type: "string" },
            { description: "The cityLocality HIDDEN",
                hidden: false,
                prompt: "",
                name: "cityLocality",
                required: false,
                type: "string" },
            { description: "The stateProvince HIDDEN",
                hidden: false,
                prompt: "",
                name: "stateProvince",
                required: false,
                type: "string" },
            { description: "The country HIDDEN",
                hidden: false,
                prompt: "",
                name: "country",
                required: false,
                type: "string" },
            { description: "The emailAddress HIDDEN",
                hidden: false,
                prompt: "",
                name: "emailAddress",
                required: false,
                type: "string" },
        ],
        ClientAccessPrivilegeCategory: [
            { description: "Control-M Self Service access level (None, Full)",
                hidden: false,
                prompt: "",
                name: "selfServiceAccess",
                required: false,
                type: "string" },
            { description: "Control-M Workload Change Manager access level (None, Full)",
                hidden: false,
                prompt: "",
                name: "workloadChangeManagerAccess",
                required: false,
                type: "string" },
            { description: "Control-M, Utilitiesm EM API, BIM Web, UI access level (None, Full)",
                hidden: false,
                prompt: "",
                name: "utilitiesAccess",
                required: false,
                type: "string" },
            { description: "Control-M Application Integrator access level (None, Full)",
                hidden: false,
                prompt: "",
                name: "applicationIntegratorAccess",
                required: false,
                type: "string" },
            { description: "Control-M Automation API access level (None, Full)",
                hidden: false,
                prompt: "",
                name: "automationAPIAccess",
                required: false,
                type: "string" },
        ],
        ComponentKeyWithStatusType: [
            { description: "MFT component details",
                hidden: false,
                prompt: "",
                name: "componentKey",
                required: false,
                type: "ComponentMftKeyType" },
            { description: "Component status",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "number" },
        ],
        ComponentMetaDataProperties: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "displayName",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "displayNameID",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "sections",
                required: false,
                type: "Array<SectionMetadataProperties>" },
        ],
        ComponentMftKeyType: [
            { description: "type",
                hidden: false,
                prompt: "",
                name: "type",
                required: false,
                type: "string" },
            { description: "name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "host",
                hidden: false,
                prompt: "",
                name: "host",
                required: false,
                type: "string" },
            { description: "node id",
                hidden: false,
                prompt: "",
                name: "nodeId",
                required: false,
                type: "string" },
            { description: "application type",
                hidden: false,
                prompt: "",
                name: "applType",
                required: false,
                type: "string" },
            { description: "application version",
                hidden: false,
                prompt: "",
                name: "applVer",
                required: false,
                type: "string" },
            { description: "cm version",
                hidden: false,
                prompt: "",
                name: "cmVer",
                required: false,
                type: "string" },
        ],
        ConditionProperties: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "key",
                required: false,
                type: "SettingKeyProperties" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "operator",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "value",
                required: false,
                type: "string" },
        ],
        ConfigurationManagerPrivilegeCategory: [
            { description: "Authorization access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "authorization",
                required: false,
                type: "string" },
            { description: "Control-M Configuration Manager access level (None, Full)",
                hidden: false,
                prompt: "",
                name: "configurationManagerAccess",
                required: false,
                type: "string" },
            { description: "Configuration access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "configuration",
                required: false,
                type: "string" },
            { description: "Operation access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "operation",
                required: false,
                type: "string" },
            { description: "Database Maintenance access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "database",
                required: false,
                type: "string" },
            { description: "Security access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "controlmSecurity",
                required: false,
                type: "string" },
        ],
        ConnectionProfileDeploymentInfo: [
            { description: "The logical name of Control-M/Server",
                hidden: false,
                prompt: "",
                name: "ctmName",
                required: false,
                type: "string" },
            { description: "The deployment status of connection profile",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
            { description: "The deployment status code of connection profile",
                hidden: false,
                prompt: "",
                name: "statusCode",
                required: false,
                type: "number" },
            { description: "UTC date of the modification",
                hidden: false,
                prompt: "",
                name: "lastUpdate",
                required: false,
                type: "string" },
            { description: "Status information",
                hidden: false,
                prompt: "",
                name: "message",
                required: false,
                type: "string" },
        ],
        ConnectionProfileStatus: [
            { description: "connection profile name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "connection profile type",
                hidden: false,
                prompt: "",
                name: "type",
                required: false,
                type: "string" },
            { description: "connection profile description",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
            { description: "UTC date of the modification",
                hidden: false,
                prompt: "",
                name: "timeModified",
                required: false,
                type: "string" },
            { description: "UTC date of the creation",
                hidden: false,
                prompt: "",
                name: "timeCreated",
                required: false,
                type: "string" },
            { description: "creator&#39;s name",
                hidden: false,
                prompt: "",
                name: "creatorName",
                required: false,
                type: "string" },
            { description: "modifier&#39;s name",
                hidden: false,
                prompt: "",
                name: "modifierName",
                required: false,
                type: "string" },
            { description: "Status calculated by the server according to the list of statuses with each server",
                hidden: false,
                prompt: "",
                name: "syncStatus",
                required: false,
                type: "string" },
        ],
        ConnectionProfilesDeploymentStatusResult: [
            { description: "Deployment status calculated by the server according to the list of statuses with each Control-M/Server",
                hidden: false,
                prompt: "",
                name: "deploymentStatus",
                required: false,
                type: "string" },
            { description: "The detailed deployment status per Control-M/Server",
                hidden: false,
                prompt: "",
                name: "deploymentInfo",
                required: false,
                type: "Array<ConnectionProfileDeploymentInfo>" },
        ],
        ConnectionProfilesStatusResult: [
            { description: "The list of statuses tracked by the given runId.",
                hidden: false,
                prompt: "",
                name: "statuses",
                required: false,
                type: "Array<ConnectionProfileStatus>" },
            { description: "The number of the return items by the search.",
                hidden: false,
                prompt: "",
                name: "returned",
                required: false,
                type: "number" },
            { description: "The total number of items.",
                hidden: false,
                prompt: "",
                name: "total",
                required: false,
                type: "number" },
        ],
        ControlMAuthenticationData: [
            { description: "password or secret",
                hidden: false,
                prompt: "",
                name: "password",
                required: false,
                type: "string" },
            { description: "number of days until the password expires",
                hidden: false,
                prompt: "",
                name: "passwordExpirationDays",
                required: false,
                type: "number" },
            { description: "should password be changed in next login",
                hidden: false,
                prompt: "",
                name: "changePasswordAtNextLogin",
                required: false,
                type: "boolean" },
            { description: "lock account",
                hidden: false,
                prompt: "",
                name: "lockAccount",
                required: false,
                type: "boolean" },
        ],
        CtmDetails: [
            { description: "The unique name of the Control-M Server.",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "The hostname of the Control-M Server is running on.",
                hidden: false,
                prompt: "",
                name: "host",
                required: false,
                type: "string" },
            { description: "Control-M Server state [up|down].",
                hidden: false,
                prompt: "",
                name: "state",
                required: false,
                type: "string" },
            { description: "Control-M Server message describing the communication status.",
                hidden: false,
                prompt: "",
                name: "message",
                required: false,
                type: "string" },
            { description: "Control-M Server version.",
                hidden: false,
                prompt: "",
                name: "version",
                required: false,
                type: "string" },
        ],
        CtmDetailsList: [],
        DeploymentFileError: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "lines",
                required: false,
                type: "Array<string>" },
        ],
        DeploymentFileResults: [
            { description: "The name of a specific deployment file.",
                hidden: false,
                prompt: "",
                name: "deploymentFile",
                required: false,
                type: "string" },
            { description: "Determines the number of successfully deployed simple folders.",
                hidden: false,
                prompt: "",
                name: "successfulFoldersCount",
                required: false,
                type: "number" },
            { description: "Determines the number of successfully deployed smart folders.",
                hidden: false,
                prompt: "",
                name: "successfulSmartFoldersCount",
                required: false,
                type: "number" },
            { description: "Determines the number of successfully deployed sub folders.",
                hidden: false,
                prompt: "",
                name: "successfulSubFoldersCount",
                required: false,
                type: "number" },
            { description: "Determines the number of successfully deployed sub folders.",
                hidden: false,
                prompt: "",
                name: "successfulJobsCount",
                required: false,
                type: "number" },
            { description: "Determines the number of successfully deployed sub folders.",
                hidden: false,
                prompt: "",
                name: "successfulConnectionProfilesCount",
                required: false,
                type: "number" },
            { description: "Determines the number of successfully deployed sub folders.",
                hidden: false,
                prompt: "",
                name: "successfulDriversCount",
                required: false,
                type: "number" },
            { description: "Determines if the deployment file is a valid deploy descriptor file.",
                hidden: false,
                prompt: "",
                name: "isDeployDescriptorValid",
                required: false,
                type: "boolean" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "deployedFolders",
                required: false,
                type: "Array<string>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "deployedJobs",
                required: false,
                type: "Array<string>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "deployedDrivers",
                required: false,
                type: "Array<string>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "deployedConnectionProfiles",
                required: false,
                type: "Array<string>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "errors",
                required: false,
                type: "Array<DeploymentFileError>" },
        ],
        EMSystemParameter: [
            { description: "EM System parameter",
                hidden: false,
                prompt: "",
                name: "value",
                required: false,
                type: "string" },
        ],
        EncryptionMetadata: [
            { description: "The type of encryption algorithm to be used to de/encrypt the fields (AES256 or Blowfish)",
                hidden: false,
                prompt: "",
                name: "encryptionType",
                required: false,
                type: "string" },
            { description: "The list of XML tag names identifying the fields to be de/encrypted in the request XML",
                hidden: false,
                prompt: "",
                name: "fieldsToEncrypt",
                required: false,
                type: "Array<string>" },
        ],
        ErrorData: [
            { description: "The error message that describes the problem.",
                hidden: false,
                prompt: "",
                name: "message",
                required: false,
                type: "string" },
            { description: "An internal identifier of the error.",
                hidden: false,
                prompt: "",
                name: "id",
                required: false,
                type: "string" },
            { description: "Reference to the item this error is referring to.",
                hidden: false,
                prompt: "",
                name: "item",
                required: false,
                type: "string" },
            { description: "The file this error occurred in.",
                hidden: false,
                prompt: "",
                name: "file",
                required: false,
                type: "string" },
            { description: "The number of line in the file this error occurred in.",
                hidden: false,
                prompt: "",
                name: "line",
                required: false,
                type: "number" },
            { description: "The number of column in the file this error occurred in.",
                hidden: false,
                prompt: "",
                name: "col",
                required: false,
                type: "number" },
        ],
        ErrorList: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "errors",
                required: false,
                type: "Array<ErrorData>" },
        ],
        Event: [
            { description: "Event name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "Control-M Server hosting the event",
                hidden: false,
                prompt: "",
                name: "ctm",
                required: false,
                type: "string" },
            { description: "The event date, either date in format dd/mm/yy or a string \&quot;orderdate\&quot;",
                hidden: false,
                prompt: "",
                name: "date",
                required: false,
                type: "string" },
        ],
        EventParam: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "name",
                required: true,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "date",
                required: true,
                type: "string" },
        ],
        EventSet: [],
        ExternalProviderAuthenticationData: [
            { description: "ldap user and domain",
                hidden: false,
                prompt: "",
                name: "ldapUserAndDomain",
                required: false,
                type: "string" },
        ],
        ExternalUserData: [
            { description: "external user name REQUIRED:addExternalUser | HIDDEN",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "user email REQUIRED:addExternalUser | HIDDEN",
                hidden: false,
                prompt: "",
                name: "email",
                required: false,
                type: "string" },
            { description: "user&#39;s company REQUIRED:addExternalUser | HIDDEN",
                hidden: false,
                prompt: "",
                name: "company",
                required: false,
                type: "string" },
            { description: "user password HIDDEN:updateExternalUser",
                hidden: false,
                prompt: "Password VALIDATE",
                name: "password",
                required: false,
                type: "string" },
            { description: "user description HIDDEN",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
            { description: "external user phone number HIDDEN",
                hidden: false,
                prompt: "",
                name: "phoneNumber",
                required: false,
                type: "string" },
            { description: "SSH key string HIDDEN",
                hidden: false,
                prompt: "",
                name: "sshKey",
                required: false,
                type: "string" },
            { description: "AS2 key string HIDDEN",
                hidden: false,
                prompt: "",
                name: "as2Key",
                required: false,
                type: "As2KeyData" },
        ],
        FieldMetadataProperties: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "controlType",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "dataType",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "displayName",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "displayNameID",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "falseValue",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "hashedPassword",
                required: false,
                type: "boolean" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "hideIf",
                required: false,
                type: "ConditionProperties" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "key",
                required: false,
                type: "SettingKeyProperties" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "needRestart",
                required: false,
                type: "boolean" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "needRestartMessage",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "needRestartMessageID",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "placeholder",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "placeholderID",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "possibleValues",
                required: false,
                type: "Array<PossibleValueProperties>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "profiles",
                required: false,
                type: "Array<string>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "settingChangedEventTypes",
                required: false,
                type: "Array<string>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "showIf",
                required: false,
                type: "ConditionProperties" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "tooltip",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "tooltipID",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "trueValue",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "unitsLabel",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "unitsLabelID",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "validations",
                required: false,
                type: "ValidationProperties" },
        ],
        FieldValue: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "value",
                required: true,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
        ],
        FieldValues: [
            { description: "HIDDEN.",
                hidden: false,
                prompt: "",
                name: "values",
                required: true,
                type: "Values" },
        ],
        FolderAuth: [
            { description: "access level (Full, Update, Browse)",
                hidden: false,
                prompt: "",
                name: "privilege",
                required: false,
                type: "string" },
            { description: "control-M server name",
                hidden: false,
                prompt: "",
                name: "controlmServer",
                required: false,
                type: "string" },
            { description: "job application",
                hidden: false,
                prompt: "",
                name: "library",
                required: false,
                type: "string" },
            { description: "job sub application",
                hidden: false,
                prompt: "",
                name: "folder",
                required: false,
                type: "string" },
            { description: "Allow ordering",
                hidden: false,
                prompt: "",
                name: "order",
                required: false,
                type: "boolean" },
            { description: "HIDDEN",
                hidden: false,
                prompt: "",
                name: "jobs",
                required: false,
                type: "JobLevelAuth" },
        ],
        FolderProperties: [
            { description: "The name of the folder. REQUIRED:addMFTFolder | HIDDEN",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "Authorized Internal Users. HIDDEN",
                hidden: false,
                prompt: "",
                name: "allowedInternalUserNames",
                required: false,
                type: "Array<string>" },
            { description: "Authorized External Users And User Groups. HIDDEN",
                hidden: false,
                prompt: "",
                name: "allowedUserNames",
                required: false,
                type: "Array<string>" },
            { description: "Array of allowed group names. HIDDEN",
                hidden: false,
                prompt: "",
                name: "allowedGroupNames",
                required: false,
                type: "Array<string>" },
            { description: "Delete file after downloaded from incoming folder. HIDDEN",
                hidden: false,
                prompt: "",
                name: "deleteFilesAfterProcessing",
                required: false,
                type: "boolean" },
            { description: "Send email notification to external users when a new file arrives. HIDDEN",
                hidden: false,
                prompt: "",
                name: "notifyByEmailWhenFileArrived",
                required: false,
                type: "boolean" },
            { description: "Retention Time in hours. HIDDEN",
                hidden: false,
                prompt: "",
                name: "retentionHours",
                required: false,
                type: "number" },
            { description: "Size limit for folder (in Gigabyte). HIDDEN",
                hidden: false,
                prompt: "",
                name: "sizeLimit",
                required: false,
                type: "number" },
            { description: "allowed file pattern wildcard. HIDDEN",
                hidden: false,
                prompt: "",
                name: "allowedFilePattern",
                required: false,
                type: "string" },
            { description: "blocked file pattern wildcard. HIDDEN",
                hidden: false,
                prompt: "",
                name: "excludeFilePattern",
                required: false,
                type: "string" },
        ],
        FolderPropertiesData: [
            { description: "The name of the folder. REQUIRED:addMFTFolder | HIDDEN",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "Authorized Internal Users. HIDDEN",
                hidden: false,
                prompt: "",
                name: "authorizedInternalUsers",
                required: false,
                type: "Array<string>" },
            { description: "Authorized External Users And User Groups. HIDDEN",
                hidden: false,
                prompt: "",
                name: "authorizedExternalUsersAndGroups",
                required: false,
                type: "Array<string>" },
            { description: "Delete file after downloaded from incoming folder. HIDDEN",
                hidden: false,
                prompt: "",
                name: "deleteFilesAfterDownload",
                required: false,
                type: "boolean" },
            { description: "Send email notification to external users when a new file arrives. HIDDEN",
                hidden: false,
                prompt: "",
                name: "notifyByEmailWhenFileArrive",
                required: false,
                type: "boolean" },
            { description: "Retention Time in hours. HIDDEN",
                hidden: false,
                prompt: "",
                name: "retentionPolicy",
                required: false,
                type: "number" },
            { description: "Size limit for folder (in Gigabyte). HIDDEN",
                hidden: false,
                prompt: "",
                name: "sizeLimit",
                required: false,
                type: "number" },
            { description: "allowed file pattern wildcard. HIDDEN",
                hidden: false,
                prompt: "",
                name: "allowedFilePattern",
                required: false,
                type: "string" },
            { description: "blocked file pattern wildcard. HIDDEN",
                hidden: false,
                prompt: "",
                name: "blockedFilePattern",
                required: false,
                type: "string" },
        ],
        FoldersUsersSettingsAndMetadataProperties: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "folders",
                required: false,
                type: "Array<FolderPropertiesData>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "settings",
                required: false,
                type: "Array<SettingProperties>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "settingsMetadata",
                required: false,
                type: "SettingsMetadataProperties" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "users",
                required: false,
                type: "Array<UserAllowedFoldersProperties>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "groups",
                required: false,
                type: "Array<GroupsAllowedFoldersProperties>" },
        ],
        FoldersUsersSettingsAndMetadataPropertiesFromB2B: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "folders",
                required: false,
                type: "Array<FolderProperties>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "settings",
                required: false,
                type: "Array<SettingProperties>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "settingsMetadata",
                required: false,
                type: "SettingsMetadataProperties" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "users",
                required: false,
                type: "Array<UserAllowedFoldersProperties>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "groups",
                required: false,
                type: "Array<GroupsAllowedFoldersProperties>" },
        ],
        GatewayData: [
            { description: "gateway host name REQUIRED",
                hidden: false,
                prompt: "",
                name: "host",
                required: false,
                type: "string" },
            { description: "gateway port REQUIRED",
                hidden: false,
                prompt: "",
                name: "port",
                required: false,
                type: "string" },
            { description: "gateway status HIDDEN",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
            { description: "general message HIDDEN",
                hidden: false,
                prompt: "",
                name: "message",
                required: false,
                type: "string" },
        ],
        GroupsAllowedFoldersProperties: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "allowedFoldersNames",
                required: false,
                type: "Array<string>" },
            { description: "external users",
                hidden: false,
                prompt: "",
                name: "externalUsers",
                required: false,
                type: "Array<string>" },
            { description: "ldap groups",
                hidden: false,
                prompt: "",
                name: "ldapGroups",
                required: false,
                type: "Array<string>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
        ],
        HostgroupAgentParticipation: [
            { description: "The event name.",
                hidden: false,
                prompt: "",
                name: "event",
                required: true,
                type: "string" },
            { description: "Odate dd-mm-yy or ******",
                hidden: false,
                prompt: "",
                name: "orderDate",
                required: false,
                type: "string" },
        ],
        HubData: [
            { description: "Hub state",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
            { description: "Hub sync status",
                hidden: false,
                prompt: "",
                name: "syncStatus",
                required: false,
                type: "string" },
            { description: "Agent name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "CPU",
                hidden: false,
                prompt: "",
                name: "cpu",
                required: false,
                type: "string" },
            { description: "memory usage",
                hidden: false,
                prompt: "",
                name: "memory",
                required: false,
                type: "string" },
            { description: "Hub Health Message",
                hidden: false,
                prompt: "",
                name: "message",
                required: false,
                type: "string" },
        ],
        HubStatus: [
            { description: "Hub status",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
        ],
        IdentityProviderData: [
            { description: "InternalIDP or ExternalIDP",
                hidden: false,
                prompt: "",
                name: "provider",
                required: false,
                type: "string" },
        ],
        JobLevelAuth: [
            { description: "access level (Full, Update, Browse)",
                hidden: false,
                prompt: "",
                name: "privilege",
                required: false,
                type: "string" },
            { description: "job application",
                hidden: false,
                prompt: "",
                name: "application",
                required: false,
                type: "string" },
            { description: "job sub application",
                hidden: false,
                prompt: "",
                name: "subApplication",
                required: false,
                type: "string" },
        ],
        JobRunStatus: [
            { description: "Order ID of the job.",
                hidden: false,
                prompt: "",
                name: "jobId",
                required: true,
                type: "string" },
            { description: "Order ID of the folder containing this job.",
                hidden: false,
                prompt: "",
                name: "folderId",
                required: false,
                type: "string" },
            { description: "The run number (in case of cyclic jobs or reruns)",
                hidden: false,
                prompt: "",
                name: "numberOfRuns",
                required: false,
                type: "number" },
            { description: "The name of the run job.",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "The name of the run job.",
                hidden: false,
                prompt: "",
                name: "folder",
                required: false,
                type: "string" },
            { description: "The type of the run job.",
                hidden: false,
                prompt: "",
                name: "type",
                required: false,
                type: "string" },
            { description: "The status of the run job.",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
            { description: "Is job held.",
                hidden: false,
                prompt: "",
                name: "held",
                required: false,
                type: "boolean" },
            { description: "Is job held.",
                hidden: false,
                prompt: "",
                name: "deleted",
                required: false,
                type: "boolean" },
            { description: "The start time of the job run.",
                hidden: false,
                prompt: "",
                name: "startTime",
                required: false,
                type: "string" },
            { description: "The end time of the job run.",
                hidden: false,
                prompt: "",
                name: "endTime",
                required: false,
                type: "string" },
            { description: "The estimated start time of the jobs.",
                hidden: false,
                prompt: "",
                name: "estimatedStartTime",
                required: false,
                type: "Array<string>" },
            { description: "The estimated end time of the jobs.",
                hidden: false,
                prompt: "",
                name: "estimatedEndTime",
                required: false,
                type: "Array<string>" },
            { description: "The order date.",
                hidden: false,
                prompt: "",
                name: "orderDate",
                required: false,
                type: "string" },
            { description: "The controlm server.",
                hidden: false,
                prompt: "",
                name: "ctm",
                required: false,
                type: "string" },
            { description: "The job description.",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
            { description: "host machine where the job runs.",
                hidden: false,
                prompt: "",
                name: "host",
                required: false,
                type: "string" },
            { description: "job application.",
                hidden: false,
                prompt: "",
                name: "application",
                required: false,
                type: "string" },
            { description: "job subApplication.",
                hidden: false,
                prompt: "",
                name: "subApplication",
                required: false,
                type: "string" },
            { description: "The JSON string that describes the job.",
                hidden: false,
                prompt: "",
                name: "jobJSON",
                required: false,
                type: "string" },
            { description: "A URI that can be used to get the output of the run job",
                hidden: false,
                prompt: "",
                name: "outputURI",
                required: false,
                type: "string" },
            { description: "A URI that can be used to get the log of the run job",
                hidden: false,
                prompt: "",
                name: "logURI",
                required: false,
                type: "string" },
        ],
        JobStatusResult: [
            { description: "The list of statuses tracked by the given runId.",
                hidden: false,
                prompt: "",
                name: "statuses",
                required: false,
                type: "Array<JobRunStatus>" },
            { description: "The index of the first item in the list.",
                hidden: false,
                prompt: "",
                name: "startIndex",
                required: false,
                type: "number" },
            { description: "The maximum number of items returned by each status request.",
                hidden: false,
                prompt: "",
                name: "itemsPerPage",
                required: false,
                type: "number" },
            { description: "The number of the return items by the search.",
                hidden: false,
                prompt: "",
                name: "returned",
                required: false,
                type: "number" },
            { description: "The total number of items.",
                hidden: false,
                prompt: "",
                name: "total",
                required: false,
                type: "number" },
            { description: "The field the list is sorted by.",
                hidden: false,
                prompt: "",
                name: "sort",
                required: false,
                type: "string" },
            { description: "URI to get the next items in the list, if any.",
                hidden: false,
                prompt: "",
                name: "nextURI",
                required: false,
                type: "string" },
            { description: "URI to get the previous items in the list, if any.",
                hidden: false,
                prompt: "",
                name: "prevURI",
                required: false,
                type: "string" },
            { description: "A URI to a page displaying the workflow run live.",
                hidden: false,
                prompt: "",
                name: "monitorPageURI",
                required: false,
                type: "string" },
        ],
        KeyValue: [
            { description: "Unique key",
                hidden: false,
                prompt: "",
                name: "name",
                required: true,
                type: "string" },
            { description: "Any value in string form.",
                hidden: false,
                prompt: "",
                name: "value",
                required: true,
                type: "string" },
            { description: "The default value if exist.",
                hidden: false,
                prompt: "",
                name: "defaultValue",
                required: false,
                type: "string" },
        ],
        KeyValueListResult: [],
        KeyValueType: [
            { description: "Unique key",
                hidden: false,
                prompt: "",
                name: "name",
                required: true,
                type: "string" },
            { description: "Any value in string form.",
                hidden: false,
                prompt: "",
                name: "value",
                required: true,
                type: "string" },
            { description: "The default value if exist.",
                hidden: false,
                prompt: "",
                name: "defaultValue",
                required: false,
                type: "string" },
            { description: "the type of the request.",
                hidden: false,
                prompt: "",
                name: "type",
                required: false,
                type: "string" },
        ],
        KeyValueTypeListResult: [],
        Log: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "log",
                required: false,
                type: "string" },
        ],
        LogParams: [
            { description: "The name of the Control-M server in which the job was ordered from. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "ctm",
                required: false,
                type: "string" },
            { description: "Job&#39;s order id. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "orderId",
                required: false,
                type: "string" },
            { description: "Job&#39;s rerun number. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "numberOfRuns",
                required: false,
                type: "number" },
            { description: "Job&#39;s log table name, accepted as a value in search request. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "logTable",
                required: false,
                type: "string" },
        ],
        LoginCredentials: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "username",
                required: true,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "password",
                required: true,
                type: "string" },
        ],
        LoginResult: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "username",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "token",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "version",
                required: false,
                type: "string" },
        ],
        Matching: [],
        MonitoringPrivilegeCategory: [
            { description: "Alerts access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "alert",
                required: false,
                type: "string" },
            { description: "Archived Viewpoints access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "viewpointArchive",
                required: false,
                type: "string" },
        ],
        NewSample: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "title",
                required: true,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
        ],
        OrderFolderParameters: [
            { description: "The Control-M Server to order from. REQUIRED.",
                hidden: false,
                prompt: "",
                name: "ctm",
                required: false,
                type: "string" },
            { description: "The folder to order. REQUIRED.",
                hidden: false,
                prompt: "",
                name: "folder",
                required: false,
                type: "string" },
            { description: "Filter the jobs to order.",
                hidden: false,
                prompt: "",
                name: "jobs",
                required: false,
                type: "string" },
            { description: "The z/os library that contains the job (only for MF).",
                hidden: false,
                prompt: "",
                name: "library",
                required: false,
                type: "string" },
            { description: "Is it allowed to order the same jobs more than once to the same SMART folder. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "createDuplicate",
                required: false,
                type: "boolean" },
            { description: "Are jobs ordered in a HOLD state. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "hold",
                required: false,
                type: "boolean" },
            { description: "Is scheduling criteria to be ignored. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "ignoreCriteria",
                required: false,
                type: "boolean" },
            { description: "Whether to generate new flow in this order. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "independentFlow",
                required: false,
                type: "boolean" },
            { description: "The order date that is attached to this order command. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "orderDate",
                required: false,
                type: "string" },
            { description: "Policy for placing the jobs in a SMART folder. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "orderIntoFolder",
                required: false,
                type: "string" },
            { description: "Whether to wait for the order date when running the jobs. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "waitForOrderDate",
                required: false,
                type: "boolean" },
            { description: "Job Variables for this run. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "variables",
                required: false,
                type: "Array<{ [key: string]: string; }>" },
        ],
        Output: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "output",
                required: false,
                type: "string" },
        ],
        OutputParams: [
            { description: "The name of the Control-M server in which the job was ordered from. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "ctm",
                required: false,
                type: "string" },
            { description: "Job&#39;s order id. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "orderId",
                required: false,
                type: "string" },
            { description: "Job&#39;s rerun number. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "numberOfRuns",
                required: false,
                type: "number" },
            { description: "Job&#39;s output table name, accepted as a value in search request. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "outputTable",
                required: false,
                type: "string" },
        ],
        PasswordsObject: [
            { description: "user name HIDDEN",
                hidden: false,
                prompt: "",
                name: "user",
                required: false,
                type: "string" },
            { description: "current password",
                hidden: false,
                prompt: "Current password",
                name: "currentPassword",
                required: false,
                type: "string" },
            { description: "new password",
                hidden: false,
                prompt: "New password",
                name: "newPassword",
                required: false,
                type: "string" },
        ],
        PingAgentParams: [
            { description: "Discover parameter when true the agent will be added to the Control-M. HIDDEN",
                hidden: false,
                prompt: "",
                name: "discover",
                required: true,
                type: "boolean" },
            { description: "maximum time in seconds to wait (default 60). HIDDEN",
                hidden: false,
                prompt: "",
                name: "timeout",
                required: true,
                type: "number" },
        ],
        PlanningPrivilegeCategory: [
            { description: "Periodical Statistics access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "periodicalStatistics",
                required: false,
                type: "string" },
            { description: "Forecast/BIM Configuration access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "forecastOrBatchImpactManagerConfig",
                required: false,
                type: "string" },
            { description: "Promotion Rules access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "promotionRules",
                required: false,
                type: "string" },
            { description: "Promote Action access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "promoteAction",
                required: false,
                type: "string" },
        ],
        PluginData: [
            { description: "The application type",
                hidden: false,
                prompt: "",
                name: "applicationType",
                required: false,
                type: "string" },
            { description: "The application version",
                hidden: false,
                prompt: "",
                name: "applicationVersion",
                required: false,
                type: "string" },
            { description: "The plugin version",
                hidden: false,
                prompt: "",
                name: "pluginVersion",
                required: false,
                type: "string" },
            { description: "The version",
                hidden: false,
                prompt: "",
                name: "version",
                required: false,
                type: "string" },
            { description: "The current state",
                hidden: false,
                prompt: "",
                name: "currentState",
                required: false,
                type: "string" },
            { description: "The status",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
            { description: "The status message",
                hidden: false,
                prompt: "",
                name: "statusMessage",
                required: false,
                type: "string" },
            { description: "The last update",
                hidden: false,
                prompt: "",
                name: "lastUpdate",
                required: false,
                type: "string" },
            { description: "The B2B activated indication",
                hidden: false,
                prompt: "",
                name: "b2bActivated",
                required: false,
                type: "string" },
        ],
        PluginMngAuth: [
            { description: "control-M server name",
                hidden: false,
                prompt: "",
                name: "controlmServer",
                required: false,
                type: "string" },
            { description: "agent name",
                hidden: false,
                prompt: "",
                name: "agent",
                required: false,
                type: "string" },
            { description: "plugin type",
                hidden: false,
                prompt: "",
                name: "pluginType",
                required: false,
                type: "string" },
            { description: "access level (full, update, browse)",
                hidden: false,
                prompt: "",
                name: "privilege",
                required: false,
                type: "string" },
        ],
        PossibleValueProperties: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "label",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "labelID",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "value",
                required: false,
                type: "string" },
        ],
        PrivilegeName: [
            { description: "access level (none, full, update, browse)",
                hidden: false,
                prompt: "",
                name: "privilege",
                required: false,
                type: "string" },
            { description: "pattern value",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
        ],
        PrivilegeNameControlm: [
            { description: "access level (Full, Update, Browse)",
                hidden: false,
                prompt: "",
                name: "privilege",
                required: false,
                type: "string" },
            { description: "control-M server name",
                hidden: false,
                prompt: "",
                name: "controlmServer",
                required: false,
                type: "string" },
            { description: "property name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
        ],
        Privileges: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "clientAccess",
                required: false,
                type: "ClientAccessPrivilegeCategory" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "configurationManager",
                required: false,
                type: "ConfigurationManagerPrivilegeCategory" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "monitoring",
                required: false,
                type: "MonitoringPrivilegeCategory" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "planning",
                required: false,
                type: "PlanningPrivilegeCategory" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "tools",
                required: false,
                type: "ToolsPrivilegeCategory" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "viewpointManager",
                required: false,
                type: "ViewpointManagerPrivilegeCategory" },
        ],
        ProvisionAdvanceParameters: [
            { description: "Which component is allowed to initiate the connection [ServerToAgent | AgentToServer | BothAllowed]. Parameters start with capital letter.  HIDDEN.",
                hidden: false,
                prompt: "",
                name: "connectionInitiator",
                required: false,
                type: "string" },
            { description: "Logical name that is used to label specific Control-M/Agents into a group with a specific authorization level.  HIDDEN.",
                hidden: false,
                prompt: "",
                name: "tag",
                required: false,
                type: "string" },
        ],
        RawCmsXmlRequest: [
            { description: "The raw XML request string",
                hidden: false,
                prompt: "",
                name: "rawXmlRequest",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "encryptionMetadata",
                required: false,
                type: "EncryptionMetadata" },
        ],
        ReportDateTimeSettings: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "dateFormat",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "timeFormat",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "dateTimeFormat",
                required: false,
                type: "string" },
        ],
        ReportFilter: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "name",
                required: true,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "value",
                required: true,
                type: "string" },
        ],
        ReportFilters: [],
        ReportResult: [
            { description: "A URL to the report.",
                hidden: false,
                prompt: "",
                name: "reportURL",
                required: true,
                type: "string" },
        ],
        ResourceMax: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "max",
                required: true,
                type: "number" },
        ],
        ResourceObj: [
            { description: "Resource name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "Control-M Server hosting the resource",
                hidden: false,
                prompt: "",
                name: "ctm",
                required: false,
                type: "string" },
            { description: "The resource q current quantity.",
                hidden: false,
                prompt: "",
                name: "available",
                required: false,
                type: "string" },
            { description: "The resource q max usage value.",
                hidden: false,
                prompt: "",
                name: "max",
                required: false,
                type: "number" },
            { description: "Workload Policy.",
                hidden: false,
                prompt: "",
                name: "workloadPolicy",
                required: false,
                type: "string" },
        ],
        ResourceParam: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "name",
                required: true,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "max",
                required: true,
                type: "string" },
        ],
        ResourceSet: [],
        RoleData: [
            { description: "role name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "role description",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "allowedJobs",
                required: false,
                type: "AllowedJobs" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "allowedJobActions",
                required: false,
                type: "AllowedJobActions" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "privileges",
                required: false,
                type: "Privileges" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "folders",
                required: false,
                type: "Array<FolderAuth>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "calendars",
                required: false,
                type: "Array<PrivilegeNameControlm>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "runasUsers",
                required: false,
                type: "Array<RunasUserAuth>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "workloadPolicies",
                required: false,
                type: "Array<PrivilegeName>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "siteStandard",
                required: false,
                type: "Array<PrivilegeName>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "siteCustomization",
                required: false,
                type: "Array<PrivilegeName>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "services",
                required: false,
                type: "Array<ServiceAuth>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "events",
                required: false,
                type: "Array<PrivilegeNameControlm>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "mutexes",
                required: false,
                type: "Array<PrivilegeNameControlm>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "semaphores",
                required: false,
                type: "Array<PrivilegeNameControlm>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "globalEvents",
                required: false,
                type: "Array<PrivilegeName>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "agentManagement",
                required: false,
                type: "Array<AgentMngAuth>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "pluginManagement",
                required: false,
                type: "Array<PluginMngAuth>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "connectionProfileManagement",
                required: false,
                type: "Array<CPMngAuth>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "runasDefinitionManagement",
                required: false,
                type: "Array<RunasDefinitionAuth>" },
        ],
        RoleHeader: [
            { description: "role name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "role description",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
        ],
        RoleHeaderList: [],
        RuleCriteria: [
            { description: "Rule parameters fields can be one of the options - ctm, type, jobName, jobType, application, subApplication, jobStatus, folder and library. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "field",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "criteria",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "exceptions",
                required: false,
                type: "Array<string>" },
        ],
        RuleProjection: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "lastUpdatedTimestamp",
                required: false,
                type: "number" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "priority",
                required: false,
                type: "number" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "searchTags",
                required: false,
                type: "Array<SearchTagTuple>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
        ],
        RuleStatistics: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "ruleName",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "retention",
                required: false,
                type: "number" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "retentionType",
                required: false,
                type: "RuleStatistics.RuleStatistics.RetentionTypeEnum" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "oldestItem",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "newestItem",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "totalJobs",
                required: false,
                type: "number" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "dataSize",
                required: false,
                type: "string" },
        ],
        RulesStatisticList: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "ruleStatistics",
                required: false,
                type: "Array<RuleStatistics>" },
        ],
        RulesStatisticListSummary: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "rulesStatisticList",
                required: false,
                type: "RulesStatisticList" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "summary",
                required: false,
                type: "Summary" },
        ],
        RunAsUserData: [
            { description: "agent name, can ended by wildcard REQUIRED",
                hidden: false,
                prompt: "",
                name: "agent",
                required: false,
                type: "string" },
            { description: "user name REQUIRED",
                hidden: false,
                prompt: "",
                name: "user",
                required: false,
                type: "string" },
            { description: "Password",
                hidden: false,
                prompt: "Password VALIDATE",
                name: "password",
                required: false,
                type: "string" },
            { description: "HIDDEN",
                hidden: false,
                prompt: "",
                name: "key",
                required: false,
                type: "RunAsUserKeyData" },
        ],
        RunAsUserDetailsData: [
            { description: "Password",
                hidden: false,
                prompt: "Password VALIDATE",
                name: "password",
                required: false,
                type: "string" },
            { description: "HIDDEN",
                hidden: false,
                prompt: "",
                name: "key",
                required: false,
                type: "RunAsUserKeyData" },
        ],
        RunAsUserKeyData: [
            { description: "ssh key",
                hidden: false,
                prompt: "",
                name: "keyname",
                required: false,
                type: "string" },
            { description: "SSH key passphrase",
                hidden: false,
                prompt: "",
                name: "passphrase",
                required: false,
                type: "string" },
        ],
        RunAsUsersList: [],
        RunReport: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "name",
                required: true,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "format",
                required: false,
                type: "string" },
            { description: "HIDDEN.",
                hidden: false,
                prompt: "",
                name: "filters",
                required: false,
                type: "ReportFilters" },
            { description: "HIDDEN.",
                hidden: false,
                prompt: "",
                name: "dateTimeSettings",
                required: false,
                type: "ReportDateTimeSettings" },
        ],
        RunReportInfo: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "reportId",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "format",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "url",
                required: false,
                type: "string" },
        ],
        RunResult: [
            { description: "An ID that identifies running jobs and can be used to track their status.",
                hidden: false,
                prompt: "",
                name: "runId",
                required: true,
                type: "string" },
            { description: "A URI that can be used to get the status of the run jobs.",
                hidden: false,
                prompt: "",
                name: "statusURI",
                required: false,
                type: "string" },
            { description: "A URI to a page displaying the workflow run live.",
                hidden: false,
                prompt: "",
                name: "monitorPageURI",
                required: false,
                type: "string" },
        ],
        RunasDefinitionAuth: [
            { description: "control-M server name",
                hidden: false,
                prompt: "",
                name: "controlmServer",
                required: false,
                type: "string" },
            { description: "access level (full, update, browse)",
                hidden: false,
                prompt: "",
                name: "privilege",
                required: false,
                type: "string" },
        ],
        RunasUserAuth: [
            { description: "control-M server name",
                hidden: false,
                prompt: "",
                name: "controlmServer",
                required: false,
                type: "string" },
            { description: "runas user",
                hidden: false,
                prompt: "",
                name: "runasUser",
                required: false,
                type: "string" },
            { description: "HOst or host group value",
                hidden: false,
                prompt: "",
                name: "host",
                required: false,
                type: "string" },
        ],
        SLAService: [
            { description: "Service Name",
                hidden: false,
                prompt: "",
                name: "serviceName",
                required: false,
                type: "string" },
            { description: "Status Code",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
            { description: "Status Reason",
                hidden: false,
                prompt: "",
                name: "statusReason",
                required: false,
                type: "string" },
            { description: "Start Time",
                hidden: false,
                prompt: "",
                name: "startTime",
                required: false,
                type: "string" },
            { description: "End Time",
                hidden: false,
                prompt: "",
                name: "endTime",
                required: false,
                type: "string" },
            { description: "Due Time",
                hidden: false,
                prompt: "",
                name: "dueTime",
                required: false,
                type: "string" },
            { description: "Slack Time",
                hidden: false,
                prompt: "",
                name: "slackTime",
                required: false,
                type: "string" },
            { description: "Service Order DateTime",
                hidden: false,
                prompt: "",
                name: "serviceOrderDateTime",
                required: false,
                type: "string" },
            { description: "Control-M Order Date",
                hidden: false,
                prompt: "",
                name: "scheduledOrderDate",
                required: false,
                type: "string" },
            { description: "Service Key",
                hidden: false,
                prompt: "",
                name: "serviceJob",
                required: false,
                type: "string" },
            { description: "Service Control-M",
                hidden: false,
                prompt: "",
                name: "serviceControlM",
                required: false,
                type: "string" },
            { description: "Priority",
                hidden: false,
                prompt: "",
                name: "priority",
                required: false,
                type: "string" },
            { description: "User note",
                hidden: false,
                prompt: "",
                name: "note",
                required: false,
                type: "string" },
            { description: "Number of Jobs",
                hidden: false,
                prompt: "",
                name: "totalJobs",
                required: false,
                type: "string" },
            { description: "Jobs Completed",
                hidden: false,
                prompt: "",
                name: "jobsCompleted",
                required: false,
                type: "string" },
            { description: "Jobs without statistics",
                hidden: false,
                prompt: "",
                name: "jobsWithoutStatistics",
                required: false,
                type: "string" },
            { description: "Completion Percentage",
                hidden: false,
                prompt: "",
                name: "completionPercentage",
                required: false,
                type: "string" },
            { description: "Average Completion Time",
                hidden: false,
                prompt: "",
                name: "averageCompletionTime",
                required: false,
                type: "string" },
            { description: "Error details",
                hidden: false,
                prompt: "",
                name: "errors",
                required: false,
                type: "string" },
            { description: "Status By Jobs",
                hidden: false,
                prompt: "",
                name: "statusByJobs",
                required: false,
                type: "SLAServiceStatusByJobs" },
        ],
        SLAServiceStatusByJobs: [
            { description: "Executed",
                hidden: false,
                prompt: "",
                name: "executed",
                required: false,
                type: "string" },
            { description: "Wait Condition",
                hidden: false,
                prompt: "",
                name: "waitCondition",
                required: false,
                type: "string" },
            { description: "Wait Resource",
                hidden: false,
                prompt: "",
                name: "waitResource",
                required: false,
                type: "string" },
            { description: "Wait User",
                hidden: false,
                prompt: "",
                name: "waitUser",
                required: false,
                type: "string" },
            { description: "Wait Host",
                hidden: false,
                prompt: "",
                name: "waitHost",
                required: false,
                type: "string" },
            { description: "Wait Workload",
                hidden: false,
                prompt: "",
                name: "waitWorkload",
                required: false,
                type: "string" },
            { description: "Completed",
                hidden: false,
                prompt: "",
                name: "completed",
                required: false,
                type: "string" },
            { description: "Error",
                hidden: false,
                prompt: "",
                name: "error",
                required: false,
                type: "string" },
            { description: "Unkwown",
                hidden: false,
                prompt: "",
                name: "unknown",
                required: false,
                type: "string" },
        ],
        Sample: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "id",
                required: true,
                type: "number" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "title",
                required: true,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
        ],
        SamplesLoadData: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "contentType",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "filename",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "size",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "content",
                required: false,
                type: "string" },
        ],
        SearchParams: [
            { description: "The name of sthe Control-M server in which the job was ordered from. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "ctm",
                required: false,
                type: "string" },
            { description: "The name of the job. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "jobName",
                required: false,
                type: "string" },
            { description: "The name of the application the jobs belong to. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "app",
                required: false,
                type: "string" },
            { description: "The name of the sub-application the jobs belong to. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "subApp",
                required: false,
                type: "string" },
            { description: "The name of the parent folder. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "folder",
                required: false,
                type: "string" },
            { description: "The job&#39;s end status. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "SearchParams.SearchParams.StatusEnum" },
            { description: "The job&#39;s library name. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "lib",
                required: false,
                type: "string" },
            { description: "Maximum archived Jobs to display. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "limit",
                required: false,
                type: "number" },
            { description: "Job log must contain the given phrase. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "logContains",
                required: false,
                type: "string" },
            { description: "Job output must contain the given phrase. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "outputContains",
                required: false,
                type: "string" },
            { description: "Member&#39;s library. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "memLib",
                required: false,
                type: "string" },
            { description: "Member name. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "memName",
                required: false,
                type: "string" },
            { description: "Job&#39;s node group. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "nodeGroup",
                required: false,
                type: "string" },
            { description: "Job&#39;s node id (agent). HIDDEN.",
                hidden: false,
                prompt: "",
                name: "nodeId",
                required: false,
                type: "string" },
            { description: "Indicating a date by which will look for jobs that their order date started afterwards. Date format - YYYY-MM-DD. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "fromOrderDate",
                required: false,
                type: "string" },
            { description: "Indicating a date by which will look for jobs that their order date ended before. Date format - YYYY-MM-DD. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "toOrderDate",
                required: false,
                type: "string" },
            { description: "Job&#39;s order id. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "orderId",
                required: false,
                type: "string" },
            { description: "Runs as (username on agent machine). HIDDEN.",
                hidden: false,
                prompt: "",
                name: "runAs",
                required: false,
                type: "string" },
            { description: "Job execution start date. Date format - YYYY-MM-DD. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "startDate",
                required: false,
                type: "string" },
            { description: "Job execution end date. Date format - YYYY-MM-DD. HIDDEN.",
                hidden: false,
                prompt: "",
                name: "endDate",
                required: false,
                type: "string" },
        ],
        SearchTagTuple: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "key",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "values",
                required: false,
                type: "Array<string>" },
        ],
        SecretKeyValue: [
            { description: "Unique key",
                hidden: false,
                prompt: "",
                name: "name",
                required: true,
                type: "string" },
            { description: "Any value in string form.",
                hidden: false,
                prompt: "New secret value VALIDATE",
                name: "value",
                required: false,
                type: "string" },
        ],
        SecretValue: [
            { description: "The parameter value",
                hidden: false,
                prompt: "New secret value VALIDATE",
                name: "value",
                required: false,
                type: "string" },
        ],
        SectionMetadataProperties: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "displayName",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "displayName1",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "displayNameID",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "fields",
                required: false,
                type: "Array<FieldMetadataProperties>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
        ],
        ServiceAuth: [
            { description: "access level (Full, Update, Browse, None)",
                hidden: false,
                prompt: "",
                name: "privilege",
                required: false,
                type: "string" },
            { description: "service name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "active list",
                hidden: false,
                prompt: "",
                name: "allowedActions",
                required: false,
                type: "ServiceAuthAction" },
        ],
        ServiceAuthAction: [
            { description: "Is DrillDown allowed in service",
                hidden: false,
                prompt: "",
                name: "drillDown",
                required: false,
                type: "boolean" },
            { description: "Is Run allowed in service",
                hidden: false,
                prompt: "",
                name: "run",
                required: false,
                type: "boolean" },
            { description: "Is Hold allowed in service",
                hidden: false,
                prompt: "",
                name: "hold",
                required: false,
                type: "boolean" },
            { description: "Is Resume allowed in service",
                hidden: false,
                prompt: "",
                name: "resume",
                required: false,
                type: "boolean" },
            { description: "Is View Orderable Service allowed in service",
                hidden: false,
                prompt: "",
                name: "viewOrderableService",
                required: false,
                type: "boolean" },
        ],
        SetAgentParams: [
            { description: "parameter name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "parameter value",
                hidden: false,
                prompt: "",
                name: "value",
                required: false,
                type: "string" },
            { description: "parameter type",
                hidden: false,
                prompt: "",
                name: "type",
                required: false,
                type: "string" },
        ],
        SetAgentParamsList: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "parameters",
                required: false,
                type: "Array<SetAgentParams>" },
        ],
        SettingKeyProperties: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "settingCategory",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "settingName",
                required: false,
                type: "string" },
        ],
        SettingProperties: [
            { description: "setting category property HIDDEN",
                hidden: false,
                prompt: "",
                name: "category",
                required: false,
                type: "string" },
            { description: "setting name property HIDDEN",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "setting value property HIDDEN",
                hidden: false,
                prompt: "",
                name: "value",
                required: false,
                type: "string" },
        ],
        SettingPropertiesObject: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "settings",
                required: false,
                type: "Array<SettingProperties>" },
        ],
        SettingsMetadataProperties: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "components",
                required: false,
                type: "Array<ComponentMetaDataProperties>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "error",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "selectedComponentAfterActivation",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "selectedComponentBeforeActivation",
                required: false,
                type: "string" },
        ],
        SettingsUpdateObject: [
            { description: "Settings Properties Object",
                hidden: false,
                prompt: "",
                name: "settingsObj",
                required: false,
                type: "SettingPropertiesObject" },
            { description: "Component Mft key type",
                hidden: false,
                prompt: "",
                name: "compKeyType",
                required: false,
                type: "ComponentMftKeyType" },
        ],
        StringListResult: [],
        SuccessData: [
            { description: "The success message that describes the performed action.",
                hidden: false,
                prompt: "",
                name: "message",
                required: false,
                type: "string" },
        ],
        Summary: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "totalNumberOfJobs",
                required: false,
                type: "number" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "totalDataSize",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "actualDbSize",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "diskUsage",
                required: false,
                type: "string" },
        ],
        TermGroup: [],
        ToolsPrivilegeCategory: [
            { description: "CLI access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "cli",
                required: false,
                type: "string" },
            { description: "BIM Reports access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "batchImpactManagerReport",
                required: false,
                type: "string" },
            { description: "Forecast Reports access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "forecastReport",
                required: false,
                type: "string" },
        ],
        UpgradeAgentInfo: [
            { description: "Agent name.",
                hidden: false,
                prompt: "",
                name: "agent",
                required: false,
                type: "string" },
            { description: "Control-M name.",
                hidden: false,
                prompt: "",
                name: "ctm",
                required: false,
                type: "string" },
            { description: "Agent type (Agent, MFT, AppPack).",
                hidden: false,
                prompt: "",
                name: "type",
                required: false,
                type: "string" },
            { description: "Platform.",
                hidden: false,
                prompt: "",
                name: "platform",
                required: false,
                type: "string" },
            { description: "From version.",
                hidden: false,
                prompt: "",
                name: "fromVersion",
                required: false,
                type: "string" },
            { description: "To version.",
                hidden: false,
                prompt: "",
                name: "toVersion",
                required: false,
                type: "string" },
        ],
        UpgradeAgentInfoList: [],
        UpgradeInfo: [
            { description: "product type (Agent, MFT, AppPack).",
                hidden: false,
                prompt: "",
                name: "type",
                required: false,
                type: "string" },
            { description: "upgrade version",
                hidden: false,
                prompt: "",
                name: "version",
                required: false,
                type: "string" },
        ],
        UpgradeRecord: [
            { description: "upgrade id",
                hidden: false,
                prompt: "",
                name: "upgradeId",
                required: false,
                type: "string" },
            { description: "Control-M name",
                hidden: false,
                prompt: "",
                name: "ctm",
                required: false,
                type: "string" },
            { description: "agnet name",
                hidden: false,
                prompt: "",
                name: "agent",
                required: false,
                type: "string" },
            { description: "upgrade package type",
                hidden: false,
                prompt: "",
                name: "_package",
                required: false,
                type: "string" },
            { description: "upgrade from version",
                hidden: false,
                prompt: "",
                name: "fromVersion",
                required: false,
                type: "string" },
            { description: "upgrade to version",
                hidden: false,
                prompt: "",
                name: "toVersion",
                required: false,
                type: "string" },
            { description: "activity type (Transfer, Install, Rollback)",
                hidden: false,
                prompt: "",
                name: "activity",
                required: false,
                type: "string" },
            { description: "status tyoe (Cancel, Running Complete,TransferCompleted, Failed,Unavailable)",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
            { description: "massage",
                hidden: false,
                prompt: "",
                name: "message",
                required: false,
                type: "string" },
            { description: "creation time",
                hidden: false,
                prompt: "",
                name: "creationTime",
                required: false,
                type: "string" },
            { description: "transfer start time",
                hidden: false,
                prompt: "",
                name: "transferStartTime",
                required: false,
                type: "string" },
            { description: "transfer end time",
                hidden: false,
                prompt: "",
                name: "transferEndTime",
                required: false,
                type: "string" },
            { description: "installation start time",
                hidden: false,
                prompt: "",
                name: "installStartTime",
                required: false,
                type: "string" },
            { description: "installation end time",
                hidden: false,
                prompt: "",
                name: "installEndTime",
                required: false,
                type: "string" },
            { description: "activity name",
                hidden: false,
                prompt: "",
                name: "activityName",
                required: false,
                type: "string" },
            { description: "install user",
                hidden: false,
                prompt: "",
                name: "installUser",
                required: false,
                type: "string" },
            { description: "notify address",
                hidden: false,
                prompt: "",
                name: "notifyAddress",
                required: false,
                type: "string" },
            { description: "description",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
        ],
        UpgradeRecordList: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "upgradeRecords",
                required: false,
                type: "Array<UpgradeRecord>" },
        ],
        UpgradeRequest: [
            { description: "Control-M name. REQUIRED",
                hidden: false,
                prompt: "",
                name: "ctm",
                required: false,
                type: "string" },
            { description: "Agent name. REQUIRED",
                hidden: false,
                prompt: "",
                name: "agent",
                required: false,
                type: "string" },
            { description: "Product type (Agent, MFT, AppPack). REQUIRED",
                hidden: false,
                prompt: "",
                name: "type",
                required: false,
                type: "string" },
            { description: "Target version to be installed or version that should be rollback REQUIRED",
                hidden: false,
                prompt: "",
                name: "version",
                required: false,
                type: "string" },
            { description: "Name of activity",
                hidden: false,
                prompt: "",
                name: "activityName",
                required: false,
                type: "string" },
            { description: "User that will install, upgrade or uninstall HIDDEN",
                hidden: false,
                prompt: "",
                name: "installUser",
                required: false,
                type: "string" },
            { description: "List of email addresses separated by semicolon HIDDEN",
                hidden: false,
                prompt: "",
                name: "notifyAddress",
                required: false,
                type: "string" },
            { description: "Description of activity HIDDEN",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
        ],
        UpgradeResponse: [
            { description: "ID of upgrade activity",
                hidden: false,
                prompt: "",
                name: "upgradeId",
                required: false,
                type: "string" },
        ],
        UserAllowedFoldersProperties: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "allowedFoldersNames",
                required: false,
                type: "Array<string>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "as2CertificateAlias",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "as2Id",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "as2PublicKeyCertificate",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "as2TargetFolder",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "company",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "email",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "fullName",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "hashedPassword",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "isLdapAuth",
                required: false,
                type: "number" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "phoneNumber",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "sshPublicKey",
                required: false,
                type: "string" },
        ],
        UserData: [
            { description: "user name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "user description",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
            { description: "full user name",
                hidden: false,
                prompt: "",
                name: "fullName",
                required: false,
                type: "string" },
            { description: "user authentication",
                hidden: false,
                prompt: "",
                name: "authentication",
                required: false,
                type: "AuthenticationData" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "roles",
                required: false,
                type: "Array<string>" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "authorization",
                required: false,
                type: "RoleData" },
        ],
        UserGroupDetailsData: [
            { description: "external users HIDDEN",
                hidden: false,
                prompt: "",
                name: "externalUsers",
                required: false,
                type: "Array<string>" },
            { description: "ldap groups HIDDEN",
                hidden: false,
                prompt: "",
                name: "ldapGroups",
                required: false,
                type: "Array<string>" },
        ],
        UserGroupPropertiesData: [
            { description: "user group name REQUIRED",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "external users HIDDEN",
                hidden: false,
                prompt: "",
                name: "externalUsers",
                required: false,
                type: "Array<string>" },
            { description: "ldap groups HIDDEN",
                hidden: false,
                prompt: "",
                name: "ldapGroups",
                required: false,
                type: "Array<string>" },
        ],
        UserHeader: [
            { description: "user name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "full user name",
                hidden: false,
                prompt: "",
                name: "fullName",
                required: false,
                type: "string" },
            { description: "user description",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
            { description: "user status (output only)",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
            { description: "updated date (output only)",
                hidden: false,
                prompt: "",
                name: "lastUpdated",
                required: false,
                type: "string" },
            { description: "create date (output only)",
                hidden: false,
                prompt: "",
                name: "created",
                required: false,
                type: "string" },
            { description: "list of groups user belongs to",
                hidden: false,
                prompt: "",
                name: "memberOf",
                required: false,
                type: "Array<string>" },
        ],
        UserPassword: [
            { description: "new user password",
                hidden: false,
                prompt: "New password VALIDATE",
                name: "newPassword",
                required: false,
                type: "string" },
        ],
        UserPreferences: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "userPreferences",
                required: false,
                type: "Array<CTMNameValueSW>" },
        ],
        ValidationProperties: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "max",
                required: false,
                type: "number" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "min",
                required: false,
                type: "number" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "regexPattern",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "regexPatternJava",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "regexPatternJavaScript",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "regexPatternNoMatchMessage",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "regexPatternNoMatchMessageID",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "required",
                required: false,
                type: "boolean" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "requiredIf",
                required: false,
                type: "ConditionProperties" },
        ],
        Value: [
            { description: "The parameter value",
                hidden: false,
                prompt: "",
                name: "value",
                required: true,
                type: "string" },
        ],
        Values: [],
        ViewpointManagerPrivilegeCategory: [
            { description: "Collections access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "collections",
                required: false,
                type: "string" },
            { description: "Hierarchies access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "hierarchies",
                required: false,
                type: "string" },
            { description: "Filters access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "filters",
                required: false,
                type: "string" },
            { description: "Viewpoints access level (None, Browse, Update, Full)",
                hidden: false,
                prompt: "",
                name: "viewpoints",
                required: false,
                type: "string" },
        ],
        WorkloadPolicy: [
            { description: "unique workload policy name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "workload policy state",
                hidden: false,
                prompt: "",
                name: "state",
                required: false,
                type: "string" },
            { description: "workload policy order number",
                hidden: false,
                prompt: "",
                name: "orderNo",
                required: false,
                type: "string" },
            { description: "workload policy update date",
                hidden: false,
                prompt: "",
                name: "lastUpdate",
                required: false,
                type: "string" },
            { description: "user which updated workload policy",
                hidden: false,
                prompt: "",
                name: "updatedBy",
                required: false,
                type: "string" },
            { description: "workload policy description",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
        ],
        WorkloadPolicyList: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "workloadPolicies",
                required: false,
                type: "Array<WorkloadPolicy>" },
        ],
        WorkloadPolicyState: [
            { description: "unique workload policy name",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "workload policy state",
                hidden: false,
                prompt: "",
                name: "state",
                required: false,
                type: "string" },
        ],
        WorkloadPolicyStateList: [
            { description: "",
                hidden: false,
                prompt: "",
                name: "workloadPolicies",
                required: false,
                type: "Array<WorkloadPolicyState>" },
        ],
        ZooKeeper: [
            { description: "zookeeper Id",
                hidden: false,
                prompt: "",
                name: "zookeeperId",
                required: false,
                type: "number" },
            { description: "zookeeper Server Host",
                hidden: false,
                prompt: "",
                name: "zookeeperServerHost",
                required: false,
                type: "string" },
            { description: "zookeeper Admin Server Port",
                hidden: false,
                prompt: "",
                name: "zookeeperAdminServerPort",
                required: false,
                type: "number" },
            { description: "zookeeper Client Port",
                hidden: false,
                prompt: "",
                name: "zookeeperClientPort",
                required: false,
                type: "number" },
            { description: "zookeeper Leader Port",
                hidden: false,
                prompt: "",
                name: "zookeeperLeaderPort",
                required: false,
                type: "number" },
            { description: "zookeeper Leader Election Port",
                hidden: false,
                prompt: "",
                name: "zookeeperLeaderElectionPort",
                required: false,
                type: "number" },
        ],
        Job: [
            { description: "Order ID of the job.",
                hidden: false,
                prompt: "",
                name: "jobId",
                required: true,
                type: "string" },
            { description: "Order ID of the folder containing this job.",
                hidden: false,
                prompt: "",
                name: "folderId",
                required: false,
                type: "string" },
            { description: "The run number (in case of cyclic jobs or reruns)",
                hidden: false,
                prompt: "",
                name: "numberOfRuns",
                required: false,
                type: "number" },
            { description: "The name of the run job.",
                hidden: false,
                prompt: "",
                name: "name",
                required: false,
                type: "string" },
            { description: "The name of the run job.",
                hidden: false,
                prompt: "",
                name: "folder",
                required: false,
                type: "string" },
            { description: "The type of the run job.",
                hidden: false,
                prompt: "",
                name: "type",
                required: false,
                type: "string" },
            { description: "The status of the run job.",
                hidden: false,
                prompt: "",
                name: "status",
                required: false,
                type: "string" },
            { description: "Is job held.",
                hidden: false,
                prompt: "",
                name: "held",
                required: false,
                type: "boolean" },
            { description: "Is job held.",
                hidden: false,
                prompt: "",
                name: "deleted",
                required: false,
                type: "boolean" },
            { description: "The start time of the job run.",
                hidden: false,
                prompt: "",
                name: "startTime",
                required: false,
                type: "string" },
            { description: "The end time of the job run.",
                hidden: false,
                prompt: "",
                name: "endTime",
                required: false,
                type: "string" },
            { description: "The estimated start time of the jobs.",
                hidden: false,
                prompt: "",
                name: "estimatedStartTime",
                required: false,
                type: "Array<string>" },
            { description: "The estimated end time of the jobs.",
                hidden: false,
                prompt: "",
                name: "estimatedEndTime",
                required: false,
                type: "Array<string>" },
            { description: "The order date.",
                hidden: false,
                prompt: "",
                name: "orderDate",
                required: false,
                type: "string" },
            { description: "The controlm server.",
                hidden: false,
                prompt: "",
                name: "ctm",
                required: false,
                type: "string" },
            { description: "The job description.",
                hidden: false,
                prompt: "",
                name: "description",
                required: false,
                type: "string" },
            { description: "host machine where the job runs.",
                hidden: false,
                prompt: "",
                name: "host",
                required: false,
                type: "string" },
            { description: "job application.",
                hidden: false,
                prompt: "",
                name: "application",
                required: false,
                type: "string" },
            { description: "job subApplication.",
                hidden: false,
                prompt: "",
                name: "subApplication",
                required: false,
                type: "string" },
            { description: "The JSON string that describes the job.",
                hidden: false,
                prompt: "",
                name: "jobJSON",
                required: false,
                type: "string" },
            { description: "A URI that can be used to get the output of the run job",
                hidden: false,
                prompt: "",
                name: "outputURI",
                required: false,
                type: "string" },
            { description: "A URI that can be used to get the log of the run job",
                hidden: false,
                prompt: "",
                name: "logURI",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "duration",
                required: false,
                type: "number" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "runAs",
                required: false,
                type: "string" },
            { description: "",
                hidden: false,
                prompt: "",
                name: "archiveRule",
                required: false,
                type: "string" },
        ],
    };
    cli.category("samples").description(S("Manage data samples"));
    cli.category("run").description(S("Run and track Control-M jobs"));
    cli.category("config").description(S("Configure the Control-M environment"));
    cli.category("provision").description(S("Install a BigData agent on the current account"));
    cli.category("deploy").description(S("Submit definitions to Control-M"));
    cli.category("build").description(S("Compile definitions to verify they are valid for Control-M"));
    cli.category("reporting").description(S("Generate Control-M reports"));
    cli.category("archive").description(S("Control-M Workload Archiving operations"));
    cli.addCommand = function (category, name) {
        return cli.category(category).command(name);
    };
    cli.addOperation("ArchiveApi", "archive", "getArchiveJobLog", "/archive/{jobId}/log", "Get job log by unique job key", "", "GET", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
        new argData_1.ArgData("runNo", "number", true, "The execution number in case of multiple executions", false, "", false),
    ], "", "", "", "", false, "true", "", ["runNo"]);
    cli.addOperation("ArchiveApi", "archive", "getArchiveJobOutput", "/archive/{jobId}/output", "Get job output by unique job key", "", "GET", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
        new argData_1.ArgData("runNo", "number", true, "The execution number in case of multiple executions", false, "", false),
    ], "", "", "", "", false, "true", "", ["runNo"]);
    cli.addOperation("ArchiveApi", "archive", "searchJobs", "/archive/search", "Get all the Control-M Archiving jobs that match the search criterias", "", "GET", false, [new argData_1.ArgData("limit", "number", false, "maximum jobs to fetch (default 500).", false, "", false),
        new argData_1.ArgData("jobname", "string", false, "The name of the job.", true, "", false),
        new argData_1.ArgData("jobid", "string", false, "", true, "", false),
        new argData_1.ArgData("ctm", "string", false, "The name of the Control-M server in which the job was ordered from.", true, "", false),
        new argData_1.ArgData("folder", "string", false, "The name of the parent folder.", true, "", false),
        new argData_1.ArgData("fromTime", "string", false, "Job execution start date. Date format - YYYY-MM-DD.", true, "", false),
        new argData_1.ArgData("toTime", "string", false, "Job execution end date. Date format - YYYY-MM-DD.", true, "", false),
        new argData_1.ArgData("logContains", "string", false, "Job log must contain the given phrase.", true, "", false),
        new argData_1.ArgData("outputContains", "string", false, "Job output must contain the given phrase.", true, "", false),
        new argData_1.ArgData("application", "string", false, "The name of the application the jobs belong to.", true, "", false),
        new argData_1.ArgData("subApplication", "string", false, "The name of the sub-application the jobs belong to.", true, "", false),
        new argData_1.ArgData("library", "string", false, "The job&#39;s library name.", true, "", false),
        new argData_1.ArgData("memName", "string", false, "Member name.", true, "", false),
        new argData_1.ArgData("memLibrary", "string", false, "Member&#39;s library.", true, "", false),
        new argData_1.ArgData("host", "string", false, "", true, "", false),
        new argData_1.ArgData("hostGroup", "string", false, "Job&#39;s host group.", true, "", false),
        new argData_1.ArgData("runAs", "string", false, "Runs as (username on agent machine).", true, "", false),
        new argData_1.ArgData("orderId", "string", false, "Job&#39;s order id.", true, "", false),
        new argData_1.ArgData("status", "string", false, "The job&#39;s end status.", true, "", false),
        new argData_1.ArgData("orderDateFrom", "string", false, "Indicating a date by which will look for jobs that their order date started afterwards. Date format - YYYY-MM-DD.", true, "", false),
        new argData_1.ArgData("orderDateTo", "string", false, "Indicating a date by which will look for jobs that their order date ended before. Date format - YYYY-MM-DD.", true, "", false),
        new argData_1.ArgData("numberOfRuns", "number", false, "", true, "", false),
    ], "", "Search fields are jobname, jobid, ctm, folder, host, application, subApplication, status, orderId, orderDateFrom, orderDateTo, fromTime, toTime, folderLibrary, memName, memLibrary, hostGroup, runAs, logContains, outputContains and numberOfRuns.", "[-s &lt;search query&gt;]", "", false, "true", "", ["limit", "jobname", "jobid", "ctm", "folder", "fromTime", "toTime", "logContains", "outputContains", "application", "subApplication", "library", "memName", "memLibrary", "host", "hostGroup", "runAs", "orderId", "status", "orderDateFrom", "orderDateTo", "numberOfRuns"]);
    cli.addOperation("BuildApi", "build", "buildFile", "/build", "Compile the provided definition file (JSON or zip) to verify it is valid for Control-M.", "!", "POST", false, [new argData_1.ArgData("definitionsFile", "Buffer", true, "A file that contains definitions to be compiled. Can be either a JSON definition file, or a zip file that contains multiple JSON definition files.", false, "", false),
        new argData_1.ArgData("deployDescriptorFile", "Buffer", false, "Deploy Descriptor JSON file.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "activateHub", "/config/internal/mft/activatehub", "activate hub.", "activatehub", "POST", false, [new argData_1.ArgData("componentMftKeyType", "ComponentMftKeyType", true, "component properties", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "true", "true", []);
    cli.addOperation("ConfigApi", "config", "addAgent", "/config/server/{ctm}/agent", "Add an agent to Control-M Server. This command does not install or configure the agent. It only defines the agent in the system.", "", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the agent is going to be added to.", false, "", false),
        new argData_1.ArgData("body", "AddAgentParams", true, "", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "addArchiveRule", "/config/archive/rule", "Add a new Control-M Workload Archiving rule", "add", "POST", false, [new argData_1.ArgData("archiveRule", "ArchiveRule", true, "archive rule details to add", false, "", true),
    ], "", "", "-f &lt;configuration file&gt;", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "addExternalUser", "/config/mft/externaluser", "Add and external user for b2b", "", "POST", false, [new argData_1.ArgData("externalUserData", "ExternalUserData", true, "External user data", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "[-p]", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "addExternalUserOrUserGroupToMFTFolder", "/config/mft/virtualfolder/{folderName}/user/{userOrGroup}", "Add external user user groups to virtual folder external users list.", "", "POST", false, [new argData_1.ArgData("folderName", "string", true, "Name of folder", false, "", false),
        new argData_1.ArgData("userOrGroup", "string", true, "The user name or group name", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "addGateway", "/config/mft/gateway", "add gateway.", "", "POST", false, [new argData_1.ArgData("gatewayData", "GatewayData", true, "gateway data", false, "", true),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "addHostToHostgroup", "/config/server/{ctm}/hostgroup/{hostgroup}/agent", "Add an agent to hostgroup. Create the the hostgroup if it does not exist.", "", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the hostgroup belongs to.", false, "", false),
        new argData_1.ArgData("hostgroup", "string", true, "The hostgroup name", false, "", false),
        new argData_1.ArgData("agent", "AgentInGroupParams", true, "The hostname of the new agent", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "addHubToCluster", "/config/mft/cluster/hub/{agentname}", "add hub to cluster.", "", "POST", false, [new argData_1.ArgData("agentname", "string", true, "Agent name", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "addMFTFolder", "/config/mft/virtualfolder", "Add virtual folder", "", "POST", false, [new argData_1.ArgData("folderPropertiesData", "FolderPropertiesData", true, "virtual folder data", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "addMFTRule", "/config/internal/mft/rule", "Add MFT rule", "", "POST", false, [new argData_1.ArgData("rulePropertiesFile", "Buffer", true, "File with contenet of rule properties data.", false, "", false),
    ], "", "", "", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "addMftUserGroup", "/config/mft/usergroup", "Add user group.", "", "POST", false, [new argData_1.ArgData("userGroupPropertiesData", "UserGroupPropertiesData", true, "User group object properites", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "addRemoteHost", "/config/server/{ctm}/remotehost", "Add a remote host to Control-M Server.", "", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the remote host is going to be added to.", false, "", false),
        new argData_1.ArgData("data", "AddRemoteHostParams", false, "The non default, advanced configuration data", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "addRole", "/config/authorization/role", "Add Authorization Role", "", "POST", false, [new argData_1.ArgData("roleFile", "Buffer", true, "File with contenet of Role Data.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "addRoleToLdapGroup", "/config/authorization/ldap/{ldapgroup}/role/{role}", "Add a role to LDAP group so any user belong to the LDAP group will get all permissions defined in the role", "", "POST", false, [new argData_1.ArgData("ldapgroup", "string", true, "Name of LDAP group", false, "", false),
        new argData_1.ArgData("role", "string", true, "Name of role", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "addRoleToUser", "/config/authorization/user/{user}/role/{role}", "Add a role to user so that user will inherit role authorization", "", "POST", false, [new argData_1.ArgData("user", "string", true, "Name of user", false, "", false),
        new argData_1.ArgData("role", "string", true, "Name of role", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "addSecret", "/config/secret", "Add a new secret to the secrets vault.", "", "POST", false, [new argData_1.ArgData("nameValue", "SecretKeyValue", true, "The new secret value", false, "", true),
    ], "", "", "", "[-p]", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "addServer", "/config/server", "Add a Control-M Server. This command setting up new Control-M server in the system", "", "POST", false, [new argData_1.ArgData("body", "AddServerParams", true, "", false, "", true),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "addUser", "/config/authorization/user", "Add user", "", "POST", false, [new argData_1.ArgData("userFile", "Buffer", true, "File with contenet of user data.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "authorizeSshKnownRemotehost", "/config/server/{ctm}/remotehost/{remotehost}/authorize", "Authorized known ssh remote host.", "authorize", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the remote host is connected to.", false, "", false),
        new argData_1.ArgData("remotehost", "string", true, "The name of the remote host.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "changeUserPassword", "/config/user/{user}/password/adminUpdate", "Change user password", "adminUpdate", "POST", false, [new argData_1.ArgData("user", "string", true, "user name", false, "", false),
        new argData_1.ArgData("password", "UserPassword", false, "The new password.", false, "", true),
    ], "", "", "", "[-p]", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "createAgentCertificateSigningRequest", "/config/server/{ctm}/agent/{agent}/csr", "Create certificate signing request (CSR) on SSL configured Control-M Agent.", "create", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The Control-M Agent.", false, "", false),
        new argData_1.ArgData("csrData", "CertificateSigningRequestData", true, "Certificate Signing Request (CSR) data", false, "", true),
    ], "", "", "-f &lt;configuration file&gt;", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "createRunAsUser", "/config/server/{ctm}/runasuser", "Add a new Run-as user to Control-M server.", "", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server.", false, "", false),
        new argData_1.ArgData("runAsUserData", "RunAsUserData", true, "Run as user data", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "[-p]", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "deactivateHub", "/config/internal/mft/deactivatehub", "deactivate hub.", "deactivatehub", "POST", false, [new argData_1.ArgData("componentMftKeyType", "ComponentMftKeyType", true, "component properties", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "true", "true", []);
    cli.addOperation("ConfigApi", "config", "deleteAgent", "/config/server/{ctm}/agent/{agent}", "Delete an agent from a Control-M Server. This will not shut the agent down. It only disconnects and removes it from the list.", "", "DELETE", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the agent is connected to.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The name of the agent to delete.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "deleteArchiveRule", "/config/archive/rule/{ruleName}", "Deletes Control-M Workload Archiving rule by name. It is required to send deleteRuleData flag to specify if rule need to be deleted with all the collected data or deleteRuleWithoutData otherwise.", "delete", "DELETE", false, [new argData_1.ArgData("ruleName", "string", true, "Rule name to delete", false, "", false),
        new argData_1.ArgData("deleteRuleDataFlag", "string", true, "Remove rule with collected data or without. REQUIRED.", false, "", false),
    ], "", "", "", "", false, "true", "", ["deleteRuleDataFlag"]);
    cli.addOperation("ConfigApi", "config", "deleteAuthorizationRole", "/config/authorization/role/{role}", "Delete Authorization Role", "", "DELETE", false, [new argData_1.ArgData("role", "string", true, "The Role name.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "deleteExternalUser", "/config/mft/externaluser/{username}", "Delete an existing external user in MFT", "", "DELETE", false, [new argData_1.ArgData("username", "string", true, "The name of the external user to delete", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "deleteExternalUserOrUserGroupFromMFTFolder", "/config/mft/virtualfolder/{folderName}/user/{userOrGroup}", "Remove an external user or user group from an existing virtual folder in MFT.", "", "DELETE", false, [new argData_1.ArgData("folderName", "string", true, "Name of folder", false, "", false),
        new argData_1.ArgData("userOrGroup", "string", true, "The user name", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "deleteHostFromGroup", "/config/server/{ctm}/hostgroup/{hostgroup}/agent/{host}", "Delete an agent from the specified hostgroup. If the group is empty it will also be deleted.", "", "DELETE", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the hostgroup belongs to.", false, "", false),
        new argData_1.ArgData("hostgroup", "string", true, "The hostgroup name", false, "", false),
        new argData_1.ArgData("host", "string", true, "The agent to be deleted", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "deleteMFTFolder", "/config/mft/virtualfolder/{folderName}", "Delete an existing virtual folder in MFT.", "", "DELETE", false, [new argData_1.ArgData("folderName", "string", true, "Name of folder", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "deleteMFTRule", "/config/internal/mft/rule/{ruleName}", "Delete an existing rule MFT.", "", "DELETE", false, [new argData_1.ArgData("ruleName", "string", true, "Name of rule", false, "", false),
    ], "", "", "", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "deleteMftUserGroup", "/config/mft/usergroup/{name}", "Delete user group.", "", "DELETE", false, [new argData_1.ArgData("name", "string", true, "User group name", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "deleteRemoteHost", "/config/server/{ctm}/remotehost/{remotehost}", "Delete a remote host from a Control-M Server.", "", "DELETE", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the remote host is connected to.", false, "", false),
        new argData_1.ArgData("remotehost", "string", true, "The name of the remote host to delete.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "deleteRoleFromLdapGroup", "/config/authorization/ldap/{ldapgroup}/role/{role}", "Delete a role from LDAP group", "", "DELETE", false, [new argData_1.ArgData("ldapgroup", "string", true, "Name of LDAP group", false, "", false),
        new argData_1.ArgData("role", "string", true, "Name of role", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "deleteRunAsUser", "/config/server/{ctm}/runasuser/{agent}/{user}", "Delete Run-as user from Control-M server", "delete", "DELETE", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The Control-M Agent", false, "", false),
        new argData_1.ArgData("user", "string", true, "The user name", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "deleteSecret", "/config/secret/{name}", "Delete an existing secret from the secrets vault.", "", "DELETE", false, [new argData_1.ArgData("name", "string", true, "The name of the secret to update", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "deleteUser", "/config/authorization/user/{user}", "Delete user", "", "DELETE", false, [new argData_1.ArgData("user", "string", true, "The user name.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "deployAgentCertificate", "/config/server/{ctm}/agent/{agent}/crt", "Deploy certificate (CRT) on SSL configured Control-M Agent.", "deploy", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The Control-M Agent.", false, "", false),
        new argData_1.ArgData("crtFile", "Buffer", true, "The CRT file path.", false, "", false),
        new argData_1.ArgData("caChainFile", "Buffer", true, "The CA Chain file path.", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "disableAgent", "/config/server/{ctm}/agent/{agent}/disable", "Disable a Control-M agent.", "disable", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the agent is connected too.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The Control-M agent to be disabled.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "enableAgent", "/config/server/{ctm}/agent/{agent}/enable", "Enable a Control-M agent. This command does not install or configure the agent. It only enable existing agent in the system.", "enable", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the agent is connected too.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The Control-M agent to be enabled.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "failover", "/config/server/{ctm}/failover", "Perform Manual Failover on a specified Control-M Server", "failover", "PUT", false, [new argData_1.ArgData("ctm", "string", true, "", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "getActionsAuth", "/config/internal/getActionsAuthorizations", "Get the actions authorizations DB table content to calculate user&#39;s allowed CCM related actions", "", "POST", false, [new argData_1.ArgData("token", "string", false, "user token", false, "", true),
    ], "", "", "", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "getAgentCertificateExpirationDate", "/config/server/{ctm}/agent/{agent}/crt/expiration", "Get the certificate expiration date of SSL configured Control-M Agent.", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The Control-M Agent.", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "getAgentDetails", "/config/internal/server/{ctm}/agent/{agent}/platform/{platform}/{state}/config", "Get all the details of the specified Control-M Agent.", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the agent is connected to.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The name of the agent to query.", false, "", false),
        new argData_1.ArgData("platform", "string", true, "The Platform Type of the requested agent.", false, "", false),
        new argData_1.ArgData("state", "string", true, "The agent state (Available or Unavailable).", false, "", false),
    ], "", "", "", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "getAgentLocaleList", "/config/internal/server/{ctm}/agent/{agent}/locale", "Get all the encoding options for a specified Control-M Agent.", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the agent is connected to.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The name of the agent to query.", false, "", false),
    ], "", "", "", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "getAgentParameters", "/config/server/{ctm}/agent/{agent}/params", "Get all the parameters of the specified Control-M Agent.", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the agent is connected to.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The name of the agent to query.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "getAgentSysParams", "/config/internal/server/{ctm}/params", "Get all the CTM system parameters for the Control-M Agent.", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the agent is connected to.", false, "", false),
    ], "", "", "", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "getAgents", "/config/server/{ctm}/agents", "Get all the agents of the specified Control-M Server.", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server to query. Optionally you can filter agent name of host or alias of the Control-M Agent", false, "", false),
        new argData_1.ArgData("agent", "string", false, "Optionally case insensitive agent name filter of host or alias of the Control-M Agent. &#x60;ctm server:agents::get ControlM AgentName&#x60; returns all agents which names start with &#x60;agentname&#x60;", false, "", false),
    ], "", "", "", "", false, "", "", ["agent"]);
    cli.addOperation("ConfigApi", "config", "getAgentsDataList", "/config/internal/agents", "Get Control-M Agents data list.", "", "GET", false, [], "", "", "", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "getAllArchiveRules", "/config/archive/rules", "Get all the Control-M Archiving rules", "", "GET", false, [], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "getAllAuthorizationRoles", "/config/authorization/roles", "Get Authorization Roles", "", "GET", false, [new argData_1.ArgData("role", "string", false, "The Role name.", true, "", false),
        new argData_1.ArgData("description", "string", false, "The Role description.", true, "", false),
    ], "", "Search fields are role.", "[-s &lt;search query&gt;]", "", false, "", "", ["role", "description"]);
    cli.addOperation("ConfigApi", "config", "getAllB2bData", "/config/internal/mft/initialize", "get all folders, settings, settingsMetadata and users of MFT.", "initialize", "POST", false, [new argData_1.ArgData("componentMftKeyType", "ComponentMftKeyType", true, "component properties", false, "", true),
    ], "", "", "", "", false, "true", "true", []);
    cli.addOperation("ConfigApi", "config", "getAllEligibleAgentsForCluster", "/config/internal/mft/cluster/eligibleAgents", "Get all eligible agents for cluster.", "", "GET", false, [], "", "get all eligible agents for cluster", "", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "getAllHubs", "/config/internal/mft/hubs", "get the MFT agents which are hosting the B2B server.", "", "GET", false, [], "", "", "", "", false, "true", "true", []);
    cli.addOperation("ConfigApi", "config", "getAllHubsData", "/config/internal/mft/hubsData", "Get all hubs with their data.", "", "GET", false, [], "", "get all hubs data", "", "", false, "true", "true", []);
    cli.addOperation("ConfigApi", "config", "getAllMFTAgents", "/config/internal/mft/agents", "get all MFTs agents which are capable to host B2Bs server.", "", "GET", false, [], "", "", "", "", false, "true", "true", []);
    cli.addOperation("ConfigApi", "config", "getAllRolesAssociatedWithLdap", "/config/authorization/ldap/{ldapgroup}/roles", "Get Authorization Roles associated with an LDAP group", "", "GET", false, [new argData_1.ArgData("ldapgroup", "string", true, "Name of Ldap group", false, "", false),
        new argData_1.ArgData("role", "string", false, "The Role name.", true, "", false),
    ], "", "Search fields are role name.", "[-s &lt;search query&gt;]", "", false, "", "", ["role"]);
    cli.addOperation("ConfigApi", "config", "getAllUsers", "/config/authorization/users", "Get users", "", "GET", false, [new argData_1.ArgData("name", "string", false, "The user name.", true, "", false),
        new argData_1.ArgData("fullName", "string", false, "The user full name.", true, "", false),
        new argData_1.ArgData("description", "string", false, "The user description.", true, "", false),
    ], "", "Search fields are user.", "[-s &lt;search query&gt;]", "", false, "", "", ["name", "fullName", "description"]);
    cli.addOperation("ConfigApi", "config", "getArchiveStatistics", "/config/archive/statistics", "Get list of statistical information for each Control-M Archiving rule and total information about the number of jobs that have been archived, data size of all job logs and outputs that have been archived, size of the Workload Archiving database including all tables and indexes and percentage of disk space used on the Workload Archiving server", "", "GET", false, [], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "getEMSystemParamsValue", "/config/internal/systemParameter/{type}/{name}", "Get system parameter value.", "", "GET", false, [new argData_1.ArgData("type", "string", true, "System parameter type.", false, "", false),
        new argData_1.ArgData("name", "string", true, "System parameter name.", false, "", false),
    ], "", "get system parameter value for EM server", "", "", false, "true", "true", []);
    cli.addOperation("ConfigApi", "config", "getExternalUserAuthorizedFolders", "/config/mft/externaluser/{name}/virtualfolders", "Get MFT external user authorized folders", "", "GET", false, [new argData_1.ArgData("name", "string", true, "The external user name.", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "getExternalUsers", "/config/mft/externalusers", "Get MFT external users that match the search criteria.", "", "GET", false, [new argData_1.ArgData("name", "string", false, "The user name.", true, "", false),
        new argData_1.ArgData("email", "string", false, "The user email.", true, "", false),
        new argData_1.ArgData("description", "string", false, "The user description.", true, "", false),
        new argData_1.ArgData("company", "string", false, "The user company.", true, "", false),
        new argData_1.ArgData("phoneNumber", "string", false, "The user phoneNumber.", true, "", false),
    ], "", "Search fields are name, email, description, company and phoneNumber", "[-s &lt;search query&gt;]", "", false, "true", "", ["name", "email", "description", "company", "phoneNumber"]);
    cli.addOperation("ConfigApi", "config", "getHostgroups", "/config/server/{ctm}/hostgroups", "Get all the hostgroups of the specified Control-M Server.", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the hostgroups belong to.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "getHostsInGroup", "/config/server/{ctm}/hostgroup/{hostgroup}/agents", "Get the agents that compose the specified hostgroup", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the hostgroup belongs to.", false, "", false),
        new argData_1.ArgData("hostgroup", "string", true, "The hostgroup name", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "getHubStatusDetails", "/config/mft/hub/{nodeId}/status", "Get hub status.", "", "GET", false, [new argData_1.ArgData("nodeId", "string", true, "Node ID of the hub", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "getMFTFolders", "/config/mft/virtualfolders", "Get MFT virtual folders that match the search criteria.", "", "GET", false, [new argData_1.ArgData("name", "string", false, "The virtual folder name.", true, "", false),
    ], "", "Search fields are name, authorizedInternalUsers, authorizedExternalUsersAndGroups, allowedFilePattern and blockedFilePattern", "[-s &lt;search query&gt;]", "", false, "true", "", ["name"]);
    cli.addOperation("ConfigApi", "config", "getMFTHubStatus", "/config/internal/mft/hubStatus", "Get HUB status.", "hubStatus", "POST", false, [new argData_1.ArgData("componentMftKeyType", "ComponentMftKeyType", true, "component properties", false, "", true),
    ], "", "", "", "", false, "true", "true", []);
    cli.addOperation("ConfigApi", "config", "getMFTRules", "/config/internal/mft/rules", "Get MFT rules that match the search criteria.", "", "GET", false, [new argData_1.ArgData("name", "string", false, "The rule name.", true, "", false),
        new argData_1.ArgData("description", "string", false, "The rule description.", true, "", false),
        new argData_1.ArgData("priority", "string", false, "The rule priority.", true, "", false),
        new argData_1.ArgData("status", "string", false, "The rule status.", true, "", false),
    ], "", "Search fields are name, description, priority, and status", "[-s &lt;search query&gt;]", "", false, "", "true", ["name", "description", "priority", "status"]);
    cli.addOperation("ConfigApi", "config", "getMFTRulesProjection", "/config/internal/mft/rules/projection", "Get MFT rules projection", "", "GET", false, [], "", "", "", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "getMFTRulesSchema", "/config/internal/mft/rules/schema", "Get MFT rules schema", "", "GET", false, [], "", "", "", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "getMftGateways", "/config/mft/gateways", "Get MFT gateways", "", "GET", false, [], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "getMftUserGroups", "/config/mft/usergroups", "Get all user groups that match the search criteria.", "", "GET", false, [new argData_1.ArgData("name", "string", false, "The user group name.", true, "", false),
        new argData_1.ArgData("externalUsers", "string", false, "external users.", true, "", false),
        new argData_1.ArgData("ldapGroups", "string", false, "ldap groups.", true, "", false),
    ], "", "Search fields are name, externalUsers, and ldapGroups", "[-s &lt;search query&gt;]", "", false, "true", "", ["name", "externalUsers", "ldapGroups"]);
    cli.addOperation("ConfigApi", "config", "getRemoteHostProperties", "/config/server/{ctm}/remotehost/{remotehost}", "Get the remote host configuration properties from the Control-M Server", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the remote host  is connected to.", false, "", false),
        new argData_1.ArgData("remotehost", "string", true, "The name of the remote host.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "getRemoteHosts", "/config/server/{ctm}/remotehosts", "Get all the remote hosts of the specified Control-M Server.", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server to query.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "getRole", "/config/authorization/role/{role}", "Get Authorization Role", "", "GET", false, [new argData_1.ArgData("role", "string", true, "The Role name.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "getRoleAssociates", "/config/authorization/role/{role}/associates", "Get all authorization entities associated with role", "", "GET", false, [new argData_1.ArgData("role", "string", true, "role name.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "getRunAsUser", "/config/server/{ctm}/runasuser/{agent}/{user}", "Get Run-as user details from Control-M server.", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The Control-M Agent", false, "", false),
        new argData_1.ArgData("user", "string", true, "The user name", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "getRunAsUsersList", "/config/server/{ctm}/runasusers", "Get Run-as user list that match the requested search criteria from Control-M server.", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server.", false, "", false),
        new argData_1.ArgData("user", "string", false, "The Run-as user.", true, "", false),
        new argData_1.ArgData("agent", "string", false, "The agent.", true, "", false),
    ], "", "Search fields are user and agent.", "[-s &lt;search query&gt;]", "", false, "", "", ["user", "agent"]);
    cli.addOperation("ConfigApi", "config", "getServerParameters", "/config/server/{ctm}/params", "Get all the parameters of the specified Control-M Server.", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server to query.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "getServers", "/config/servers", "Get the names and hostnames of all Control-M Servers in the system.", "", "GET", false, [], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "getSettingsMetadataProperties", "/config/internal/mft/settings/metadata", "Get Settings Metadata Properties.", "", "GET", false, [], "", "get settings Metadata properties", "", "", false, "true", "true", []);
    cli.addOperation("ConfigApi", "config", "getSettingsProperties", "/config/internal/mft/settings", "Get Settings Properties.", "", "GET", false, [], "", "get settings properties data", "", "", false, "true", "true", []);
    cli.addOperation("ConfigApi", "config", "getUser", "/config/authorization/user/{user}", "Get user", "", "GET", false, [new argData_1.ArgData("user", "string", true, "The user name.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "getUserEffectiveRights", "/config/authorization/user/effectiveRights", "Get user real effective authorizations by all his roles", "", "GET", false, [new argData_1.ArgData("userName", "string", true, "The name of the user", false, "", false),
    ], "", "", "", "", false, "true", "", ["userName"]);
    cli.addOperation("ConfigApi", "config", "getUserGroupsAllowedFoldersProperties", "/config/internal/mft/usergroupsAllowedFoldersProperties", "Get user-groups with allowed folders.", "", "GET", false, [], "", "", "", "", false, "true", "true", []);
    cli.addOperation("ConfigApi", "config", "getUserPreferences", "/config/authorization/user/preferences", "Get user preferences by user name.", "", "GET", false, [new argData_1.ArgData("userName", "string", true, "The name of the user", false, "", false),
    ], "", "", "", "", false, "true", "true", ["userName"]);
    cli.addOperation("ConfigApi", "config", "getUsersAllowedFoldersProperties", "/config/internal/mft/usersAllowedFoldersProperties", "Get users with allowed folders.", "", "GET", false, [], "", "", "", "", false, "true", "true", []);
    cli.addOperation("ConfigApi", "config", "listSecrets", "/config/secrets", "Get the list of names of all the secrets in the vault", "", "GET", false, [], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "pingAgent", "/config/server/{ctm}/agent/{agent}/ping", "Ping a Control-M agent.", "ping", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The Control-M agent.", false, "", false),
        new argData_1.ArgData("body", "PingAgentParams", false, "", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "recycleItem", "/config/item/{id}/recycle", "Recycle an item", "recycle", "POST", false, [new argData_1.ArgData("id", "string", true, "item data", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "removeControlmServer", "/config/server/{ctm}", "Delete Control-M server", "", "DELETE", false, [new argData_1.ArgData("ctm", "string", true, "Control-M Server host name.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "removeGateway", "/config/mft/gateway/{gatewayName}", "remove gateway.", "", "DELETE", false, [new argData_1.ArgData("gatewayName", "string", true, "gateway name", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "removeHubFromCluster", "/config/mft/cluster/hub/{agentname}", "remove hub from cluster.", "", "DELETE", false, [new argData_1.ArgData("agentname", "string", true, "Agent name", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "removeRoleFromUser", "/config/authorization/user/{user}/role/{role}", "Remove a role from a user", "", "DELETE", false, [new argData_1.ArgData("user", "string", true, "Name of user", false, "", false),
        new argData_1.ArgData("role", "string", true, "Name of role", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "sendArchiveCleanupRequest", "/config/archive/cleanup", "Deletes data (jobs including outputs and logs) by search criteria from the Workload Archiving database.", "cleanup", "DELETE", false, [new argData_1.ArgData("application", "string", false, "Job&#39;s application.", true, "", false),
        new argData_1.ArgData("applicationExceptions", "string", false, "Cleanup should skip job&#39;s application that are mentioned in exceptions", true, "", false),
        new argData_1.ArgData("subApplication", "string", false, "Job&#39;s sub application", true, "", false),
        new argData_1.ArgData("subApplicationExceptions", "string", false, "Job&#39;s sub application exception", true, "", false),
        new argData_1.ArgData("ctm", "string", false, "Control-M server name", true, "", false),
        new argData_1.ArgData("ctmExceptions", "string", false, "Control-M server exceptions", true, "", false),
        new argData_1.ArgData("folder", "string", false, "Job&#39;s folder.", true, "", false),
        new argData_1.ArgData("folderExceptions", "string", false, "Job&#39;s folder exceptions", true, "", false),
        new argData_1.ArgData("jobname", "string", false, "Job&#39;s name", true, "", false),
        new argData_1.ArgData("jobnameExceptions", "string", false, "Job&#39;s name exceptions", true, "", false),
        new argData_1.ArgData("library", "string", false, "Job&#39;s library", true, "", false),
        new argData_1.ArgData("libraryExceptions", "string", false, "Job&#39;s library exceptions", true, "", false),
        new argData_1.ArgData("ruleName", "string", false, "Job&#39;s archive rule", true, "", false),
        new argData_1.ArgData("jobStatus", "string", false, "The job&#39;s end status.", true, "", false),
    ], "", "Cleanup fields are jobname, jobnameExceptions, ctm, ctmExceptions, folder, folderExceptions, application, applicationExceptions, subApplication, subApplicationExceptions, library, libraryExceptions, jobStatus and ruleName.", "-s &lt;search query&gt;", "", false, "true", "", ["application", "applicationExceptions", "subApplication", "subApplicationExceptions", "ctm", "ctmExceptions", "folder", "folderExceptions", "jobname", "jobnameExceptions", "library", "libraryExceptions", "ruleName", "jobStatus"]);
    cli.addOperation("ConfigApi", "config", "sendCmsRequest", "/config/internal/sendcmsrequest", "Send generic CMS XML request.", "", "POST", false, [new argData_1.ArgData("cmsXmlRequestObject", "RawCmsXmlRequest", false, "The CMS XML request to be performed", false, "", true),
    ], "", "", "", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "setAgentParameter", "/config/server/{ctm}/agent/{agent}/param/{name}", "Set the value of the specified parameter in the specified agent.", "set", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the agent is connected to.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The name of the agent to update.", false, "", false),
        new argData_1.ArgData("name", "string", true, "The parameter name.", false, "", false),
        new argData_1.ArgData("body", "Value", true, "The new parameter value.", false, "", true),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "setAgentPlatform", "/config/internal/server/{ctm}/agent/{agent}/platform/{platform}/{state}/config", "Update agent parameters of the specified Control-M Agent.", "update", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server the agent is connected to.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The name of the agent to query.", false, "", false),
        new argData_1.ArgData("platform", "string", true, "The Platform Type of the requested agent.", false, "", false),
        new argData_1.ArgData("state", "string", true, "The agent state (Available or Unavailable).", false, "", false),
        new argData_1.ArgData("agentParameters", "SetAgentParamsList", true, "The parameters list.", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "setMftRuleStatus", "/config/internal/mft/rule/{name}/status/{status}", "Set Mft rule status", "", "POST", false, [new argData_1.ArgData("name", "string", true, "Name of rule", false, "", false),
        new argData_1.ArgData("status", "string", true, "new status of rule", false, "", false),
    ], "", "", "", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "setSystemParam", "/config/em/param/{name}", "Set value of an enterprise management system parameter", "set", "POST", false, [new argData_1.ArgData("name", "string", true, "Parameter name", false, "", false),
        new argData_1.ArgData("newValue", "Value", true, "Param new value", false, "", true),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "setasprimary", "/config/server/{ctm}/setasprimary", "Set secondary server as Primary on a specified Control-M Server", "setasprimary", "PUT", false, [new argData_1.ArgData("ctm", "string", true, "", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "testRunAsUser", "/config/server/{ctm}/runasuser/{agent}/{user}/test", "Test existing Run-as user in Control-M server.", "test", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The Control-M Agent", false, "", false),
        new argData_1.ArgData("user", "string", true, "The user name", false, "", false),
        new argData_1.ArgData("runAsUserDetailsData", "RunAsUserDetailsData", false, "Run as user details data", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "updateArchiveRule", "/config/archive/rule/{ruleName}", "Edit Control-M Workload Archiving rule details", "update", "POST", false, [new argData_1.ArgData("ruleName", "string", true, "Rule name to update", false, "", false),
        new argData_1.ArgData("archiveRule", "ArchiveRule", true, "Edit Control-M Workload Archiving rule details", false, "", true),
    ], "", "", "-f &lt;configuration file&gt;", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "updateExternalUser", "/config/mft/externaluser/{username}", "Update an external user for b2b", "update", "POST", false, [new argData_1.ArgData("username", "string", true, "The external user name", false, "", false),
        new argData_1.ArgData("externalUserData", "ExternalUserData", true, "External user data", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "[-p]", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "updateMFTFolder", "/config/mft/virtualfolder/{folderName}", "Update an existing virtual folder in MFT.", "update", "POST", false, [new argData_1.ArgData("folderName", "string", true, "Name of folder", false, "", false),
        new argData_1.ArgData("folderPropertiesData", "FolderPropertiesData", true, "virtual folder data", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "updateMFTRule", "/config/internal/mft/rule/{ruleName}", "Update an existing rule in MFT.", "update", "POST", false, [new argData_1.ArgData("ruleName", "string", true, "Name of rule", false, "", false),
        new argData_1.ArgData("rulePropertiesFile", "Buffer", true, "File with contenet of rule properties data.", false, "", false),
    ], "", "", "", "", false, "", "true", []);
    cli.addOperation("ConfigApi", "config", "updateMftUserGroup", "/config/mft/usergroup/{name}", "Update user group.", "update", "POST", false, [new argData_1.ArgData("name", "string", true, "User group name", false, "", false),
        new argData_1.ArgData("userGroupDetailsData", "UserGroupDetailsData", true, "User group details", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "true", "", []);
    cli.addOperation("ConfigApi", "config", "updateRole", "/config/authorization/role/{role}", "Update Authorization Role", "update", "POST", false, [new argData_1.ArgData("role", "string", true, "The Role name.", false, "", false),
        new argData_1.ArgData("roleFile", "Buffer", true, "File with contenet of Role Data.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "updateRunAsUser", "/config/server/{ctm}/runasuser/{agent}/{user}", "Update Run-as user details in Control-M server.", "update", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The Control-M Agent", false, "", false),
        new argData_1.ArgData("user", "string", true, "The user name", false, "", false),
        new argData_1.ArgData("runAsUserDetailsData", "RunAsUserDetailsData", true, "Run as user details data", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "[-p]", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "updateSecret", "/config/secret/{name}", "Update an existing secret in the secrets vault.", "update", "POST", false, [new argData_1.ArgData("name", "string", true, "The name of the secret to update", false, "", false),
        new argData_1.ArgData("value", "SecretValue", false, "The new value for the secret", false, "", true),
    ], "", "", "", "[-p]", false, "", "", []);
    cli.addOperation("ConfigApi", "config", "updateSettingsProperties", "/config/internal/mft/settings", "Update Settings Properties.", "update", "POST", false, [new argData_1.ArgData("settingsUpdateObject", "SettingsUpdateObject", true, "component properties", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "true", "true", []);
    cli.addOperation("ConfigApi", "config", "updateUser", "/config/authorization/user/{user}", "Update user", "update", "POST", false, [new argData_1.ArgData("user", "string", true, "The user name.", false, "", false),
        new argData_1.ArgData("userFile", "Buffer", true, "File with contenet of user data.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("DeployApi", "deploy", "deleteConnectionProfile", "/deploy/connectionprofile/{ctm}/{agent}/{type}/{name}", "Delete Local Connection Profile.", "", "DELETE", false, [new argData_1.ArgData("ctm", "string", true, "The name of the Control-M in which the connection profile is deployed.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The name of the agent the connection profile is deployed on.", false, "", false),
        new argData_1.ArgData("type", "string", true, "The type of connection profile to delete.", false, "", false),
        new argData_1.ArgData("name", "string", true, "Name of the Connection Profile", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("DeployApi", "deploy", "deleteFolder", "/deploy/folder/{controlM}/{folderName}", "Delete a folder", "", "DELETE", false, [new argData_1.ArgData("controlM", "string", true, "The name of the Control-M in which the folder(s) are deployed. Wildcards can be used.", false, "", false),
        new argData_1.ArgData("folderName", "string", true, "The name of the required folder(s). Wildcards can be used.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("DeployApi", "deploy", "deleteLocalConnectionProfile", "/deploy/connectionprofile/local/{ctm}/{agent}/{type}/{name}", "Delete Local Connection Profile", "", "DELETE", false, [new argData_1.ArgData("ctm", "string", true, "The name of the Control-M in which the connection profile is deployed.", false, "", false),
        new argData_1.ArgData("agent", "string", true, "The name of the agent the connection profile is deployed on.", false, "", false),
        new argData_1.ArgData("type", "string", true, "The type of connection profile to delete.", false, "", false),
        new argData_1.ArgData("name", "string", true, "Name of the Connection Profile", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("DeployApi", "deploy", "deleteSharedConnectionProfile", "/deploy/connectionprofile/centralized/{type}/{name}", "Delete centralized Connection Profile", "", "DELETE", false, [new argData_1.ArgData("type", "string", true, "The type of connection profile to delete.", false, "", false),
        new argData_1.ArgData("name", "string", true, "Name of the Connection Profile", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("DeployApi", "deploy", "deployAiJobtype", "/deploy/ai/jobtype", "Deploy an Application Integrator job type to agent in order to allow it to run", "!", "POST", false, [new argData_1.ArgData("ctm", "string", true, "", false, "", false),
        new argData_1.ArgData("agent", "string", true, "", false, "", false),
        new argData_1.ArgData("jobTypeId", "string", true, "", false, "", false),
    ], "", "", "", "", false, "", "", ["ctm", "agent", "jobTypeId"]);
    cli.addOperation("DeployApi", "deploy", "deployFile", "/deploy", "Deploy the provided definition file (JSON, XML or zip) to Control-M", "!", "POST", false, [new argData_1.ArgData("definitionsFile", "Buffer", true, "A file that contains definitions to be deployed to the server. Can be either a JSON definition file, an XML definition file, or a zip file that contains multiple JSON or XML definition files.", false, "", false),
        new argData_1.ArgData("deployDescriptorFile", "Buffer", false, "Deploy Descriptor JSON file.", false, "", false),
        new argData_1.ArgData("additionalConfiguration", "Buffer", false, "additionalConfiguration to enable skip testing for local connection profile", true, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("DeployApi", "deploy", "getConnectionProfilesDeploymentStatus", "/deploy/connectionprofile/centralized/deploymentstatus/{type}/{name}", "Get currently deployed connection profiles deployment status according to the search query as JSON.", "deploymentstatus", "GET", false, [new argData_1.ArgData("type", "string", true, "The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP.", false, "", false),
        new argData_1.ArgData("name", "string", true, "Name of the Connection Profile", false, "", false),
    ], "", "", "", "", false, "true", "", []);
    cli.addOperation("DeployApi", "deploy", "getDeployedAiJobtypes", "/deploy/ai/jobtypes", "Get deployed Application Integrator job types that match the requested search criteria.", "", "GET", false, [new argData_1.ArgData("jobTypeName", "string", false, "Job type display name ( or partial name ) for query. It accepts * as wildcard.", true, "", false),
        new argData_1.ArgData("jobTypeId", "string", false, "Job type id ( or partial name ) for query. It accepts * as wildcard.", true, "", false),
    ], "", "Search fields are jobTypeName and jobTypeId. Wildcard * is supported", "-s &lt;search query&gt;", "", false, "", "", ["jobTypeName", "jobTypeId"]);
    cli.addOperation("DeployApi", "deploy", "getDeployedConnectionProfiles", "/deploy/connectionprofiles", "Get currently local deployed connection profiles according to the search query as JSON.", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The name of the Control-M in which the connection profile is deployed on", true, "", false),
        new argData_1.ArgData("agent", "string", true, "The name of the agent the connection profile is deployed on", true, "", false),
        new argData_1.ArgData("type", "string", true, "The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP.", true, "", false),
    ], "", "Search fields are ctm, agent, type", "-s &lt;search query&gt;", "", true, "", "", ["ctm", "agent", "type"]);
    cli.addOperation("DeployApi", "deploy", "getDeployedConnectionProfilesStatus", "/deploy/connectionprofiles/centralized/status", "Get currently deployed connection profiles status according to the search query as JSON.", "", "GET", false, [new argData_1.ArgData("limit", "number", false, "number to limit the returned connection profiles. If missed - get all", false, "", false),
        new argData_1.ArgData("name", "string", false, "conn profile name (support *, ?, and comma, default is * for all).", true, "", false),
        new argData_1.ArgData("type", "string", false, "conn profile type (default is * for accounts from all CMs).", true, "", false),
    ], "", "Search fields are name, type, limit", "-s &lt;search query&gt;", "", true, "true", "", ["limit", "name", "type"]);
    cli.addOperation("DeployApi", "deploy", "getDeployedFoldersNew", "/deploy/jobs", "Get definition of jobs and folders (in the desired format - JSON or XML) that match the requested search criteria.", "", "GET", false, [new argData_1.ArgData("format", "string", false, "Output format (json or xml)", false, "", false),
        new argData_1.ArgData("folder", "string", false, "", true, "", false),
        new argData_1.ArgData("ctm", "string", false, "", true, "", false),
    ], "", "Search fields are ctm and folder", "-s &lt;search query&gt;", "", false, "", "", ["format", "folder", "ctm"]);
    cli.addOperation("DeployApi", "deploy", "getLocalConnectionProfiles", "/deploy/connectionprofiles/local", "Get currently local deployed connection profiles according to the search query as JSON.", "", "GET", false, [new argData_1.ArgData("ctm", "string", true, "The name of the Control-M in which the connection profile is deployed on", true, "", false),
        new argData_1.ArgData("agent", "string", true, "The name of the agent the connection profile is deployed on", true, "", false),
        new argData_1.ArgData("type", "string", true, "The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP.", true, "", false),
    ], "", "Search fields are ctm, agent, type", "-s &lt;search query&gt;", "", true, "true", "", ["ctm", "agent", "type"]);
    cli.addOperation("DeployApi", "deploy", "getSharedConnectionProfiles", "/deploy/connectionprofiles/centralized", "Get currently centralized deployed connection profiles according to the search query as JSON.", "", "GET", false, [new argData_1.ArgData("type", "string", true, "The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. Use * to get all types", true, "", false),
        new argData_1.ArgData("name", "string", false, "The name of centralized connection profile. Supports for *, ?, and comma. By default is *", true, "", false),
    ], "", "Search fields are type and name", "-s &lt;search query&gt;", "", true, "true", "", ["type", "name"]);
    cli.addOperation("DeployApi", "deploy", "getSiteStandardFieldRestrictions", "/deploy/sitestandard/{standardName}/fieldRestriction/{fieldName}", "Get the allowed values for the specified field in the specified site standard.", "", "GET", false, [new argData_1.ArgData("standardName", "string", true, "", false, "", false),
        new argData_1.ArgData("fieldName", "string", true, "", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("DeployApi", "deploy", "setSiteStandardFieldRestrictions", "/deploy/sitestandard/{standardName}/fieldRestriction/{fieldName}", "Replace the allowed values for the specified field in the specified site standard.", "replaceValues", "POST", false, [new argData_1.ArgData("standardName", "string", true, "", false, "", false),
        new argData_1.ArgData("fieldName", "string", true, "", false, "", false),
        new argData_1.ArgData("valuesFile", "FieldValues", true, "The JSON file with the allowed values", false, "", true),
    ], "", "", "-f &lt;json file&gt;", "", false, "", "", []);
    cli.addOperation("DeployApi", "deploy", "testConnectionProfile", "/deploy/connectionprofile/test", "Test connection profile on agent", "test", "POST", false, [new argData_1.ArgData("definitionsFile", "Buffer", true, "A file that contains definitions of the connection profile to be tested", false, "", false),
        new argData_1.ArgData("ctm", "string", false, "", false, "", false),
        new argData_1.ArgData("agent", "string", false, "", false, "", false),
    ], "", "", "", "", false, "true", "", ["ctm", "agent"]);
    cli.addOperation("DeployApi", "deploy", "transformFile", "/deploy/transform", "Transform the provided definitions file (JSON) according to the provided Deploy Descriptor file (JSON).", "!", "POST", false, [new argData_1.ArgData("definitionsFile", "Buffer", true, "A file that contains definitions to be deployed to the server. Can be either a JSON definition file, an XML definition file, or a zip file that contains multiple JSON or XML definition files.", false, "", false),
        new argData_1.ArgData("deployDescriptorFile", "Buffer", true, "Deploy Descriptor JSON file.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ProvisionApi", "provision", "cancelUpgradeActivity", "/provision/upgrade/{upgradeId}/cancel", "Cancel upgrade activity", "cancel", "POST", false, [new argData_1.ArgData("upgradeId", "string", true, "Id of upgrade to cancel", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ProvisionApi", "provision", "deleteUpgradeActivity", "/provision/upgrade/{upgradeId}", "Delete upgrade activity status for specific upgrade id.", "", "DELETE", false, [new argData_1.ArgData("upgradeId", "string", true, "The upgrade id.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ProvisionApi", "provision", "getAllUpgradeActivitiesStatus", "/provision/upgrades", "Get all upgrade activities status.", "", "GET", false, [new argData_1.ArgData("ctm", "string", false, "The Control-M server name", true, "", false),
        new argData_1.ArgData("agent", "string", false, "The Control-M Agent name", true, "", false),
        new argData_1.ArgData("fromVersion", "string", false, "Current product version", true, "", false),
        new argData_1.ArgData("toVersion", "string", false, "Upgrade to version", true, "", false),
        new argData_1.ArgData("activity", "string", false, "Activity type (Install, Uninstall)", true, "", false),
        new argData_1.ArgData("status", "string", false, "Upgrade activity status (Cancel, Running, Completed, TransferCompleted, Failed, Unavailable)", true, "", false),
        new argData_1.ArgData("activityName", "string", false, "Name of the upgrade activity", true, "", false),
    ], "", "Search fields are ctm, agent, fromVersion, toVersion, activity, status and activityName", "-s &lt;search query&gt;", "", false, "", "", ["ctm", "agent", "fromVersion", "toVersion", "activity", "status", "activityName"]);
    cli.addOperation("ProvisionApi", "provision", "getDeployVersions", "/provision/upgrades/versions", "Get available versions for upgrade", "", "GET", false, [], "", "", "", "", false, "", "", []);
    cli.addOperation("ProvisionApi", "provision", "getEligibleAgentsForUpgrade", "/provision/upgrades/agents", "Get eligible agents for upgrade that match the requested search criteria from Control-M server.", "", "GET", false, [new argData_1.ArgData("type", "string", false, "The type (Agent, MFT, AppPack).", true, "", false),
        new argData_1.ArgData("version", "string", false, "The version.", true, "", false),
    ], "", "Search fields are type (Agent, MFT, AppPack) and version.", "-s &lt;search query&gt;", "", false, "", "", ["type", "version"]);
    cli.addOperation("ProvisionApi", "provision", "getImages", "/provision/images/{os}", "Get a list of the images in the system for the requested OS.", "!", "GET", false, [new argData_1.ArgData("os", "string", true, "The OS name of the requested images.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ProvisionApi", "provision", "getUpgradeActivityLog", "/provision/upgrade/{upgradeId}/output", "Returns log of upgrade activity", "", "GET", false, [new argData_1.ArgData("upgradeId", "string", true, "The upgrade id.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ProvisionApi", "provision", "getUpgradeActivityStatusPerUpgradeId", "/provision/upgrade/{upgradeId}", "Get upgrade activity status for specific upgrade id.", "", "GET", false, [new argData_1.ArgData("upgradeId", "string", true, "The upgrade id.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ProvisionApi", "provision", "retryUpgradeActivity", "/provision/upgrade/{upgradeId}/retry", "Retry upgrade activity", "retry", "POST", false, [new argData_1.ArgData("upgradeId", "string", true, "Id of upgrade to retry", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ProvisionApi", "provision", "transferAndInstallProduct", "/provision/upgrade/install", "Transfer and install a product on an agent", "install", "POST", false, [new argData_1.ArgData("upgradeRequest", "UpgradeRequest", true, "Upgrade request details", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "", "", []);
    cli.addOperation("ProvisionApi", "provision", "uninstallProduct", "/provision/upgrade/uninstall", "Uninstall a product from an agent", "uninstall", "POST", false, [new argData_1.ArgData("rollbackRequest", "UpgradeRequest", true, "Rollback request details", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "", "", []);
    cli.addOperation("ReportingApi", "reporting", "getReportByName", "/reporting/report/{name}", "Retrieves a report by name in the desired format (CSV,PDF ,EXCEL). If the report is shared, add [shared:] before the name. This REST API command will be deprecated soon.", "get_old", "GET", true, [new argData_1.ArgData("name", "string", true, "The report name.", false, "", false),
        new argData_1.ArgData("format", "string", false, "", false, "", false),
    ], "{&quot;outputfile&quot;:&quot;reportURL&quot;}", "", "-o", "", false, "", "", ["format"]);
    cli.addOperation("ReportingApi", "reporting", "getReportStatus", "/reporting/status/{reportId}", "Retrieves status information for a report generation request based on the report ID", "", "GET", false, [new argData_1.ArgData("reportId", "string", true, "The ID of the report", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("ReportingApi", "reporting", "runReport", "/reporting/report", "Sends a request to generate a report asynchronously and returns the request status. If the report is shared, add [shared:] before the name.", "!", "POST", false, [new argData_1.ArgData("reportRun", "RunReport", true, "The report generation parameters", false, "", true),
    ], "", "", "[-f &lt;configuration file&gt;]", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "activateWorkloadPolicy", "/run/workloadpolicy/{policy}/activate", "Activate a workload policy, supports wildcard in names", "activate", "POST", false, [new argData_1.ArgData("policy", "string", true, "The policy name to be activated. Case sensitive. Wildcards can be used.", false, "", false),
        new argData_1.ArgData("ctm", "string", false, "Optional Control-M Server filter.", false, "", false),
    ], "", "", "", "", false, "", "", ["ctm"]);
    cli.addOperation("RunApi", "run", "addEvent", "/run/event/{ctm}", "Add a new  event. date may be of format MMDD, ODAT to set current controlm date, STAT to set no date. default value is ODAT.", "", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server hosting the event.", false, "", false),
        new argData_1.ArgData("event", "EventParam", true, "The defined event name.", false, "", true),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "addResource", "/run/resource/{ctm}", "Add a new quantitative resource.", "", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server hosting the resource.", false, "", false),
        new argData_1.ArgData("resource", "ResourceParam", true, "The defined resource name.", false, "", true),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "confirmJob", "/run/job/{jobId}/confirm", "confirm a job that waits for confirmation", "confirm", "POST", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "deactivateWorkloadPolicy", "/run/workloadpolicy/{policy}/deactivate", "Deactivate a workload policy, supports wildcard in names", "deactivate", "POST", false, [new argData_1.ArgData("policy", "string", true, "The policy name to be deactivated. Case sensitive. Wildcards can be used.", false, "", false),
        new argData_1.ArgData("ctm", "string", false, "Optional Control-M Server filter.", false, "", false),
    ], "", "", "", "", false, "", "", ["ctm"]);
    cli.addOperation("RunApi", "run", "deleteEvent", "/run/event/{ctm}/{name}/{date}", "Delete a  event.", "", "DELETE", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server hosting the event.", false, "", false),
        new argData_1.ArgData("name", "string", true, "event name", false, "", false),
        new argData_1.ArgData("date", "string", true, "event date", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "deleteJob", "/run/job/{jobId}/delete", "mark delete as deleted", "delete", "POST", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "deleteResource", "/run/resource/{ctm}/{name}", "Delete a quantitative resource.", "", "DELETE", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server hosting the resource.", false, "", false),
        new argData_1.ArgData("name", "string", true, "Resource name", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "freeJob", "/run/job/{jobId}/free", "free the job", "free", "POST", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "getActiveJob", "/run/job/{jobId}/get", "get the active job&#39;s data by job&#39;s order ID", "get", "GET", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "getActiveServices", "/run/services/sla", "Get all SLA active services", "", "GET", false, [], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "getEvents", "/run/events", "Get all events records for specific search.", "", "GET", false, [new argData_1.ArgData("ctm", "string", false, "Control-M Server filter.", true, "", false),
        new argData_1.ArgData("name", "string", false, "The event name filter.", true, "", false),
        new argData_1.ArgData("date", "string", false, "The event date filter.", true, "", false),
        new argData_1.ArgData("limit", "number", false, "maximum events to fetch (default 1000).", true, "", false),
    ], "", "Search fields are ctm, name, date", "-s &lt;search query&gt;", "", false, "", "", ["ctm", "name", "date", "limit"]);
    cli.addOperation("RunApi", "run", "getJobLog", "/run/job/{jobId}/log", "Get the job execution log.", "", "GET", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "getJobOutput", "/run/job/{jobId}/output", "Get the output returned from a job.", "", "GET", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
        new argData_1.ArgData("runNo", "number", false, "The execution number in case of multiple executions (0 will get the last execution&#39;s output)", false, "", false),
    ], "", "", "", "", false, "", "", ["runNo"]);
    cli.addOperation("RunApi", "run", "getJobStatus", "/run/job/{jobId}/status", "Get the job status.", "", "GET", false, [new argData_1.ArgData("jobId", "string", true, "Job ID returned from the run status action.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "getJobsStatus", "/run/status/{runId}", "Run status of jobs started with the Run service.", "!", "GET", false, [new argData_1.ArgData("runId", "string", true, "Run ID returned from the run action.", false, "", false),
        new argData_1.ArgData("startIndex", "number", false, "The index of the job status from which to start. returning results", false, "", false),
    ], "{&quot;interactive&quot;:&quot;monitorPageURI&quot;}", "", "[-i]", "", false, "", "", ["startIndex"]);
    cli.addOperation("RunApi", "run", "getJobsStatusByFilter", "/run/jobs/status", "Get status of jobs that match the requested search criteria.", "", "GET", false, [new argData_1.ArgData("limit", "number", false, "maximum jobs status to fetch (default 1000).", false, "", false),
        new argData_1.ArgData("jobname", "string", false, "", true, "", false),
        new argData_1.ArgData("ctm", "string", false, "", true, "", false),
        new argData_1.ArgData("application", "string", false, "", true, "", false),
        new argData_1.ArgData("subApplication", "string", false, "", true, "", false),
        new argData_1.ArgData("host", "string", false, "", true, "", false),
        new argData_1.ArgData("status", "string", false, "", true, "", false),
        new argData_1.ArgData("folder", "string", false, "", true, "", false),
        new argData_1.ArgData("description", "string", false, "", true, "", false),
        new argData_1.ArgData("jobid", "string", false, "", true, "", false),
        new argData_1.ArgData("neighborhood", "string", false, "", true, "", false),
        new argData_1.ArgData("depth", "number", false, "", true, "", false),
        new argData_1.ArgData("direction", "string", false, "", true, "", false),
        new argData_1.ArgData("orderDateFrom", "string", false, "", true, "", false),
        new argData_1.ArgData("orderDateTo", "string", false, "", true, "", false),
        new argData_1.ArgData("fromTime", "string", false, "", true, "", false),
        new argData_1.ArgData("toTime", "string", false, "", true, "", false),
        new argData_1.ArgData("folderLibrary", "string", false, "", true, "", false),
        new argData_1.ArgData("hostGroup", "string", false, "", true, "", false),
        new argData_1.ArgData("runAs", "string", false, "", true, "", false),
        new argData_1.ArgData("command", "string", false, "", true, "", false),
        new argData_1.ArgData("filePath", "string", false, "", true, "", false),
        new argData_1.ArgData("fileName", "string", false, "", true, "", false),
        new argData_1.ArgData("workloadPolicy", "string", false, "", true, "", false),
        new argData_1.ArgData("ruleBasedCalendar", "string", false, "", true, "", false),
        new argData_1.ArgData("resourceMutex", "string", false, "", true, "", false),
        new argData_1.ArgData("resourceSemaphore", "string", false, "", true, "", false),
    ], "", "Search fields are jobname, jobid, ctm, folder, host, application, subApplication, status, orderDateFrom, orderDateTo , fromTime, toTime, folderLibrary, hostGroup, runAs, command, filePath, fileName, workloadPolicy, ruleBasedCalender, resourceMutex, resourceSemaphore and description.", "-s &lt;search query&gt;", "", false, "", "", ["limit", "jobname", "ctm", "application", "subApplication", "host", "status", "folder", "description", "jobid", "neighborhood", "depth", "direction", "orderDateFrom", "orderDateTo", "fromTime", "toTime", "folderLibrary", "hostGroup", "runAs", "command", "filePath", "fileName", "workloadPolicy", "ruleBasedCalendar", "resourceMutex", "resourceSemaphore"]);
    cli.addOperation("RunApi", "run", "getResources", "/run/resources", "Get all resources records matching search.", "", "GET", false, [new argData_1.ArgData("ctm", "string", false, "Control-M Server filter.", true, "", false),
        new argData_1.ArgData("name", "string", false, "The resource name filter.", true, "", false),
    ], "", "Search fields are ctm, name", "-s &lt;search query&gt;", "", false, "", "", ["ctm", "name"]);
    cli.addOperation("RunApi", "run", "getWaitingInfo", "/run/job/{jobId}/waitingInfo", "get the reason why the job is in waiting status", "waitingInfo", "GET", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "getWorkloadPolicies", "/run/workloadpolicies", "Get all the workload policies.", "", "GET", false, [new argData_1.ArgData("state", "string", false, "Optionally state filter. Available values Active, Inactive", false, "", false),
    ], "", "", "", "", false, "", "", ["state"]);
    cli.addOperation("RunApi", "run", "holdJob", "/run/job/{jobId}/hold", "hold the job", "hold", "POST", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "killJob", "/run/job/{jobId}/kill", "Abort job execution.", "kill", "POST", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "modifyJob", "/run/job/{jobId}/modify", "Modify active job, specified by order id according to given definitions file (JSON).", "modify", "POST", false, [new argData_1.ArgData("jobDefinitionsFile", "Buffer", true, "File that contains the definitions of the job to modify. It should be a JSON file.", false, "", false),
        new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "orderJobsInFolder", "/run/order", "Run jobs from selected folder according to given filter", "!", "POST", false, [new argData_1.ArgData("data", "OrderFolderParameters", false, "parameters to select the jobs to run", false, "", true),
    ], "{&quot;interactive&quot;:&quot;monitorPageURI&quot;}", "", "[-f &lt;configuration file&gt; -i]", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "rerunJob", "/run/job/{jobId}/rerun", "Run an already executed job (again).", "rerun", "POST", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "runJobs", "/run", "Run jobs according to given definitions file (JSON or zip).", "!", "POST", false, [new argData_1.ArgData("jobDefinitionsFile", "Buffer", true, "File that contains the definitions of the jobs to run. It can be a JSON file, or a zip file that can contain one or more JSON files, as well as account(s) information.", false, "", false),
        new argData_1.ArgData("deployDescriptorFile", "Buffer", false, "Deploy Descriptor JSON file.", false, "", false),
        new argData_1.ArgData("additionalConfiguration", "Buffer", false, "additionalConfiguration to enable skip testing for local connection profile", true, "", false),
    ], "{&quot;interactive&quot;:&quot;monitorPageURI&quot;}", "", "[-i]", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "runNow", "/run/job/{jobId}/runNow", "start a job immediately", "runNow", "POST", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "setToOK", "/run/job/{jobId}/setToOk", "set job status to OK, post processing action", "setToOk", "POST", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "undeleteJob", "/run/job/{jobId}/undelete", "recover a mark for deletion job", "undelete", "POST", false, [new argData_1.ArgData("jobId", "string", true, "The job ID", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("RunApi", "run", "updateResource", "/run/resource/{ctm}/{name}", "Update a quantitative resource.", "update", "POST", false, [new argData_1.ArgData("ctm", "string", true, "The Control-M Server hosting the resource.", false, "", false),
        new argData_1.ArgData("name", "string", true, "Resource name", false, "", false),
        new argData_1.ArgData("max", "ResourceMax", true, "The defined resource name.", false, "", true),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("SamplesApi", "samples", "addManySamples", "/samples/load", "Bulk create many samples by uploading a file.", "!", "POST", true, [new argData_1.ArgData("samplesFile", "Buffer", true, "Samples file to upload.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("SamplesApi", "samples", "addSample", "/samples", "Create a new sample in the system.", "", "POST", true, [new argData_1.ArgData("newSample", "NewSample", true, "Sample to add", false, "", true),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("SamplesApi", "samples", "deleteSample", "/samples/{sampleId}", "Deletes a single sample based on the ID supplied.", "", "DELETE", true, [new argData_1.ArgData("sampleId", "number", true, "ID of sample to delete", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("SamplesApi", "samples", "findSampleById", "/samples/{sampleId}", "Get a specific sample.", "!", "GET", true, [new argData_1.ArgData("sampleId", "number", true, "ID of the sample to return.", false, "", false),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("SamplesApi", "samples", "getSamples", "/samples", "List all samples defined in the system.", "!", "GET", true, [], "", "", "", "", false, "", "", []);
    cli.addOperation("SessionApi", "session", "doLogin", "/session/login", "Authenticate the user with the specified password and return a token that can be used later in subsequent requests to access Control-M.", "", "POST", false, [new argData_1.ArgData("credentials", "LoginCredentials", true, "The credentials to use for login.", false, "", true),
    ], "", "", "", "", false, "", "", []);
    cli.addOperation("SessionApi", "session", "doLogout", "/session/logout", "Disconnects the user session specified by the request authentication token, and removes it from the server memory.", "", "POST", false, [], "", "", "", "", false, "", "", []);
    cli.addOperation("SessionApi", "session", "updateMyPassword", "/session/user/password/update", "Change my password", "update", "POST", false, [new argData_1.ArgData("passwordsObject", "PasswordsObject", true, "The new password.", false, "", true),
    ], "", "", "", "", false, "", "", []);
};
//# sourceMappingURL=generated.js.map