var fs = require("fs");
var path = require("path");
var Promise = require("bluebird");
var constants_1 = require("../../util/constants");
var archiver = require("archiver");
var utilsCore = require("../../util/utilsCore");
var S = utilsCore.getLocaleString;
function packageDirectory(log, outputFile, deploymentDirectory) {
    outputFile = path.resolve(outputFile);
    deploymentDirectory = path.resolve(deploymentDirectory);
    if (!utilsCore.pathExistsSync(deploymentDirectory)) {
        throw new Error(S("%s does not exist", deploymentDirectory));
    }
    if (!fs.statSync(deploymentDirectory).isDirectory()) {
        throw new Error(S("%s is not a directory", deploymentDirectory));
    }
    var archive = archiver("zip");
    var write = fs.createWriteStream(outputFile);
    return new Promise(function (resolve) {
        write.on("close", function () {
            log.info(S("Successfully created %s from %s", outputFile, deploymentDirectory));
            resolve();
        });
        archive.on("error", function (err) {
            throw err;
        });
        archive.pipe(write);
        archive.glob("**/*", { cwd: deploymentDirectory, dot: true, expand: true });
        archive.finalize();
    });
}
exports.packageDirectory = packageDirectory;
function init(cli) {
    var usage = "<zipOutputFilename> <deploymentFilesDirectory>";
    cli.category("package")
        .description("Package a directory of definition files into a deployable archive")
        .command(constants_1.Constants.EMPTY_COMMAND_NAME + " " + usage)
        .description("Package a directory of definition files into a deployable archive")
        .execute(function (outputFile, deploymentDirectory) { return packageDirectory(cli.output, outputFile, deploymentDirectory); })
        .usage(usage);
}
exports.init = init;
//# sourceMappingURL=package.js.map