var environments_1 = require("../../util/environments");
var utils = require("../../util/utilsCore");
var DownloadFile = require("../../util/downloadFile");
var ProcessUtils = require("../../util/processUtils");
var path = require("path");
var $ = utils.getLocaleString;
var provision;
function provisionAction(action, imageName, controlmName, hostName, portName, cli, options) {
    cli.setupOptions(options);
    var log = cli.output;
    var configFile;
    cli.setupCommandOutput(["-v"]);
    var jarName = $("control-m.services.provision-%s.jar", utils.packageInfo().version);
    var provisionJarUrl = $("%s/utils/%s", cli.targetUrl, jarName);
    var provisionJarPath = path.resolve(utils.ctmDir(), jarName);
    var javaCommand = "";
    if (!controlmName) {
        controlmName = "";
    }
    if (!hostName) {
        hostName = "";
    }
    if (!portName) {
        portName = "";
    }
    if (options && options.file) {
        configFile = options.file;
    }
    else {
        configFile = "";
    }
    log.debug($("Locating java command"));
    ProcessUtils.locateJavaCommand().then(function (javaLocated) {
        log.info($("Located java at:%s", javaLocated));
        javaCommand = javaLocated;
        log.info($("downloading %s into %s", provisionJarUrl, provisionJarPath));
        var dl = new DownloadFile(provisionJarUrl, provisionJarPath, true);
        return dl.download();
    })
        .then(function (completionMsg) {
        log.info(completionMsg);
        var command = $("%s -jar %s -image \"%s\" -server %s -action %s -environment %s -ctms \"%s\" -name \"%s\" -port \"%s\" -cert %s -file \"%s\"", javaCommand, provisionJarPath, imageName, cli.targetUrl, action, environments_1.environments.findEnvironmentName(cli.currentEnv), controlmName, hostName, portName, environments_1.environments.getRootCertificateRequired() ? 1 : 0, configFile);
        var subject = cli.annotation["Annotation-Subject"];
        var description = cli.annotation["Annotation-Description"];
        if (subject != null && description != null) {
            command += $(" -annotationSubject \"%s\" -annotationDescription \"%s\"", subject, description);
        }
        log.debug($("starting command: %s", command));
        return ProcessUtils.exec(log, command, { stdio: "pipe" });
    })
        .then(function () { return log.info($("%s succeeded", action)); })
        .catch(function (error) {
        log.debug($("%s failed: %s", action, error));
        cli.exit(1);
    });
}
function addProvisionAction(name, args, description, action) {
    provision.command(name + " " + args).description(description)
        .option("-e, --environment <env>", "Use <env> environment for this command")
        .option("-f, --file <input file.json>", "Use input file for more detailed advanced configurations")
        .option("-a, --annotation <annotation params>", "Provide annotation fields for specified operation. Required fields: subject, description")
        .execute(action).usage(args);
}
function init(cli) {
    provision = cli.category("provision").description("Install Control-M components");
    addProvisionAction("image", "<image>", "download and install Control-M component", function (imageName, options, _) { return provisionAction("image", imageName, "", "", "", cli, options); });
    addProvisionAction("setup", "[ctm] [name] [port]", "setup the installed agent into Control-M (same as agent::setup)", function (ctmName, hostName, portName, options, _) {
        return provisionAction("setup", "", ctmName, hostName, portName, cli, options);
    });
    addProvisionAction("agent::setup", "[ctm] [name] [port]", "setup a Control-M Agent", function (ctmName, hostName, portName, options, _) {
        return provisionAction("setup", "", ctmName, hostName, portName, cli, options);
    });
    addProvisionAction("server::setup", "-f configurationFile.json", "setup a Control-M Server", function (options, _) { return provisionAction("ctm_setup", "", "", "", "", cli, options); });
    addProvisionAction("install", "<image> [ctm] [name] [port]", "download, install and setup Control-M component", function (imageName, ctmName, hostName, portName, options, _) {
        return provisionAction("install", imageName, ctmName, hostName, portName, cli, options);
    });
    addProvisionAction("agent::install", "<image> [ctm] [name] [port]", "download, install and setup Control-M component", function (imageName, ctmName, hostName, portName, options, _) {
        return provisionAction("install", imageName, ctmName, hostName, portName, cli, options);
    });
    addProvisionAction("server::install", "<image> -f configurationFile.json", "install a new Control-M Server", function (imageName, options, _) { return provisionAction("ctm_install", imageName, "", "", "", cli, options); });
    addProvisionAction("image::remove", " ", "uninstall a Control-M component", function (options, _) { return provisionAction("image::remove", "None", "", "", "", cli, options); });
    addProvisionAction("uninstall", " ", "detach component from Control-M and uninstall", function (options, _) { return provisionAction("uninstall", "", "", "", "", cli, options); });
    addProvisionAction("agent::uninstall", " ", "detach component from Control-M and uninstall", function (options, _) { return provisionAction("uninstall", "", "", "", "", cli, options); });
    addProvisionAction("server::uninstall", "[ctm]", "detach Control-M/Server from Control-M and uninstall", function (ctmName, options, _) { return provisionAction("ctm_uninstall", "", ctmName, "", "", cli, options); });
}
exports.init = init;
//# sourceMappingURL=provision.js.map