"use strict";
var api_1 = require("../../api");
var cli;
var log;
var reportingCategory;
function sleep(milliseconds) {
    var start = new Date().getTime();
    while ((new Date().getTime() - start) < milliseconds) { }
}
function waitForReport(reportingApi, reportId) {
    return reportingApi.getReportStatus(cli.annotation, reportId).then(function (statusResponse) {
        if (statusResponse.body.status === 'PENDING' || statusResponse.body.status === 'PROCESSING') {
            sleep(10000);
            return waitForReport(reportingApi, reportId);
        }
        else {
            return statusResponse;
        }
    });
}
function getReportByName(name, format, options, callback) {
    try {
        cli.setupOptions(options);
        cli.additionalYamlProps = { "outputfile": "url" };
        var runReport = new api_1.RunReport(name, format);
        if (options && options.file) {
            var input = cli.fileDataContent;
            if (input) {
                runReport.filters = input.filters;
                runReport.dateTimeSettings = input.dateTimeSettings;
                if (!format) {
                    runReport.format = input.format;
                }
            }
        }
        if (!runReport.format) {
            runReport.format = "csv";
        }
        var env = cli.currentEnv;
        new api_1.SessionApi('', env.endPoint).doLogin({}, new api_1.LoginCredentials(env.user, env.decriptedPassword)).then(function (loginResult) {
            var reportingApi = new api_1.ReportingApi("", env.endPoint);
            cli.setApiKey(reportingApi, loginResult.body.token);
            reportingApi.runReport(cli.annotation, runReport).then(function (submitResult) {
                waitForReport(reportingApi, submitResult.body.reportId).then(cli.successHandler).catch(cli.errorHandler);
            }).catch(cli.errorHandler);
        }).catch(cli.errorHandler)
            .disposer(function () {
            var logout = new api_1.SessionApi('', env.endPoint);
            logout.apiKey = cli.authentications.Bearer.apiKey;
            return logout.doLogout(cli.annotation);
        });
    }
    catch (exception) {
        cli.errorHandler(exception);
    }
}
function init(cliToUse) {
    cli = cliToUse;
    log = cli.output;
    reportingCategory = cli
        .category("reporting")
        .description("Generate Control-M reports");
    reportingCategory.command("report::get <name> [format] -f -o")
        .description("Retrieves a report by name in the desired format (CSV,PDF or EXCEL). If the report is shared, add [shared:] before the name.")
        .option("-f, --file <input file.json>", "Use input file for more detailed advanced configurations")
        .option("-o, --outputfile <file path>", "Download results to file")
        .option("-e, --environment <env>", "Use <env> environment for this command")
        .execute(getReportByName)
        .usage("<name> [format] -f <configuration_file> -o");
}
exports.init = init;
//# sourceMappingURL=reporting-service.js.map