"use strict";
var api_1 = require("../../api");
var promptData_1 = require("../../util/promptData");
var utilsCore = require('../../util/utilsCore');
var cli;
function doLogin(options) {
    try {
        cli.setupOptions(options);
        var env = cli.currentEnv;
        var credentials = new api_1.LoginCredentials(env.user, env.decriptedPassword);
        new api_1.SessionApi("", env.endPoint, undefined, undefined, env).doLogin(cli.annotation, credentials).then(cli.successHandler).catch(cli.errorHandler);
    }
    catch (exception) {
        cli.errorHandler(exception);
    }
}
function doLogout(token, options, callback) {
    try {
        cli.setupOptions(options);
        var env = cli.currentEnv;
        var sessionApi = new api_1.SessionApi("", env.endPoint);
        cli.setApiKey(sessionApi, token);
        sessionApi.doLogout(cli.annotation).then(cli.successHandler).catch(cli.errorHandler);
    }
    catch (exception) {
        cli.errorHandler(exception);
    }
}
function doUpdateMyPassword(currentPassword, newPassword, options, callback) {
    try {
        var env = cli.currentEnv;
        var sessionApi = new api_1.SessionApi("", env.endPoint);
        var passwordsObject = new api_1.PasswordsObject();
        passwordsObject.user = env.user;
        if (options.prompt) {
            var promptDataArray = new Array();
            promptDataArray.push(new promptData_1.PromptData("Current password", false));
            promptDataArray.push(new promptData_1.PromptData("New password", true));
            cli.processPromisesArray(promptDataArray, utilsCore.promptWithValidate).then(function (values) {
                passwordsObject.currentPassword = values[0];
                passwordsObject.newPassword = values[1];
                sessionApi.updateMyPassword(cli.annotation, passwordsObject).then(function (response) {
                    cli.successHandler(response, passwordsObject.newPassword);
                }).catch(cli.errorHandler);
            }).catch(cli.errorHandler);
        }
        else {
            passwordsObject.currentPassword = currentPassword;
            passwordsObject.newPassword = newPassword;
            sessionApi.updateMyPassword(cli.annotation, passwordsObject).then(function (response) {
                cli.successHandler(response, newPassword);
            }).catch(cli.errorHandler);
        }
    }
    catch (exception) {
        cli.errorHandler(exception);
    }
}
function init(cliToUse) {
    cli = cliToUse;
    var sessionCategory = cli
        .category("session")
        .description("Manually maintain Control-M user sessions");
    sessionCategory.command("login")
        .description("Login to Control-M and return a session token that can later be used using the -t option")
        .option("-e, --environment <env>", "Use <env> environment for this command")
        .execute(doLogin)
        .usage(" ");
    sessionCategory.command("logout <token>")
        .description("Logout from the user session specified by the given token")
        .option("-e, --environment <env>", "Use <env> environment for this command")
        .execute(doLogout)
        .usage("<token>");
    sessionCategory.command("user:password::update [currentPassword] [newPassword]")
        .description("Change my password")
        .option("-p, --prompt ", "Use prompt for this command")
        .execute(doUpdateMyPassword)
        .usage("[currentPassword] [newPassword]");
}
exports.init = init;
//# sourceMappingURL=session.js.map