function buildUsage(arg, operationId) {
    var hiddenIndex = arg.description ? arg.description.indexOf('HIDDEN') : -1;
    var hiddenListExist = false;
    if (hiddenIndex > -1) {
        var pipeIndex = arg.description.indexOf("|", hiddenIndex);
        var subStringLength = pipeIndex > -1 ? (pipeIndex - hiddenIndex) : arg.description.length;
        var hidden = arg.description.substr(hiddenIndex, subStringLength);
        hiddenListExist = hidden.indexOf(':') > -1;
        if (hiddenListExist && hidden.toUpperCase().indexOf(operationId.toUpperCase()) > -1) {
            return '';
        }
    }
    var requieredIndex = arg.description ? arg.description.indexOf('REQUIRED') : -1;
    var requieredListExist = false;
    if (requieredIndex > -1) {
        var pipeIndex = arg.description.indexOf("|", requieredIndex);
        var subStringLength = pipeIndex > -1 ? (pipeIndex - requieredIndex) : arg.description.length;
        var requierd = arg.description.substr(requieredIndex, subStringLength);
        requieredListExist = requierd.indexOf(':') > -1;
        if (requieredListExist && requierd.toUpperCase().indexOf(operationId.toUpperCase()) > -1) {
            return '<' + arg.name + '>';
        }
    }
    if (arg.hidden || (arg.description && arg.description.indexOf('HIDDEN') > -1) && !hiddenListExist)
        return '';
    return (arg.required || arg.description && arg.description.indexOf('REQUIRED') > -1 && !requieredListExist) ? '<' + arg.name + '>' : '[' + arg.name + ']';
}
exports.buildUsage = buildUsage;
//# sourceMappingURL=buildUsage.js.map