var utilsCore = require("./utilsCore");
var path = require("path");
var fs = require("fs");
var Configuration = (function () {
    function Configuration() {
    }
    Configuration.getConfigurationFile = function () {
        return path.join(utilsCore.ctmDir(), "conf.json");
    };
    Configuration.getCliConfigurations = function () {
        var confFile = this.getConfigurationFile();
        var ret = utilsCore.readJsonFile(confFile);
        return ret || { localServerLocation: "" };
    };
    Configuration.saveCliConfigurations = function (conf) {
        var confFile = this.getConfigurationFile();
        var ctmPath = utilsCore.ctmDir();
        if (!utilsCore.pathExistsSync(ctmPath)) {
            fs.mkdirSync(ctmPath, 502);
        }
        utilsCore.writeJsonFile(conf, confFile);
    };
    return Configuration;
})();
exports.Configuration = Configuration;
//# sourceMappingURL=configuration.js.map