"use strict";
var fs = require("fs");
var request = require("request");
var Promise = require("bluebird");
var readline = require("readline");
var utilsCore = require("./utilsCore");
var S = utilsCore.getLocaleString;
var DownloadFile2 = (function () {
    function DownloadFile2(url, savingLocation, isShowProgram) {
        this.url = url;
        this.savingLocation = savingLocation;
        this.endDownload = false;
        this.isShowProgress = isShowProgram;
    }
    DownloadFile2.writeSingleLine = function (msg) {
        readline.clearLine(process.stdout, 0);
        process.stdout.write("\r" + msg);
    };
    DownloadFile2.prototype.download = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var progressMessage = "";
            var progressPrecent = 0;
            var isShowProgress = _this.isShowProgress;
            var out = fs.createWriteStream(_this.savingLocation);
            var req = request({
                method: "GET",
                uri: _this.url,
            });
            req.pipe(out);
            var currentSize = 0;
            var totalSize = 0;
            var totalSizeInMb = 0;
            var lastPer = 101;
            req.on("data", function (chunk) {
                currentSize += chunk.length;
                progressPrecent = Math.round((currentSize / totalSize) * 100);
                if (lastPer !== progressPrecent || progressPrecent === 100) {
                    progressMessage = S("%dMB/%dMB precent: %d\%", Math.round(currentSize / 1024 / 1024), totalSizeInMb, progressPrecent);
                    if (isShowProgress) {
                        DownloadFile2.writeSingleLine(progressMessage);
                    }
                    lastPer = progressPrecent;
                }
            });
            req.on("response", function (response) {
                totalSize = response.headers["content-length"];
                totalSizeInMb = Math.round(totalSize / 1024 / 1024);
                if (response.statusCode !== 200) {
                    var body = null;
                    response.on('data', function (chunk) {
                        body = chunk.toString();
                    });
                    response.on('end', function () {
                        var message = response.statusMessage;
                        message = message ? message : response.statusCode === 404 ? "Not Found" : "";
                        if ((message === null || message === "") && response.statusCode === 502 && body != null) {
                            var jsonMsg = null;
                            try {
                                jsonMsg = JSON.parse(body);
                            }
                            catch (e) {
                            }
                            if (jsonMsg != null && jsonMsg.errors) {
                                message = jsonMsg.errors[0].message;
                            }
                            else {
                                message = "Failed to reach backend server.";
                            }
                        }
                        DownloadFile2.writeSingleLine("");
                        reject(S("Download failed. StatusCode %d: %s", response.statusCode, message));
                    });
                }
            });
            req.on("end", function () {
                DownloadFile2.writeSingleLine("");
                if (progressPrecent === 100) {
                    setTimeout(function (_) { return resolve(progressMessage); }, 5000);
                }
                else {
                    reject(S("could not download file: %s", progressMessage));
                }
            });
            req.on("abort", function () {
                reject("abort");
            });
            req.on("error", function (e) {
                reject(JSON.stringify(e));
            });
            req.on("timeout", function () {
                reject("timeout");
            });
        });
    };
    return DownloadFile2;
})();
module.exports = DownloadFile2;
//# sourceMappingURL=downloadFile.js.map