"use strict";
var Promise = require("bluebird");
var readline = require("readline");
var child_process = require("child_process");
var utilsCore = require("./utilsCore");
var S = utilsCore.getLocaleString;
var ProcessUtils = (function () {
    function ProcessUtils() {
    }
    ProcessUtils.shellCommandsSeperator = function () {
        if (utilsCore.isWindows) {
            return "&";
        }
        else {
            return ";";
        }
    };
    ProcessUtils.checkJavaVersionMinimum = function (javaVersionString, minMajor, minMinor) {
        try {
            var firstline = javaVersionString.split("\n")[0];
            if (firstline.indexOf("-ea") > 0) {
                return false;
            }
            if (firstline.indexOf("version") < 0) {
                return false;
            }
            var fullJavaVersion = firstline.match(/\d+\.\d+\.\d+/g);
            var majorJavaVersion = firstline.match(/version "?\d{1,2}"?/);
            if (fullJavaVersion != null) {
                var versionParts = fullJavaVersion[0].split(".");
                var major = parseInt(versionParts[0], 10);
                var minor = parseInt(versionParts[1], 10);
                if (major > minMajor) {
                    return true;
                }
                if (major === minMajor && minor >= minMinor) {
                    return true;
                }
            }
            else if (majorJavaVersion != null) {
                var versionParts = majorJavaVersion[0].split(" ");
                var verString = versionParts[1].replace(/['"]+/g, '');
                var major = parseInt(verString, 10);
                if (major > minMajor) {
                    return true;
                }
            }
        }
        catch (err) {
        }
        return false;
    };
    ;
    ProcessUtils.javaVersionCommand = function (javaCommand) {
        var sCommand = javaCommand.replace(/(\r\n|\n|\r)/gm, " ");
        sCommand = S("%s -version", sCommand);
        return ProcessUtils.exec(null, sCommand, { stdio: "pipe" });
    };
    ProcessUtils.locateJavaCommand = function () {
        return new Promise(function (resolve, reject) {
            var errorMsg = "Java not found. Java version 1.8 and above is required. Early Access builds are not supported";
            var javaLocations = [];
            var javaLocateCmd = "echo \"$JAVA_HOME/bin/java\"; which java; exit 0";
            if (utilsCore.isWindows) {
                javaLocateCmd = "echo \"%JAVA_HOME%\\bin\\java\"& where java& exit 0";
            }
            if (utilsCore.isMac) {
                javaLocateCmd = "export JAVA_HOME=$(/usr/libexec/java_home); echo \"$JAVA_HOME/jre/bin/java\";exit 0";
            }
            ProcessUtils.exec(null, javaLocateCmd, { stdio: "pipe" })
                .then(function (javaLocationOut) {
                javaLocations = javaLocationOut.split("\n").map(function (line) { return line.replace(/(\r)/gm, " "); });
                if (javaLocations.length && javaLocations[javaLocations.length - 1] === "") {
                    javaLocations.pop();
                }
                if (javaLocations.length === 0) {
                    reject(errorMsg);
                }
                var promises = javaLocations.map(function (javaCmd) { return ProcessUtils.exec(null, S("%s -version %s exit 0", javaCmd, ProcessUtils.shellCommandsSeperator()), { stdio: "pipe" }); });
                return Promise.all(promises);
            })
                .then(function (javaVerStrs) {
                for (var i = 0; i < javaVerStrs.length; i++) {
                    if (ProcessUtils.checkJavaVersionMinimum(javaVerStrs[i], 1, 8)) {
                        resolve(javaLocations[i]);
                        return;
                    }
                }
                reject(errorMsg);
            })
                .catch(function (err) {
                var errStr = JSON.stringify(err, undefined, 2);
                reject(errorMsg + ": " + errStr);
            });
        });
    };
    ProcessUtils.exec = function (log, command, options) {
        var cmd = command;
        return new Promise(function (resolve, reject) {
            var sOut = "";
            var sErr = "";
            var printLine = "";
            var child = child_process.exec(command, options);
            child.stdout.on("data", function (data) {
                if (log && log.info) {
                    data = data.replace("\n", "").replace("\r", "");
                    if (data.indexOf("~~~!!!", 0) !== -1) {
                        printLine = data.replace("~~~!!!", "");
                        readline.clearLine(process.stdout, 0);
                        process.stdout.write("\r" + printLine + "\r");
                    }
                    else if (data.trim() !== "") {
                        log.info(data);
                    }
                }
                sOut += data;
            });
            child.stderr.on("data", function (data) {
                if (log && log.error) {
                    log.error(data);
                }
                sErr += data;
            });
            child.on("close", function (code) {
                if (code === 0) {
                    if (log && log.info) {
                        log.info(S("exit code: %d", code));
                    }
                    resolve(sOut + sErr);
                }
                else {
                    reject(S("exit code: %d for \'%s\'", code, cmd));
                }
            });
        });
    };
    return ProcessUtils;
})();
module.exports = ProcessUtils;
//# sourceMappingURL=processUtils.js.map