var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var winston_1 = require("winston");
var winston = require("winston");
var common = require("winston/lib/winston/common");
var fs = require("fs");
var Silly = (function (_super) {
    __extends(Silly, _super);
    function Silly(options) {
        _super.call(this, options);
        options = options || {};
        this.truncated = false;
        this.name = "silly";
        this.output = "";
        this.json = options.json !== undefined ? options.json : false;
        this.colorize = options.colorize !== undefined ? options.colorize : false;
        this.prettyPrint = options.prettyPrint !== undefined ? options.prettyPrint : false;
        this.stripColors = options.stripColors !== undefined ? options.stripColors : true;
        this.timestamp = options.timestamp !== undefined ? options.timestamp : true;
        this.level = options.level !== undefined ? options.level : "silly";
        this.silent = options.silent !== undefined ? options.silent : false;
        this.raw = options.raw !== undefined ? options.raw : false;
        if (this.json) {
            var identStrigify = function (obj) { return JSON.stringify(obj, null, 2); };
            this.stringify = options.stringify || identStrigify;
        }
    }
    Silly.prototype.log = function (level, msg, meta, callback) {
        if (this.silent || this.truncated) {
            return callback(null, true);
        }
        var incomingLog = common.log({
            colorize: this.colorize,
            json: (level === "data") ? true : this.json,
            level: level,
            message: msg,
            meta: meta,
            prettyPrint: this.prettyPrint,
            raw: this.raw,
            stringify: this.stringify,
            timestamp: (level === "data") ? false : this.timestamp,
        });
        if (this.shouldTruncate(incomingLog)) {
            this.output += "\n...truncated...";
            this.truncated = true;
            return callback(null, true);
        }
        if (this.stripColors) {
            var code = /\u001b\[(\d+(;\d+)*)?m/g;
            this.output += incomingLog.replace(code, "");
        }
        else {
            this.output += incomingLog;
        }
        this.output += "\n";
        this.emit("logged");
        callback(null, true);
    };
    ;
    Silly.prototype.clear = function () {
        this.output = "";
        this.truncated = false;
    };
    ;
    Silly.prototype.writeToFile = function (filename, append) {
        var writeFileFunction = append ? fs.appendFileSync : fs.writeFileSync;
        writeFileFunction(filename, this.output);
        this.clear();
    };
    ;
    Silly.prototype.shouldTruncate = function (incomingLog) {
        var length = this.output.length;
        if (incomingLog) {
            length += incomingLog.length;
        }
        return length > 1024 * 1024;
    };
    ;
    Silly.prototype.getLogData = function () {
        return this.output;
    };
    return Silly;
})(winston_1.Transport);
exports.Silly = Silly;
;
winston.transports.Silly = Silly;
//# sourceMappingURL=sillyTransport.js.map