var fs = require("fs");
var path = require("path");
var util = require("util");
var os = require("os");
var crypto = require('crypto');
var ctmCli;
(function (ctmCli) {
    var packageJson = require("../../package.json");
    exports.isWindows = require("os").platform() === "win32";
    exports.isMac = require("os").platform() === "darwin";
    exports.escape_url_for_shell = function (url) {
        var sepHttp = "://";
        var retUrl = url;
        var urlParts = url.split(sepHttp);
        if (urlParts.length > 1) {
            retUrl = util.format("%s%s\"%s\"", urlParts[0], sepHttp, urlParts[1]);
        }
        return retUrl;
    };
    exports.getEncriptionKeyFilePath = function () {
        return path.join(exports.ctmDir(), "env.key");
    };
    exports.getEncriptionKey = function () {
        var filePath = path.join(exports.ctmDir(), "env.key");
        var key;
        if (!exports.pathExistsSync(filePath)) {
            key = new Date().getMilliseconds().toString();
            fs.writeFileSync(filePath, key);
        }
        else {
            key = fs.readFileSync(filePath);
        }
        return key;
    };
    exports.decrypt = function (str) {
        var buffer = new Buffer(str, 'base64');
        var decipher = crypto.createDecipher('aes-256-ctr', exports.getEncriptionKey());
        var dec = Buffer.concat([decipher.update(buffer), decipher.final()]);
        return String.fromCharCode.apply(null, new Uint16Array(dec));
    };
    exports.encrypt = function (str) {
        var cipher = crypto.createCipher('aes-256-ctr', exports.getEncriptionKey());
        var crypted = Buffer.concat([cipher.update(str), cipher.final()]);
        return crypted.toString("base64");
    };
    exports.launchBrowser = function (url) {
        url = exports.escape_url_for_shell(url);
        var exec = require("child_process").exec;
        var startCmd = exports.isWindows ? "start" : (exports.isMac ? "open" : "xdg-open");
        var browserCmd = [startCmd, url].join(" ");
        var child = exec(browserCmd, { timeout: 5000 });
        child.unref();
    };
    exports.launchBrowserPromis = function (url) {
        url = exports.escape_url_for_shell(url);
        var exec = require("child_process").exec;
        var startCmd = exports.isWindows ? "start" : (exports.isMac ? "open" : "xdg-open");
        var browserCmd = [startCmd, url].join(" ");
        var ProcessUtils = require("../../lib/util/processUtils");
        return new ProcessUtils.exec(null, browserCmd, { timeout: 5000 });
    };
    exports.camelcase = function (flag) {
        if (!flag) {
            return "";
        }
        return flag.split("-").reduce(function (str, word) {
            return str + word[0].toUpperCase() + word.slice(1);
        });
    };
    exports.binDir = function () {
        return path.resolve(__dirname, "../../bin");
    };
    exports.packageInfo = function () {
        return packageJson;
    };
    exports.ctmDir = function () {
        var dir = process.env.CTM_CONFIG_DIR ||
            path.join(exports.homeFolder(), ".ctm");
        if (!exports.pathExistsSync(dir)) {
            fs.mkdirSync(dir, 502);
        }
        return dir;
    };
    exports.homeFolder = function () {
        if (process.env.HOME !== undefined) {
            return process.env.HOME;
        }
        if (os.homedir()) {
            return os.homedir();
        }
        if (process.env.HOMEDRIVE && process.env.HOMEPATH) {
            return process.env.HOMEDRIVE + process.env.HOMEPATH;
        }
        throw new Error("No HOME path available");
    };
    exports.pathExistsSync = function (path) {
        try {
            fs.statSync(path);
            return true;
        }
        catch (err) {
            return false;
        }
    };
    exports.getFiles = function (scanPath, recursively) {
        var results = [];
        var files = fs.readdirSync(scanPath);
        files.forEach(function (file) {
            file = path.join(scanPath, file);
            if (fs.statSync(file).isDirectory()) {
                if (recursively) {
                    var childFiles = exports.getFiles(file);
                    results.push.apply(results, childFiles);
                }
            }
            else {
                results.push(file);
            }
        });
        return results;
    };
    var locale = require("../locales/en-us.json");
    exports.getLocaleString = function (format) {
        var params = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            params[_i - 1] = arguments[_i];
        }
        var result;
        if (locale) {
            result = locale[format];
        }
        if (!result) {
            if (process.env.CTM_DEBUG_LABELS) {
                throw new Error(util.format("Invalid resource %s", format));
            }
            result = format;
        }
        if (params && params.length) {
            result = util.format.apply(util, [result].concat(params));
        }
        return result;
    };
    exports.writeJsonFile = function (json, file) {
        fs.writeFileSync(file, JSON.stringify(json, null, 2));
    };
    exports.readJsonFile = function (file) {
        try {
            return require(file);
        }
        catch (error) {
            return undefined;
        }
    };
    var promptly = require("promptly");
    function PromptWithAstrix(query) {
        return promptly.password(query + ': ', { replace: '*' });
    }
    exports.promptWithValidate = function (promptData) {
        return new Promise(function (resolve, reject) {
            PromptWithAstrix(promptData.label).then(function (ans) {
                var value = "";
                value = ans;
                if (promptData.validate) {
                    PromptWithAstrix("Retype " + promptData.label.toLowerCase()).then(function (ans) {
                        if (value !== ans) {
                            reject(promptData.label + " does not match");
                        }
                        resolve(value);
                    });
                }
                else {
                    resolve(value);
                }
            });
        });
    };
})(ctmCli || (ctmCli = {}));
//# sourceMappingURL=utilsCore.js.map